/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.permission.ApplicationPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ClusterPermission;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsCache;
import org.elasticsearch.xpack.core.security.authz.permission.IndicesPermission;
import org.elasticsearch.xpack.core.security.authz.permission.ResourcePrivilegesMap;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.authz.permission.RunAsPermission;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilegeDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class LimitedRole
implements Role {
    private final Role baseRole;
    private final Role limitedByRole;

    public LimitedRole(Role baseRole, Role limitedByRole) {
        this.baseRole = Objects.requireNonNull(baseRole);
        this.limitedByRole = Objects.requireNonNull(limitedByRole, "limited by role is required to create limited role");
    }

    @Override
    public String[] names() {
        return this.limitedByRole.names();
    }

    @Override
    public ClusterPermission cluster() {
        throw new UnsupportedOperationException("cannot retrieve cluster permission on limited role");
    }

    @Override
    public IndicesPermission indices() {
        throw new UnsupportedOperationException("cannot retrieve indices permission on limited role");
    }

    @Override
    public ApplicationPermission application() {
        throw new UnsupportedOperationException("cannot retrieve application permission on limited role");
    }

    @Override
    public RunAsPermission runAs() {
        throw new UnsupportedOperationException("cannot retrieve run_as permission on limited role");
    }

    @Override
    public boolean hasFieldOrDocumentLevelSecurity() {
        return this.baseRole.hasFieldOrDocumentLevelSecurity() || this.limitedByRole.hasFieldOrDocumentLevelSecurity();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LimitedRole that = (LimitedRole)o;
        return this.baseRole.equals(that.baseRole) && this.limitedByRole.equals(that.limitedByRole);
    }

    public int hashCode() {
        return Objects.hash(this.baseRole, this.limitedByRole);
    }

    @Override
    public IndicesAccessControl authorize(String action, Set<String> requestedIndicesOrAliases, Map<String, IndexAbstraction> aliasAndIndexLookup, FieldPermissionsCache fieldPermissionsCache) {
        IndicesAccessControl indicesAccessControl = this.baseRole.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
        IndicesAccessControl limitedByIndicesAccessControl = this.limitedByRole.authorize(action, requestedIndicesOrAliases, aliasAndIndexLookup, fieldPermissionsCache);
        return indicesAccessControl.limitIndicesAccessControl(limitedByIndicesAccessControl);
    }

    @Override
    public Predicate<IndexAbstraction> allowedIndicesMatcher(String action) {
        Predicate<IndexAbstraction> predicate = this.baseRole.indices().allowedIndicesMatcher(action);
        predicate = predicate.and(this.limitedByRole.indices().allowedIndicesMatcher(action));
        return predicate;
    }

    @Override
    public Automaton allowedActionsMatcher(String index) {
        Automaton allowedMatcher = this.baseRole.allowedActionsMatcher(index);
        Automaton limitedByMatcher = this.limitedByRole.allowedActionsMatcher(index);
        return Automatons.intersectAndMinimize(allowedMatcher, limitedByMatcher);
    }

    @Override
    public boolean checkIndicesAction(String action) {
        return this.baseRole.checkIndicesAction(action) && this.limitedByRole.checkIndicesAction(action);
    }

    @Override
    public ResourcePrivilegesMap checkIndicesPrivileges(Set<String> checkForIndexPatterns, boolean allowRestrictedIndices, Set<String> checkForPrivileges) {
        ResourcePrivilegesMap resourcePrivilegesMap = this.baseRole.indices().checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges);
        ResourcePrivilegesMap resourcePrivilegesMapForLimitedRole = this.limitedByRole.indices().checkResourcePrivileges(checkForIndexPatterns, allowRestrictedIndices, checkForPrivileges);
        return ResourcePrivilegesMap.intersection(resourcePrivilegesMap, resourcePrivilegesMapForLimitedRole);
    }

    @Override
    public boolean checkClusterAction(String action, TransportRequest request, Authentication authentication) {
        return this.baseRole.checkClusterAction(action, request, authentication) && this.limitedByRole.checkClusterAction(action, request, authentication);
    }

    @Override
    public boolean grants(ClusterPrivilege clusterPrivilege) {
        return this.baseRole.grants(clusterPrivilege) && this.limitedByRole.grants(clusterPrivilege);
    }

    @Override
    public ResourcePrivilegesMap checkApplicationResourcePrivileges(String applicationName, Set<String> checkForResources, Set<String> checkForPrivilegeNames, Collection<ApplicationPrivilegeDescriptor> storedPrivileges) {
        ResourcePrivilegesMap resourcePrivilegesMap = this.baseRole.application().checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges);
        ResourcePrivilegesMap resourcePrivilegesMapForLimitedRole = this.limitedByRole.application().checkResourcePrivileges(applicationName, checkForResources, checkForPrivilegeNames, storedPrivileges);
        return ResourcePrivilegesMap.intersection(resourcePrivilegesMap, resourcePrivilegesMapForLimitedRole);
    }

    @Override
    public boolean checkRunAs(String runAs) {
        return this.baseRole.checkRunAs(runAs) && this.limitedByRole.checkRunAs(runAs);
    }
}

