/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.accesscontrol;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.cache.RemovalNotification;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.MatchAllRoleBitSet;

public final class DocumentSubsetBitsetCache
implements IndexReader.ClosedListener,
Closeable,
Accountable {
    static final Setting<TimeValue> CACHE_TTL_SETTING = Setting.timeSetting((String)"xpack.security.dls.bitset.cache.ttl", (TimeValue)TimeValue.timeValueHours((long)2L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    static final Setting<ByteSizeValue> CACHE_SIZE_SETTING = Setting.memorySizeSetting((String)"xpack.security.dls.bitset.cache.size", (String)"10%", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final BitSet NULL_MARKER = new FixedBitSet(0);
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ReleasableLock cacheEvictionLock;
    private final ReleasableLock cacheModificationLock;
    private final ExecutorService cleanupExecutor;
    private final long maxWeightBytes;
    private final Cache<BitsetCacheKey, BitSet> bitsetCache;
    private final Map<IndexReader.CacheKey, Set<BitsetCacheKey>> keysByIndex;
    private final AtomicLong cacheFullWarningTime;

    public DocumentSubsetBitsetCache(Settings settings, ThreadPool threadPool) {
        this(settings, threadPool.executor("generic"));
    }

    protected DocumentSubsetBitsetCache(Settings settings, ExecutorService cleanupExecutor) {
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this.cacheEvictionLock = new ReleasableLock((Lock)readWriteLock.writeLock());
        this.cacheModificationLock = new ReleasableLock((Lock)readWriteLock.readLock());
        this.cleanupExecutor = cleanupExecutor;
        TimeValue ttl = (TimeValue)CACHE_TTL_SETTING.get(settings);
        this.maxWeightBytes = ((ByteSizeValue)CACHE_SIZE_SETTING.get(settings)).getBytes();
        this.bitsetCache = CacheBuilder.builder().setExpireAfterAccess(ttl).setMaximumWeight(this.maxWeightBytes).weigher((key, bitSet) -> bitSet == NULL_MARKER ? 0L : bitSet.ramBytesUsed()).removalListener(this::onCacheEviction).build();
        this.keysByIndex = new ConcurrentHashMap<IndexReader.CacheKey, Set<BitsetCacheKey>>();
        this.cacheFullWarningTime = new AtomicLong(0L);
    }

    public void onClose(IndexReader.CacheKey ownerCoreCacheKey) {
        Set<BitsetCacheKey> keys = this.keysByIndex.remove(ownerCoreCacheKey);
        if (keys != null) {
            keys.forEach(arg_0 -> this.bitsetCache.invalidate(arg_0));
        }
    }

    private void onCacheEviction(RemovalNotification<BitsetCacheKey, BitSet> notification) {
        BitsetCacheKey bitsetKey = (BitsetCacheKey)notification.getKey();
        IndexReader.CacheKey indexKey = bitsetKey.index;
        if (!this.keysByIndex.getOrDefault(indexKey, Set.of()).contains(bitsetKey)) {
            return;
        }
        this.cleanupExecutor.submit(() -> {
            try (ReleasableLock ignored = this.cacheEvictionLock.acquire();){
                if (this.bitsetCache.get((Object)bitsetKey) == null) {
                    this.keysByIndex.getOrDefault(indexKey, Set.of()).remove(bitsetKey);
                }
            }
        });
    }

    @Override
    public void close() {
        this.clear("close");
    }

    public void clear(String reason) {
        this.logger.debug("clearing all DLS bitsets because [{}]", (Object)reason);
        this.keysByIndex.clear();
        this.bitsetCache.invalidateAll();
    }

    int entryCount() {
        return this.bitsetCache.count();
    }

    public long ramBytesUsed() {
        return this.bitsetCache.weight();
    }

    @Nullable
    public BitSet getBitSet(Query query, LeafReaderContext context) throws ExecutionException {
        IndexReader.CacheHelper coreCacheHelper = context.reader().getCoreCacheHelper();
        if (coreCacheHelper == null) {
            try {
                return this.computeBitSet(query, context);
            }
            catch (IOException e) {
                throw new ExecutionException(e);
            }
        }
        coreCacheHelper.addClosedListener((IndexReader.ClosedListener)this);
        IndexReader.CacheKey indexKey = coreCacheHelper.getKey();
        BitsetCacheKey cacheKey = new BitsetCacheKey(indexKey, query);
        try (ReleasableLock ignored = this.cacheModificationLock.acquire();){
            BitSet bitSet = (BitSet)this.bitsetCache.computeIfAbsent((Object)cacheKey, ignore1 -> {
                this.keysByIndex.compute(indexKey, (ignore2, set) -> {
                    if (set == null) {
                        set = Sets.newConcurrentHashSet();
                    }
                    set.add(cacheKey);
                    return set;
                });
                BitSet result = this.computeBitSet(query, context);
                if (result == null) {
                    return NULL_MARKER;
                }
                long bitSetBytes = result.ramBytesUsed();
                if (bitSetBytes > this.maxWeightBytes) {
                    this.logger.warn("built a DLS BitSet that uses [{}] bytes; the DLS BitSet cache has a maximum size of [{}] bytes; this object cannot be cached and will need to be rebuilt for each use; consider increasing the value of [{}]", (Object)bitSetBytes, (Object)this.maxWeightBytes, (Object)CACHE_SIZE_SETTING.getKey());
                } else if (bitSetBytes + this.bitsetCache.weight() > this.maxWeightBytes) {
                    this.maybeLogCacheFullWarning();
                }
                return result;
            });
            if (bitSet == NULL_MARKER) {
                BitSet bitSet2 = null;
                return bitSet2;
            }
            BitSet bitSet3 = bitSet;
            return bitSet3;
        }
    }

    @Nullable
    private BitSet computeBitSet(Query query, LeafReaderContext context) throws IOException {
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Query rewrittenQuery = searcher.rewrite(query);
        if (DocumentSubsetBitsetCache.isEffectiveMatchAllDocsQuery(rewrittenQuery)) {
            return new MatchAllRoleBitSet(context.reader().maxDoc());
        }
        Weight weight = searcher.createWeight(rewrittenQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer s = weight.scorer(context);
        if (s == null) {
            return null;
        }
        return DocumentSubsetBitsetCache.bitSetFromDocIterator(s.iterator(), context.reader().maxDoc());
    }

    static boolean isEffectiveMatchAllDocsQuery(Query rewrittenQuery) {
        if (rewrittenQuery instanceof ConstantScoreQuery && ((ConstantScoreQuery)rewrittenQuery).getQuery() instanceof MatchAllDocsQuery) {
            return true;
        }
        return rewrittenQuery instanceof MatchAllDocsQuery;
    }

    private void maybeLogCacheFullWarning() {
        long now;
        long nextLogTime = this.cacheFullWarningTime.get();
        if (nextLogTime > (now = System.currentTimeMillis())) {
            return;
        }
        long nextCheck = now + TimeUnit.MINUTES.toMillis(30L);
        if (this.cacheFullWarningTime.compareAndSet(nextLogTime, nextCheck)) {
            this.logger.info("the Document Level Security BitSet cache is full which may impact performance; consider increasing the value of [{}]", (Object)CACHE_SIZE_SETTING.getKey());
        }
    }

    public static List<Setting<?>> getSettings() {
        return List.of(CACHE_TTL_SETTING, CACHE_SIZE_SETTING);
    }

    public Map<String, Object> usageStats() {
        ByteSizeValue ram = new ByteSizeValue(this.ramBytesUsed(), ByteSizeUnit.BYTES);
        return Map.of("count", this.entryCount(), "memory", ram.toString(), "memory_in_bytes", ram.getBytes());
    }

    void verifyInternalConsistency() {
        this.bitsetCache.keys().forEach(bck -> {
            Set<BitsetCacheKey> set = this.keysByIndex.get(bck.index);
            if (set == null) {
                throw new IllegalStateException("Key [" + bck + "] is in the cache, but there is no entry for [" + bck.index + "] in the lookup map");
            }
            if (!set.contains(bck)) {
                throw new IllegalStateException("Key [" + bck + "] is in the cache, but the lookup entry for [" + bck.index + "] does not contain that key");
            }
        });
        this.keysByIndex.values().stream().flatMap(Collection::stream).forEach(bck -> {
            if (this.bitsetCache.get(bck) == null) {
                throw new IllegalStateException("Key [" + bck + "] is in the lookup map, but is not in the cache");
            }
        });
    }

    static BitSet bitSetFromDocIterator(DocIdSetIterator iter, int maxDoc) throws IOException {
        BitSet set = BitSet.of((DocIdSetIterator)iter, (int)maxDoc);
        if (set.cardinality() == maxDoc) {
            return new MatchAllRoleBitSet(maxDoc);
        }
        return set;
    }

    private class BitsetCacheKey {
        final IndexReader.CacheKey index;
        final Query query;

        private BitsetCacheKey(IndexReader.CacheKey index, Query query) {
            this.index = index;
            this.query = query;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            BitsetCacheKey that = (BitsetCacheKey)other;
            return Objects.equals(this.index, that.index) && Objects.equals(this.query, that.query);
        }

        public int hashCode() {
            return Objects.hash(this.index, this.query);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.index + "," + this.query + ")";
        }
    }
}

