/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.jwt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.ClaimSetting;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class JwtRealmSettings {
    public static final String TYPE = "jwt";
    public static final List<String> SUPPORTED_SECRET_KEY_SIGNATURE_ALGORITHMS = List.of("HS256", "HS384", "HS512");
    public static final List<String> SUPPORTED_PUBLIC_KEY_RSA_SIGNATURE_ALGORITHMS = List.of("RS256", "RS384", "RS512", "PS256", "PS384", "PS512");
    public static final List<String> SUPPORTED_PUBLIC_KEY_EC_SIGNATURE_ALGORITHMS = List.of("ES256", "ES384", "ES512");
    public static final List<String> SUPPORTED_PUBLIC_KEY_SIGNATURE_ALGORITHMS = Stream.of(SUPPORTED_PUBLIC_KEY_RSA_SIGNATURE_ALGORITHMS, SUPPORTED_PUBLIC_KEY_EC_SIGNATURE_ALGORITHMS).flatMap(Collection::stream).toList();
    public static final List<String> SUPPORTED_SIGNATURE_ALGORITHMS = Stream.of(SUPPORTED_SECRET_KEY_SIGNATURE_ALGORITHMS, SUPPORTED_PUBLIC_KEY_SIGNATURE_ALGORITHMS).flatMap(Collection::stream).toList();
    public static final String HEADER_END_USER_AUTHORIZATION = "Authorization";
    public static final String HEADER_END_USER_AUTHORIZATION_SCHEME = "Bearer";
    public static final String HEADER_CLIENT_AUTHORIZATION = "X-Client-Authorization";
    public static final String SUPPORTED_CLIENT_AUTHORIZATION_TYPE_SHARED_SECRET = "SharedSecret";
    public static final String SUPPORTED_CLIENT_AUTHORIZATION_TYPE_NONE = "None";
    public static final List<String> SUPPORTED_CLIENT_AUTHORIZATION_TYPES = List.of("SharedSecret", "None");
    private static final TimeValue DEFAULT_ALLOWED_CLOCK_SKEW = TimeValue.timeValueSeconds((long)60L);
    private static final List<String> DEFAULT_ALLOWED_SIGNATURE_ALGORITHMS = Collections.singletonList("RS256");
    private static final boolean DEFAULT_POPULATE_USER_METADATA = true;
    private static final String DEFAULT_CLIENT_AUTHORIZATION_TYPE = "SharedSecret";
    private static final TimeValue DEFAULT_CACHE_TTL = TimeValue.timeValueMinutes((long)20L);
    private static final int DEFAULT_CACHE_MAX_USERS = 100000;
    private static final String DEFAULT_CACHE_HASH_ALGO = "ssha256";
    private static final int MIN_CACHE_MAX_USERS = 0;
    private static final TimeValue DEFAULT_HTTP_CONNECT_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final TimeValue DEFAULT_HTTP_CONNECTION_READ_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final TimeValue DEFAULT_HTTP_SOCKET_TIMEOUT = TimeValue.timeValueSeconds((long)5L);
    private static final int DEFAULT_HTTP_MAX_CONNECTIONS = 200;
    private static final int MIN_HTTP_MAX_CONNECTIONS = 0;
    private static final int DEFAULT_HTTP_MAX_ENDPOINT_CONNECTIONS = 200;
    private static final int MIN_HTTP_MAX_ENDPOINT_CONNECTIONS = 0;
    public static final Setting.AffixSetting<String> ALLOWED_ISSUER = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_issuer", key -> Setting.simpleString((String)key, value -> JwtRealmSettings.verifyNonNullNotEmpty(key, value, null), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> ALLOWED_CLOCK_SKEW = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_clock_skew", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_ALLOWED_CLOCK_SKEW, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<List<String>> ALLOWED_SIGNATURE_ALGORITHMS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_signature_algorithms", key -> Setting.listSetting((String)key, DEFAULT_ALLOWED_SIGNATURE_ALGORITHMS, Function.identity(), values -> JwtRealmSettings.verifyNonNullNotEmpty(key, values, SUPPORTED_SIGNATURE_ALGORITHMS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> JWKSET_PATH = RealmSettings.simpleString("jwt", "jwkset_path", Setting.Property.NodeScope);
    public static final Setting.AffixSetting<SecureString> ISSUER_HMAC_SECRET_KEY = RealmSettings.secureString("jwt", "issuer_hmac_secret_key");
    public static final Setting.AffixSetting<List<String>> ALLOWED_AUDIENCES = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"allowed_audiences", key -> Setting.stringListSetting((String)key, values -> JwtRealmSettings.verifyNonNullNotEmpty(key, values, null), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final ClaimSetting CLAIMS_PRINCIPAL = new ClaimSetting("jwt", "principal");
    public static final ClaimSetting CLAIMS_GROUPS = new ClaimSetting("jwt", "groups");
    public static final Setting.AffixSetting<Boolean> POPULATE_USER_METADATA = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"populate_user_metadata", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> CLIENT_AUTHORIZATION_TYPE = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"client_authentication.type", key -> Setting.simpleString((String)key, (String)"SharedSecret", value -> {
        if (!SUPPORTED_CLIENT_AUTHORIZATION_TYPES.contains(value)) {
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + key + "]. Allowed values are " + SUPPORTED_CLIENT_AUTHORIZATION_TYPES + ".");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<SecureString> CLIENT_AUTHORIZATION_SHARED_SECRET = RealmSettings.secureString("jwt", "client_authentication.shared_secret");
    public static final Setting.AffixSetting<TimeValue> CACHE_TTL = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"cache.ttl", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_CACHE_TTL, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> CACHE_MAX_USERS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"cache.max_users", key -> Setting.intSetting((String)key, (int)100000, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<String> CACHE_HASH_ALGO = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"cache.hash_algo", key -> Setting.simpleString((String)key, (String)DEFAULT_CACHE_HASH_ALGO, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECT_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.connect_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_HTTP_CONNECT_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_CONNECTION_READ_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.connection_read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_HTTP_CONNECTION_READ_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<TimeValue> HTTP_SOCKET_TIMEOUT = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.socket_timeout", key -> Setting.timeSetting((String)key, (TimeValue)DEFAULT_HTTP_SOCKET_TIMEOUT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.max_connections", key -> Setting.intSetting((String)key, (int)200, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Setting.AffixSetting<Integer> HTTP_MAX_ENDPOINT_CONNECTIONS = Setting.affixKeySetting((String)RealmSettings.realmSettingPrefix("jwt"), (String)"http.max_endpoint_connections", key -> Setting.intSetting((String)key, (int)200, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    public static final Collection<Setting.AffixSetting<?>> SSL_CONFIGURATION_SETTINGS = SSLConfigurationSettings.getRealmSettings("jwt");
    public static final SSLConfigurationSettings ssl = SSLConfigurationSettings.withoutPrefix(true);
    public static final Collection<Setting.AffixSetting<?>> DELEGATED_AUTHORIZATION_REALMS_SETTINGS = DelegatedAuthorizationSettings.getSettings("jwt");

    private JwtRealmSettings() {
    }

    public static Set<Setting.AffixSetting<?>> getSettings() {
        HashSet set = Sets.newHashSet((Object[])new Setting.AffixSetting[0]);
        set.addAll(JwtRealmSettings.getNonSecureSettings());
        set.addAll(JwtRealmSettings.getSecureSettings());
        return set;
    }

    public static Set<Setting.AffixSetting<?>> getNonSecureSettings() {
        HashSet set = Sets.newHashSet((Object[])new Setting.AffixSetting[0]);
        set.addAll(RealmSettings.getStandardSettings(TYPE));
        set.addAll(List.of(ALLOWED_ISSUER, ALLOWED_SIGNATURE_ALGORITHMS, ALLOWED_CLOCK_SKEW, JWKSET_PATH));
        set.addAll(List.of(ALLOWED_AUDIENCES));
        set.addAll(List.of(CLAIMS_PRINCIPAL.getClaim(), CLAIMS_PRINCIPAL.getPattern(), CLAIMS_GROUPS.getClaim(), CLAIMS_GROUPS.getPattern(), POPULATE_USER_METADATA));
        set.addAll(List.of(CLIENT_AUTHORIZATION_TYPE));
        set.addAll(List.of(CACHE_TTL, CACHE_MAX_USERS, CACHE_HASH_ALGO));
        set.addAll(List.of(HTTP_CONNECT_TIMEOUT, HTTP_CONNECTION_READ_TIMEOUT, HTTP_SOCKET_TIMEOUT, HTTP_MAX_CONNECTIONS, HTTP_MAX_ENDPOINT_CONNECTIONS));
        set.addAll(SSL_CONFIGURATION_SETTINGS);
        set.addAll(DELEGATED_AUTHORIZATION_REALMS_SETTINGS);
        return set;
    }

    public static List<Setting.AffixSetting<SecureString>> getSecureSettings() {
        return List.of(ISSUER_HMAC_SECRET_KEY, CLIENT_AUTHORIZATION_SHARED_SECRET);
    }

    private static void verifyNonNullNotEmpty(String key, String value, List<String> allowedValues) {
        assert (value != null) : "Invalid null value for [" + key + "].";
        if (value.isEmpty()) {
            throw new IllegalArgumentException("Invalid empty value for [" + key + "].");
        }
        if (allowedValues != null && !allowedValues.contains(value)) {
            throw new IllegalArgumentException("Invalid value [" + value + "] for [" + key + "]. Allowed values are " + allowedValues + ".");
        }
    }

    private static void verifyNonNullNotEmpty(String key, List<String> values, List<String> allowedValues) {
        assert (values != null) : "Invalid null list of values for [" + key + "].";
        if (values.isEmpty()) {
            if (allowedValues == null) {
                throw new IllegalArgumentException("Invalid empty list for [" + key + "].");
            }
            throw new IllegalArgumentException("Invalid empty list for [" + key + "]. Allowed values are " + allowedValues + ".");
        }
        for (String value : values) {
            JwtRealmSettings.verifyNonNullNotEmpty(key, value, allowedValues);
        }
    }
}

