/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.KeyAndTimestamp;

public final class TokenMetadata
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom {
    public static final String TYPE = "security_tokens";
    private final List<KeyAndTimestamp> keys;
    private final byte[] currentKeyHash;

    public List<KeyAndTimestamp> getKeys() {
        return this.keys;
    }

    public byte[] getCurrentKeyHash() {
        return this.currentKeyHash;
    }

    public TokenMetadata(List<KeyAndTimestamp> keys, byte[] currentKeyHash) {
        this.keys = keys;
        this.currentKeyHash = currentKeyHash;
    }

    public TokenMetadata(StreamInput input) throws IOException {
        this.currentKeyHash = input.readByteArray();
        this.keys = Collections.unmodifiableList(input.readList(KeyAndTimestamp::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeByteArray(this.currentKeyHash);
        out.writeList(this.keys);
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return TokenMetadata.readDiffFrom(ClusterState.Custom.class, (String)TYPE, (StreamInput)in);
    }

    public String getWriteableName() {
        return TYPE;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TokenMetadata that = (TokenMetadata)((Object)o);
        return this.keys.equals(that.keys) && Arrays.equals(this.currentKeyHash, that.currentKeyHash);
    }

    public int hashCode() {
        int result = this.keys.hashCode();
        result = 31 * result + Arrays.hashCode(this.currentKeyHash);
        return result;
    }

    public String toString() {
        return "TokenMetadata{ everything is secret }";
    }

    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumIndexCompatibilityVersion();
    }

    public boolean isPrivate() {
        return true;
    }
}

