/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.util.ArrayUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceIntersection;
import org.elasticsearch.xpack.core.security.user.AnonymousUser;
import org.elasticsearch.xpack.core.security.user.User;

public class Subject {
    private final Version version;
    private final User user;
    private final Authentication.RealmRef realm;
    private final Type type;
    private final Map<String, Object> metadata;
    static final BytesArray FLEET_SERVER_ROLE_DESCRIPTOR_BYTES_V_7_14 = new BytesArray("{\"elastic/fleet-server\":{\"cluster\":[\"monitor\",\"manage_own_api_key\"],\"indices\":[{\"names\":[\"logs-*\",\"metrics-*\",\"traces-*\",\"synthetics-*\",\".logs-endpoint.diagnostic.collection-*\"],\"privileges\":[\"write\",\"create_index\",\"auto_configure\"],\"allow_restricted_indices\":false},{\"names\":[\".fleet-*\"],\"privileges\":[\"read\",\"write\",\"monitor\",\"create_index\",\"auto_configure\"],\"allow_restricted_indices\":false}],\"applications\":[],\"run_as\":[],\"metadata\":{},\"transient_metadata\":{\"enabled\":true}}}");

    public Subject(User user, Authentication.RealmRef realm) {
        this(user, realm, Version.CURRENT, Map.of());
    }

    public Subject(User user, Authentication.RealmRef realm, Version version, Map<String, Object> metadata) {
        this.version = version;
        this.user = user;
        this.realm = realm;
        if (realm == null) {
            this.type = Type.USER;
        } else if ("_es_api_key".equals(realm.getType())) {
            assert ("_es_api_key".equals(realm.getName())) : "api key realm name mismatch";
            this.type = Type.API_KEY;
        } else if ("_service_account".equals(realm.getType())) {
            assert ("_service_account".equals(realm.getName())) : "service account realm name mismatch";
            this.type = Type.SERVICE_ACCOUNT;
        } else {
            this.type = Type.USER;
        }
        this.metadata = metadata;
    }

    public User getUser() {
        return this.user;
    }

    public Authentication.RealmRef getRealm() {
        return this.realm;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public RoleReferenceIntersection getRoleReferenceIntersection(@Nullable AnonymousUser anonymousUser) {
        switch (this.type) {
            case USER: {
                return this.buildRoleReferencesForUser(anonymousUser);
            }
            case API_KEY: {
                return this.buildRoleReferencesForApiKey();
            }
            case SERVICE_ACCOUNT: {
                return new RoleReferenceIntersection(new RoleReference.ServiceAccountRoleReference(this.user.principal()));
            }
        }
        assert (false) : "unknown subject type: [" + this.type + "]";
        throw new IllegalStateException("unknown subject type: [" + this.type + "]");
    }

    private RoleReferenceIntersection buildRoleReferencesForUser(AnonymousUser anonymousUser) {
        String[] allRoleNames;
        if (this.user.equals(anonymousUser)) {
            return new RoleReferenceIntersection(new RoleReference.NamedRoleReference(this.user.roles()));
        }
        if (anonymousUser == null || !anonymousUser.enabled()) {
            allRoleNames = this.user.roles();
        } else {
            if (anonymousUser.roles().length == 0) {
                throw new IllegalStateException("anonymous is only enabled when the anonymous user has roles");
            }
            allRoleNames = ArrayUtils.concat((String[])this.user.roles(), (String[])anonymousUser.roles());
        }
        return new RoleReferenceIntersection(new RoleReference.NamedRoleReference(allRoleNames));
    }

    private RoleReferenceIntersection buildRoleReferencesForApiKey() {
        if (this.version.before(Authentication.VERSION_API_KEY_ROLES_AS_BYTES)) {
            return this.buildRolesReferenceForApiKeyBwc();
        }
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        BytesReference roleDescriptorsBytes = (BytesReference)this.metadata.get("_security_api_key_role_descriptors");
        BytesReference limitedByRoleDescriptorsBytes = this.getLimitedByRoleDescriptorsBytes();
        if (roleDescriptorsBytes == null && limitedByRoleDescriptorsBytes == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        RoleReference.ApiKeyRoleReference limitedByRoleReference = new RoleReference.ApiKeyRoleReference(apiKeyId, limitedByRoleDescriptorsBytes, RoleReference.ApiKeyRoleType.LIMITED_BY);
        if (this.isEmptyRoleDescriptorsBytes(roleDescriptorsBytes)) {
            return new RoleReferenceIntersection(limitedByRoleReference);
        }
        return new RoleReferenceIntersection(new RoleReference.ApiKeyRoleReference(apiKeyId, roleDescriptorsBytes, RoleReference.ApiKeyRoleType.ASSIGNED), limitedByRoleReference);
    }

    private boolean isEmptyRoleDescriptorsBytes(BytesReference roleDescriptorsBytes) {
        return roleDescriptorsBytes == null || roleDescriptorsBytes.length() == 2 && "{}".equals(roleDescriptorsBytes.utf8ToString());
    }

    private RoleReferenceIntersection buildRolesReferenceForApiKeyBwc() {
        String apiKeyId = (String)this.metadata.get("_security_api_key_id");
        Map<String, Object> roleDescriptorsMap = this.getRoleDescriptorMap("_security_api_key_role_descriptors");
        Map<String, Object> limitedByRoleDescriptorsMap = this.getRoleDescriptorMap("_security_api_key_limited_by_role_descriptors");
        if (roleDescriptorsMap == null && limitedByRoleDescriptorsMap == null) {
            throw new ElasticsearchSecurityException("no role descriptors found for API key", new Object[0]);
        }
        RoleReference.BwcApiKeyRoleReference limitedByRoleReference = new RoleReference.BwcApiKeyRoleReference(apiKeyId, limitedByRoleDescriptorsMap, RoleReference.ApiKeyRoleType.LIMITED_BY);
        if (roleDescriptorsMap == null || roleDescriptorsMap.isEmpty()) {
            return new RoleReferenceIntersection(limitedByRoleReference);
        }
        return new RoleReferenceIntersection(new RoleReference.BwcApiKeyRoleReference(apiKeyId, roleDescriptorsMap, RoleReference.ApiKeyRoleType.ASSIGNED), limitedByRoleReference);
    }

    private Map<String, Object> getRoleDescriptorMap(String key) {
        return (Map)this.metadata.get(key);
    }

    private BytesReference getLimitedByRoleDescriptorsBytes() {
        BytesReference bytesReference = (BytesReference)this.metadata.get("_security_api_key_limited_by_role_descriptors");
        if (bytesReference.length() == 2 && "{}".equals(bytesReference.utf8ToString()) && "_service_account".equals(this.metadata.get("_security_api_key_creator_realm_name")) && "elastic/fleet-server".equals(this.user.principal())) {
            return FLEET_SERVER_ROLE_DESCRIPTOR_BYTES_V_7_14;
        }
        return bytesReference;
    }

    public static enum Type {
        USER,
        API_KEY,
        SERVICE_ACCOUNT;

    }
}

