/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.user.User;

public class AuthenticationContext {
    private final Version version;
    private final Subject authenticatingSubject;
    private final Subject effectiveSubject;
    private final Authentication.AuthenticationType type;

    private AuthenticationContext(Version version, Subject authenticatingSubject, Subject effectiveSubject, Authentication.AuthenticationType authenticationType) {
        this.version = version;
        this.authenticatingSubject = authenticatingSubject;
        this.effectiveSubject = effectiveSubject;
        this.type = authenticationType;
    }

    public boolean isRunAs() {
        assert (this.authenticatingSubject != null && this.effectiveSubject != null);
        return this.authenticatingSubject != this.effectiveSubject;
    }

    public Subject getAuthenticatingSubject() {
        return this.authenticatingSubject;
    }

    public Subject getEffectiveSubject() {
        return this.effectiveSubject;
    }

    public Authentication toAuthentication() {
        return new Authentication(this.effectiveSubject.getUser(), this.authenticatingSubject.getRealm(), this.effectiveSubject.getRealm(), this.version, this.type, this.authenticatingSubject.getMetadata());
    }

    public static AuthenticationContext fromAuthentication(Authentication authentication) {
        Builder builder = new Builder(authentication.getVersion());
        builder.authenticationType(authentication.getAuthenticationType());
        User user = authentication.getUser();
        if (user.isRunAs()) {
            builder.authenticatingSubject(user.authenticatedUser(), authentication.getAuthenticatedBy(), authentication.getMetadata());
            builder.effectiveSubject(user, authentication.getLookedUpBy(), Map.of());
        } else {
            builder.authenticatingSubject(user, authentication.getAuthenticatedBy(), authentication.getMetadata());
        }
        return builder.build();
    }

    public static class Builder {
        private final Version version;
        private Authentication.AuthenticationType authenticationType;
        private Subject authenticatingSubject;
        private Subject effectiveSubject;

        public Builder() {
            this(Version.CURRENT);
        }

        public Builder(Version version) {
            this.version = version;
        }

        public Builder authenticationType(Authentication.AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public Builder authenticatingSubject(User authenticatingUser, Authentication.RealmRef authenticatingRealmRef, Map<String, Object> metadata) {
            this.authenticatingSubject = new Subject(authenticatingUser, authenticatingRealmRef, this.version, metadata);
            return this;
        }

        public Builder effectiveSubject(User effectiveUser, Authentication.RealmRef lookupRealmRef, Map<String, Object> metadata) {
            this.effectiveSubject = new Subject(effectiveUser, lookupRealmRef, this.version, metadata);
            return this;
        }

        public AuthenticationContext build() {
            if (this.effectiveSubject == null) {
                this.effectiveSubject = this.authenticatingSubject;
            }
            return new AuthenticationContext(this.version, this.authenticatingSubject, this.effectiveSubject, this.authenticationType);
        }
    }
}

