/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.AuthenticationContext;
import org.elasticsearch.xpack.core.security.authc.Subject;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.user.InternalUserSerializationHelper;
import org.elasticsearch.xpack.core.security.user.User;

public class Authentication
implements ToXContentObject {
    public static final Version VERSION_API_KEY_ROLES_AS_BYTES = Version.V_7_9_0;
    private final User user;
    private final RealmRef authenticatedBy;
    private final RealmRef lookedUpBy;
    private final Version version;
    private final AuthenticationType type;
    private final Map<String, Object> metadata;
    public static ConstructingObjectParser<RealmRef, Void> REALM_REF_PARSER = new ConstructingObjectParser("realm_ref", false, (args, v) -> new RealmRef((String)args[0], (String)args[1], (String)args[2]));

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy) {
        this(user, authenticatedBy, lookedUpBy, Version.CURRENT);
    }

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy, Version version) {
        this(user, authenticatedBy, lookedUpBy, version, AuthenticationType.REALM, Collections.emptyMap());
    }

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy, Version version, AuthenticationType type, Map<String, Object> metadata) {
        this.user = Objects.requireNonNull(user);
        this.authenticatedBy = Objects.requireNonNull(authenticatedBy);
        this.lookedUpBy = lookedUpBy;
        this.version = version;
        this.type = type;
        this.metadata = metadata;
        this.assertApiKeyMetadata();
    }

    public Authentication(StreamInput in) throws IOException {
        this.user = InternalUserSerializationHelper.readFrom(in);
        this.authenticatedBy = new RealmRef(in);
        this.lookedUpBy = in.readBoolean() ? new RealmRef(in) : null;
        this.version = in.getVersion();
        this.type = AuthenticationType.values()[in.readVInt()];
        this.metadata = in.readMap();
        this.assertApiKeyMetadata();
    }

    public User getUser() {
        return this.user;
    }

    public RealmRef getAuthenticatedBy() {
        return this.authenticatedBy;
    }

    public RealmRef getLookedUpBy() {
        return this.lookedUpBy;
    }

    public RealmRef getSourceRealm() {
        return this.lookedUpBy == null ? this.authenticatedBy : this.lookedUpBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public AuthenticationType getAuthenticationType() {
        return this.type;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isAuthenticatedWithServiceAccount() {
        return "_service_account".equals(this.getAuthenticatedBy().getType());
    }

    public boolean isAuthenticatedAsApiKey() {
        boolean result = "_es_api_key".equals(this.getAuthenticatedBy().getType());
        assert (!result || "_es_api_key".equals(this.getAuthenticatedBy().getName()));
        return result;
    }

    public boolean isServiceAccount() {
        boolean result = "_service_account".equals(this.getSourceRealm().getType());
        assert (!result || "_service_account".equals(this.getSourceRealm().getName())) : "service account realm name mismatch";
        return result;
    }

    public boolean isApiKey() {
        boolean result = "_es_api_key".equals(this.getSourceRealm().getType());
        assert (!result || "_es_api_key".equals(this.getSourceRealm().getName())) : "api key realm name mismatch";
        return result;
    }

    public void writeToContext(ThreadContext ctx) throws IOException, IllegalArgumentException {
        new AuthenticationContextSerializer().writeToContext(this, ctx);
    }

    public String encode() throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        output.setVersion(this.version);
        Version.writeVersion((Version)this.version, (StreamOutput)output);
        this.writeTo((StreamOutput)output);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes((BytesReference)output.bytes()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        InternalUserSerializationHelper.writeTo(this.user, out);
        this.authenticatedBy.writeTo(out);
        if (this.lookedUpBy != null) {
            out.writeBoolean(true);
            this.lookedUpBy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeVInt(this.type.ordinal());
        out.writeMap(this.metadata);
    }

    public boolean canAccessResourcesOf(Authentication other) {
        assert (EnumSet.of(AuthenticationType.REALM, AuthenticationType.API_KEY, AuthenticationType.TOKEN, AuthenticationType.ANONYMOUS, AuthenticationType.INTERNAL).containsAll(EnumSet.of(this.getAuthenticationType(), other.getAuthenticationType()))) : "cross AuthenticationType comparison for canAccessResourcesOf is not applicable for: " + EnumSet.of(this.getAuthenticationType(), other.getAuthenticationType());
        AuthenticationContext myAuthContext = AuthenticationContext.fromAuthentication(this);
        AuthenticationContext creatorAuthContext = AuthenticationContext.fromAuthentication(other);
        if (Subject.Type.API_KEY.equals((Object)myAuthContext.getEffectiveSubject().getType()) && Subject.Type.API_KEY.equals((Object)creatorAuthContext.getEffectiveSubject().getType())) {
            boolean sameKeyId = myAuthContext.getEffectiveSubject().getMetadata().get("_security_api_key_id").equals(creatorAuthContext.getEffectiveSubject().getMetadata().get("_security_api_key_id"));
            assert (!sameKeyId || myAuthContext.getEffectiveSubject().getUser().principal().equals(creatorAuthContext.getEffectiveSubject().getUser().principal())) : "The same API key ID cannot be attributed to two different usernames";
            return sameKeyId;
        }
        if (Subject.Type.API_KEY.equals((Object)myAuthContext.getEffectiveSubject().getType()) && !Subject.Type.API_KEY.equals((Object)creatorAuthContext.getEffectiveSubject().getType()) || !Subject.Type.API_KEY.equals((Object)myAuthContext.getEffectiveSubject().getType()) && Subject.Type.API_KEY.equals((Object)creatorAuthContext.getEffectiveSubject().getType())) {
            return false;
        }
        if (!myAuthContext.getEffectiveSubject().getUser().principal().equals(creatorAuthContext.getEffectiveSubject().getUser().principal())) {
            return false;
        }
        RealmRef myAuthRealm = myAuthContext.getEffectiveSubject().getRealm();
        RealmRef creatorAuthRealm = creatorAuthContext.getEffectiveSubject().getRealm();
        if ("file".equals(myAuthRealm.getType()) || "native".equals(myAuthRealm.getType())) {
            return myAuthRealm.getType().equals(creatorAuthRealm.getType());
        }
        return myAuthRealm.getName().equals(creatorAuthRealm.getName()) && myAuthRealm.getType().equals(creatorAuthRealm.getType());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication that = (Authentication)o;
        return this.user.equals(that.user) && this.authenticatedBy.equals(that.authenticatedBy) && Objects.equals(this.lookedUpBy, that.lookedUpBy) && this.version.equals((Object)that.version) && this.type == that.type && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.authenticatedBy, this.lookedUpBy, this.version, this.type, this.metadata});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        return builder.endObject();
    }

    public void toXContentFragment(XContentBuilder builder) throws IOException {
        builder.field(User.Fields.USERNAME.getPreferredName(), this.user.principal());
        builder.array(User.Fields.ROLES.getPreferredName(), this.user.roles());
        builder.field(User.Fields.FULL_NAME.getPreferredName(), this.user.fullName());
        builder.field(User.Fields.EMAIL.getPreferredName(), this.user.email());
        if (this.isServiceAccount()) {
            String tokenName = (String)this.getMetadata().get("_token_name");
            assert (tokenName != null) : "token name cannot be null";
            String tokenSource = (String)this.getMetadata().get("_token_source");
            assert (tokenSource != null) : "token source cannot be null";
            builder.field(User.Fields.TOKEN.getPreferredName(), Map.of("name", tokenName, "type", "_service_account_" + tokenSource));
        }
        builder.field(User.Fields.METADATA.getPreferredName(), this.user.metadata());
        builder.field(User.Fields.ENABLED.getPreferredName(), this.user.enabled());
        builder.startObject(User.Fields.AUTHENTICATION_REALM.getPreferredName());
        builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getAuthenticatedBy().getName());
        builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getAuthenticatedBy().getType());
        builder.endObject();
        builder.startObject(User.Fields.LOOKUP_REALM.getPreferredName());
        if (this.getLookedUpBy() != null) {
            builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getLookedUpBy().getName());
            builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getLookedUpBy().getType());
        } else {
            builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getAuthenticatedBy().getName());
            builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getAuthenticatedBy().getType());
        }
        builder.endObject();
        builder.field(User.Fields.AUTHENTICATION_TYPE.getPreferredName(), this.getAuthenticationType().name().toLowerCase(Locale.ROOT));
        if (this.isApiKey()) {
            this.assertApiKeyMetadata();
            String apiKeyId = (String)this.metadata.get("_security_api_key_id");
            String apiKeyName = (String)this.metadata.get("_security_api_key_name");
            if (apiKeyName == null) {
                builder.field("api_key", Map.of("id", apiKeyId));
            } else {
                builder.field("api_key", Map.of("id", apiKeyId, "name", apiKeyName));
            }
        }
    }

    private void assertApiKeyMetadata() {
        assert (!this.isAuthenticatedAsApiKey() || this.metadata.get("_security_api_key_id") != null) : "API KEY authentication requires metadata to contain API KEY id, and the value must be non-null.";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Authentication[").append(this.user).append(",type=").append((Object)this.type).append(",by=").append(this.authenticatedBy);
        if (this.lookedUpBy != null) {
            builder.append(",lookup=").append(this.lookedUpBy);
        }
        builder.append("]");
        return builder.toString();
    }

    static {
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("type", new String[0]));
        REALM_REF_PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node_name", new String[0]));
    }

    public static class RealmRef {
        private final String nodeName;
        private final String name;
        private final String type;

        public RealmRef(String name, String type, String nodeName) {
            this.nodeName = nodeName;
            this.name = name;
            this.type = type;
        }

        public RealmRef(StreamInput in) throws IOException {
            this.nodeName = in.readString();
            this.name = in.readString();
            this.type = in.readString();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeName);
            out.writeString(this.name);
            out.writeString(this.type);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmRef realmRef = (RealmRef)o;
            if (!this.nodeName.equals(realmRef.nodeName)) {
                return false;
            }
            if (!this.name.equals(realmRef.name)) {
                return false;
            }
            return this.type.equals(realmRef.type);
        }

        public int hashCode() {
            int result = this.nodeName.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return "{Realm[" + this.type + "." + this.name + "] on Node[" + this.nodeName + "]}";
        }
    }

    public static enum AuthenticationType {
        REALM,
        API_KEY,
        TOKEN,
        ANONYMOUS,
        INTERNAL;

    }
}

