/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.realm;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;

public class ClearRealmCacheResponse
extends BaseNodesResponse<Node>
implements ToXContentFragment {
    public ClearRealmCacheResponse(StreamInput in) throws IOException {
        super(in);
    }

    public ClearRealmCacheResponse(ClusterName clusterName, List<Node> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    protected List<Node> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(Node::new);
    }

    protected void writeNodesTo(StreamOutput out, List<Node> nodes) throws IOException {
        out.writeList(nodes);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("nodes");
        for (Node node : this.getNodes()) {
            builder.startObject(node.getNode().getId());
            builder.field("name", node.getNode().getName());
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
            builder.startObject();
            this.toXContent(builder, EMPTY_PARAMS);
            builder.endObject();
            return Strings.toString((XContentBuilder)builder);
        }
        catch (IOException e) {
            return String.format(Locale.ROOT, "{ \"error\" : \"%s\" }", e.getMessage());
        }
    }

    public static class Node
    extends BaseNodeResponse {
        public Node(StreamInput in) throws IOException {
            super(in);
        }

        public Node(DiscoveryNode node) {
            super(node);
        }
    }
}

