/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record Profile(String uid, boolean enabled, long lastSynchronized, ProfileUser user, Map<String, Object> access, Map<String, Object> applicationData, VersionControl versionControl) implements Writeable,
ToXContentObject
{
    public Profile(StreamInput in) throws IOException {
        this(in.readString(), in.readBoolean(), in.readLong(), new ProfileUser(in), in.readMap(), in.readMap(), new VersionControl(in));
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("uid", this.uid);
        builder.field("enabled", this.enabled);
        builder.field("last_synchronized", this.lastSynchronized);
        this.user.toXContent(builder, params);
        builder.field("access", this.access);
        builder.field("data", this.applicationData);
        this.versionControl.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.uid);
        out.writeBoolean(this.enabled);
        out.writeLong(this.lastSynchronized);
        this.user.writeTo(out);
        out.writeMap(this.access);
        out.writeMap(this.applicationData);
        this.versionControl.writeTo(out);
    }

    public record ProfileUser(String username, List<String> roles, String realmName, @Nullable String realmDomain, String email, String fullName, String displayName, boolean active) implements Writeable,
    ToXContent
    {
        public ProfileUser(StreamInput in) throws IOException {
            this(in.readString(), in.readStringList(), in.readString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readOptionalString(), in.readBoolean());
        }

        public QualifiedName qualifiedName() {
            return new QualifiedName(this.username, this.realmDomain);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("user");
            builder.field("username", this.username);
            builder.field("roles", this.roles);
            builder.field("realm_name", this.realmName);
            if (this.realmDomain != null) {
                builder.field("realm_domain", this.realmDomain);
            }
            if (this.email != null) {
                builder.field("email", this.email);
            }
            if (this.fullName != null) {
                builder.field("full_name", this.fullName);
            }
            if (this.displayName != null) {
                builder.field("display_name", this.displayName);
            }
            builder.field("active", this.active);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.username);
            out.writeStringCollection(this.roles);
            out.writeString(this.realmName);
            out.writeOptionalString(this.realmDomain);
            out.writeOptionalString(this.email);
            out.writeOptionalString(this.fullName);
            out.writeOptionalString(this.displayName);
            out.writeBoolean(this.active);
        }
    }

    public record VersionControl(long primaryTerm, long seqNo) implements Writeable,
    ToXContent
    {
        public VersionControl(StreamInput in) throws IOException {
            this(in.readLong(), in.readLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("_doc");
            builder.field("_primary_term", this.primaryTerm);
            builder.field("_seq_no", this.seqNo);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.primaryTerm);
            out.writeLong(this.seqNo);
        }
    }

    public record QualifiedName(String username, String realmDomain) {
    }
}

