/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.action.profile.Profile;

public class GetProfilesResponse
extends ActionResponse
implements StatusToXContentObject {
    private final Profile[] profiles;

    public GetProfilesResponse(@Nullable Profile profile) {
        Profile[] profileArray;
        if (profile != null) {
            Profile[] profileArray2 = new Profile[1];
            profileArray = profileArray2;
            profileArray2[0] = profile;
        } else {
            profileArray = new Profile[]{};
        }
        this.profiles = profileArray;
    }

    public GetProfilesResponse(StreamInput in) throws IOException {
        super(in);
        this.profiles = (Profile[])in.readArray(Profile::new, Profile[]::new);
    }

    public Profile[] getProfiles() {
        return this.profiles;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeArray((Writeable[])this.profiles);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (Profile profile : this.profiles) {
            builder.field(profile.uid());
            profile.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public RestStatus status() {
        return this.profiles.length > 0 ? RestStatus.OK : RestStatus.NOT_FOUND;
    }
}

