/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.client.internal.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.rollup.RollupActionConfig;
import org.elasticsearch.xpack.core.rollup.action.RollupTask;

public class RollupAction
extends ActionType<AcknowledgedResponse> {
    public static final RollupAction INSTANCE = new RollupAction();
    public static final String NAME = "indices:admin/xpack/rollup";

    private RollupAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, AcknowledgedResponse> {
        protected RequestBuilder(ElasticsearchClient client, RollupAction action) {
            super(client, (ActionType)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends MasterNodeRequest<Request>
    implements IndicesRequest,
    ToXContentObject {
        private String sourceIndex;
        private String rollupIndex;
        private RollupActionConfig rollupConfig;

        public Request(String sourceIndex, String rollupIndex, RollupActionConfig rollupConfig) {
            this.sourceIndex = sourceIndex;
            this.rollupIndex = rollupIndex;
            this.rollupConfig = rollupConfig;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sourceIndex = in.readString();
            this.rollupIndex = in.readString();
            this.rollupConfig = new RollupActionConfig(in);
        }

        public String[] indices() {
            return new String[]{this.sourceIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.STRICT_SINGLE_INDEX_NO_EXPAND_FORBID_CLOSED;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new RollupTask(id, type, action, parentTaskId, this.rollupIndex, this.rollupConfig, headers);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sourceIndex);
            out.writeString(this.rollupIndex);
            this.rollupConfig.writeTo(out);
        }

        public String getSourceIndex() {
            return this.sourceIndex;
        }

        public String getRollupIndex() {
            return this.rollupIndex;
        }

        public RollupActionConfig getRollupConfig() {
            return this.rollupConfig;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("source_index", this.sourceIndex);
            builder.field("rollup_index", this.rollupIndex);
            this.rollupConfig.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex, this.rollupIndex, this.rollupConfig);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.sourceIndex, other.sourceIndex) && Objects.equals(this.rollupIndex, other.rollupIndex) && Objects.equals(this.rollupConfig, other.rollupConfig);
        }
    }
}

