/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.results;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.job.config.Detector;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.AnomalyCause;
import org.elasticsearch.xpack.core.ml.job.results.GeoResults;
import org.elasticsearch.xpack.core.ml.job.results.Influence;
import org.elasticsearch.xpack.core.ml.job.results.ReservedFieldNames;
import org.elasticsearch.xpack.core.ml.job.results.Result;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class AnomalyRecord
implements ToXContentObject,
Writeable {
    public static final String RESULT_TYPE_VALUE = "record";
    public static final ParseField PROBABILITY = new ParseField("probability", new String[0]);
    public static final ParseField MULTI_BUCKET_IMPACT = new ParseField("multi_bucket_impact", new String[0]);
    public static final ParseField BY_FIELD_NAME = new ParseField("by_field_name", new String[0]);
    public static final ParseField BY_FIELD_VALUE = new ParseField("by_field_value", new String[0]);
    public static final ParseField CORRELATED_BY_FIELD_VALUE = new ParseField("correlated_by_field_value", new String[0]);
    public static final ParseField PARTITION_FIELD_NAME = new ParseField("partition_field_name", new String[0]);
    public static final ParseField PARTITION_FIELD_VALUE = new ParseField("partition_field_value", new String[0]);
    public static final ParseField FUNCTION = new ParseField("function", new String[0]);
    public static final ParseField FUNCTION_DESCRIPTION = new ParseField("function_description", new String[0]);
    public static final ParseField TYPICAL = new ParseField("typical", new String[0]);
    public static final ParseField ACTUAL = new ParseField("actual", new String[0]);
    public static final ParseField INFLUENCERS = new ParseField("influencers", new String[0]);
    public static final ParseField BUCKET_SPAN = new ParseField("bucket_span", new String[0]);
    public static final ParseField GEO_RESULTS = new ParseField("geo_results", new String[0]);
    public static final ParseField RESULTS_FIELD = new ParseField("records", new String[0]);
    public static final ParseField FIELD_NAME = new ParseField("field_name", new String[0]);
    public static final ParseField OVER_FIELD_NAME = new ParseField("over_field_name", new String[0]);
    public static final ParseField OVER_FIELD_VALUE = new ParseField("over_field_value", new String[0]);
    public static final ParseField CAUSES = new ParseField("causes", new String[0]);
    public static final ParseField RECORD_SCORE = new ParseField("record_score", new String[0]);
    public static final ParseField INITIAL_RECORD_SCORE = new ParseField("initial_record_score", new String[0]);
    public static final ConstructingObjectParser<AnomalyRecord, Void> STRICT_PARSER = AnomalyRecord.createParser(false);
    public static final ConstructingObjectParser<AnomalyRecord, Void> LENIENT_PARSER = AnomalyRecord.createParser(true);
    private final String jobId;
    private int detectorIndex;
    private double probability;
    private Double multiBucketImpact;
    private String byFieldName;
    private String byFieldValue;
    private String correlatedByFieldValue;
    private String partitionFieldName;
    private String partitionFieldValue;
    private String function;
    private String functionDescription;
    private List<Double> typical;
    private List<Double> actual;
    private boolean isInterim;
    private GeoResults geoResults;
    private String fieldName;
    private String overFieldName;
    private String overFieldValue;
    private List<AnomalyCause> causes;
    private double recordScore;
    private double initialRecordScore;
    private final Date timestamp;
    private final long bucketSpan;
    private List<Influence> influences;

    private static ConstructingObjectParser<AnomalyRecord, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser parser = new ConstructingObjectParser(RESULT_TYPE_VALUE, true, a -> new AnomalyRecord((String)a[0], (Date)a[1], (Long)a[2]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Job.ID);
        parser.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeField(p, Result.TIMESTAMP.getPreferredName()), Result.TIMESTAMP, ObjectParser.ValueType.VALUE);
        parser.declareLong(ConstructingObjectParser.constructorArg(), BUCKET_SPAN);
        parser.declareString((anomalyRecord, s) -> {}, Result.RESULT_TYPE);
        parser.declareDouble(AnomalyRecord::setProbability, PROBABILITY);
        parser.declareDouble(AnomalyRecord::setMultiBucketImpact, MULTI_BUCKET_IMPACT);
        parser.declareDouble(AnomalyRecord::setRecordScore, RECORD_SCORE);
        parser.declareDouble(AnomalyRecord::setInitialRecordScore, INITIAL_RECORD_SCORE);
        parser.declareInt(AnomalyRecord::setDetectorIndex, Detector.DETECTOR_INDEX);
        parser.declareBoolean(AnomalyRecord::setInterim, Result.IS_INTERIM);
        parser.declareString(AnomalyRecord::setByFieldName, BY_FIELD_NAME);
        parser.declareString(AnomalyRecord::setByFieldValue, BY_FIELD_VALUE);
        parser.declareString(AnomalyRecord::setCorrelatedByFieldValue, CORRELATED_BY_FIELD_VALUE);
        parser.declareString(AnomalyRecord::setPartitionFieldName, PARTITION_FIELD_NAME);
        parser.declareString(AnomalyRecord::setPartitionFieldValue, PARTITION_FIELD_VALUE);
        parser.declareString(AnomalyRecord::setFunction, FUNCTION);
        parser.declareString(AnomalyRecord::setFunctionDescription, FUNCTION_DESCRIPTION);
        parser.declareDoubleArray(AnomalyRecord::setTypical, TYPICAL);
        parser.declareDoubleArray(AnomalyRecord::setActual, ACTUAL);
        parser.declareString(AnomalyRecord::setFieldName, FIELD_NAME);
        parser.declareString(AnomalyRecord::setOverFieldName, OVER_FIELD_NAME);
        parser.declareString(AnomalyRecord::setOverFieldValue, OVER_FIELD_VALUE);
        parser.declareObjectArray(AnomalyRecord::setCauses, ignoreUnknownFields ? AnomalyCause.LENIENT_PARSER : AnomalyCause.STRICT_PARSER, CAUSES);
        parser.declareObjectArray(AnomalyRecord::setInfluencers, ignoreUnknownFields ? Influence.LENIENT_PARSER : Influence.STRICT_PARSER, INFLUENCERS);
        parser.declareObject(AnomalyRecord::setGeoResults, ignoreUnknownFields ? GeoResults.LENIENT_PARSER : GeoResults.STRICT_PARSER, GEO_RESULTS);
        return parser;
    }

    public AnomalyRecord(String jobId, Date timestamp, long bucketSpan) {
        this.jobId = jobId;
        this.timestamp = ExceptionsHelper.requireNonNull(timestamp, Result.TIMESTAMP.getPreferredName());
        this.bucketSpan = bucketSpan;
    }

    public AnomalyRecord(StreamInput in) throws IOException {
        this.jobId = in.readString();
        this.detectorIndex = in.readInt();
        this.probability = in.readDouble();
        this.multiBucketImpact = in.readOptionalDouble();
        this.byFieldName = in.readOptionalString();
        this.byFieldValue = in.readOptionalString();
        this.correlatedByFieldValue = in.readOptionalString();
        this.partitionFieldName = in.readOptionalString();
        this.partitionFieldValue = in.readOptionalString();
        this.function = in.readOptionalString();
        this.functionDescription = in.readOptionalString();
        this.fieldName = in.readOptionalString();
        this.overFieldName = in.readOptionalString();
        this.overFieldValue = in.readOptionalString();
        if (in.readBoolean()) {
            this.typical = (List)in.readGenericValue();
        }
        if (in.readBoolean()) {
            this.actual = (List)in.readGenericValue();
        }
        this.isInterim = in.readBoolean();
        if (in.readBoolean()) {
            this.causes = in.readList(AnomalyCause::new);
        }
        this.recordScore = in.readDouble();
        this.initialRecordScore = in.readDouble();
        this.timestamp = new Date(in.readLong());
        this.bucketSpan = in.readLong();
        if (in.readBoolean()) {
            this.influences = in.readList(Influence::new);
        }
        this.geoResults = (GeoResults)in.readOptionalWriteable(GeoResults::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.jobId);
        out.writeInt(this.detectorIndex);
        out.writeDouble(this.probability);
        out.writeOptionalDouble(this.multiBucketImpact);
        out.writeOptionalString(this.byFieldName);
        out.writeOptionalString(this.byFieldValue);
        out.writeOptionalString(this.correlatedByFieldValue);
        out.writeOptionalString(this.partitionFieldName);
        out.writeOptionalString(this.partitionFieldValue);
        out.writeOptionalString(this.function);
        out.writeOptionalString(this.functionDescription);
        out.writeOptionalString(this.fieldName);
        out.writeOptionalString(this.overFieldName);
        out.writeOptionalString(this.overFieldValue);
        boolean hasTypical = this.typical != null;
        out.writeBoolean(hasTypical);
        if (hasTypical) {
            out.writeGenericValue(this.typical);
        }
        boolean hasActual = this.actual != null;
        out.writeBoolean(hasActual);
        if (hasActual) {
            out.writeGenericValue(this.actual);
        }
        out.writeBoolean(this.isInterim);
        boolean hasCauses = this.causes != null;
        out.writeBoolean(hasCauses);
        if (hasCauses) {
            out.writeList(this.causes);
        }
        out.writeDouble(this.recordScore);
        out.writeDouble(this.initialRecordScore);
        out.writeLong(this.timestamp.getTime());
        out.writeLong(this.bucketSpan);
        boolean hasInfluencers = this.influences != null;
        out.writeBoolean(hasInfluencers);
        if (hasInfluencers) {
            out.writeList(this.influences);
        }
        out.writeOptionalWriteable((Writeable)this.geoResults);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Job.ID.getPreferredName(), this.jobId);
        builder.field(Result.RESULT_TYPE.getPreferredName(), RESULT_TYPE_VALUE);
        builder.field(PROBABILITY.getPreferredName(), this.probability);
        if (this.multiBucketImpact != null) {
            builder.field(MULTI_BUCKET_IMPACT.getPreferredName(), this.multiBucketImpact);
        }
        builder.field(RECORD_SCORE.getPreferredName(), this.recordScore);
        builder.field(INITIAL_RECORD_SCORE.getPreferredName(), this.initialRecordScore);
        builder.field(BUCKET_SPAN.getPreferredName(), this.bucketSpan);
        builder.field(Detector.DETECTOR_INDEX.getPreferredName(), this.detectorIndex);
        builder.field(Result.IS_INTERIM.getPreferredName(), this.isInterim);
        builder.timeField(Result.TIMESTAMP.getPreferredName(), Result.TIMESTAMP.getPreferredName() + "_string", this.timestamp.getTime());
        if (this.byFieldName != null) {
            builder.field(BY_FIELD_NAME.getPreferredName(), this.byFieldName);
        }
        if (this.byFieldValue != null) {
            builder.field(BY_FIELD_VALUE.getPreferredName(), this.byFieldValue);
        }
        if (this.correlatedByFieldValue != null) {
            builder.field(CORRELATED_BY_FIELD_VALUE.getPreferredName(), this.correlatedByFieldValue);
        }
        if (this.partitionFieldName != null) {
            builder.field(PARTITION_FIELD_NAME.getPreferredName(), this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            builder.field(PARTITION_FIELD_VALUE.getPreferredName(), this.partitionFieldValue);
        }
        if (this.function != null) {
            builder.field(FUNCTION.getPreferredName(), this.function);
        }
        if (this.functionDescription != null) {
            builder.field(FUNCTION_DESCRIPTION.getPreferredName(), this.functionDescription);
        }
        if (this.typical != null) {
            builder.field(TYPICAL.getPreferredName(), this.typical);
        }
        if (this.actual != null) {
            builder.field(ACTUAL.getPreferredName(), this.actual);
        }
        if (this.fieldName != null) {
            builder.field(FIELD_NAME.getPreferredName(), this.fieldName);
        }
        if (this.overFieldName != null) {
            builder.field(OVER_FIELD_NAME.getPreferredName(), this.overFieldName);
        }
        if (this.overFieldValue != null) {
            builder.field(OVER_FIELD_VALUE.getPreferredName(), this.overFieldValue);
        }
        if (this.causes != null) {
            builder.field(CAUSES.getPreferredName(), this.causes);
        }
        if (this.influences != null) {
            builder.field(INFLUENCERS.getPreferredName(), this.influences);
        }
        if (this.geoResults != null) {
            builder.field(GEO_RESULTS.getPreferredName(), (ToXContent)this.geoResults);
        }
        Map<String, LinkedHashSet<String>> inputFields = this.inputFieldMap();
        for (String inputFieldName : inputFields.keySet()) {
            builder.field(inputFieldName, (Iterable)inputFields.get(inputFieldName));
        }
        builder.endObject();
        return builder;
    }

    private Map<String, LinkedHashSet<String>> inputFieldMap() {
        HashMap<String, LinkedHashSet<String>> result = new HashMap<String, LinkedHashSet<String>>();
        this.addInputFieldsToMap(result, this.byFieldName, this.byFieldValue);
        this.addInputFieldsToMap(result, this.overFieldName, this.overFieldValue);
        this.addInputFieldsToMap(result, this.partitionFieldName, this.partitionFieldValue);
        if (this.influences != null) {
            for (Influence inf : this.influences) {
                String influencerFieldName = inf.getInfluencerFieldName();
                for (String fieldValue : inf.getInfluencerFieldValues()) {
                    this.addInputFieldsToMap(result, influencerFieldName, fieldValue);
                }
            }
        }
        return result;
    }

    private void addInputFieldsToMap(Map<String, LinkedHashSet<String>> inputFields, String inputFieldName, String fieldValue) {
        if (!Strings.isNullOrEmpty((String)inputFieldName) && fieldValue != null && ReservedFieldNames.isValidFieldName(inputFieldName)) {
            inputFields.computeIfAbsent(inputFieldName, k -> new LinkedHashSet()).add(fieldValue);
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getId() {
        return AnomalyRecord.buildId(this.jobId, this.timestamp, this.bucketSpan, this.detectorIndex, this.byFieldValue, this.overFieldValue, this.partitionFieldValue);
    }

    static String buildId(String jobId, Date timestamp, long bucketSpan, int detectorIndex, String byFieldValue, String overFieldValue, String partitionFieldValue) {
        return jobId + "_record_" + timestamp.getTime() + "_" + bucketSpan + "_" + detectorIndex + "_" + MachineLearningField.valuesToId(byFieldValue, overFieldValue, partitionFieldValue);
    }

    public int getDetectorIndex() {
        return this.detectorIndex;
    }

    public void setDetectorIndex(int detectorIndex) {
        this.detectorIndex = detectorIndex;
    }

    public double getRecordScore() {
        return this.recordScore;
    }

    public void setRecordScore(double recordScore) {
        this.recordScore = recordScore;
    }

    public double getInitialRecordScore() {
        return this.initialRecordScore;
    }

    public void setInitialRecordScore(double initialRecordScore) {
        this.initialRecordScore = initialRecordScore;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getBucketSpan() {
        return this.bucketSpan;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double value) {
        this.probability = value;
    }

    public double getMultiBucketImpact() {
        return this.multiBucketImpact;
    }

    public void setMultiBucketImpact(double value) {
        this.multiBucketImpact = value;
    }

    public String getByFieldName() {
        return this.byFieldName;
    }

    public void setByFieldName(String value) {
        this.byFieldName = value.intern();
    }

    public String getByFieldValue() {
        return this.byFieldValue;
    }

    public void setByFieldValue(String value) {
        this.byFieldValue = value.intern();
    }

    public String getCorrelatedByFieldValue() {
        return this.correlatedByFieldValue;
    }

    public void setCorrelatedByFieldValue(String value) {
        this.correlatedByFieldValue = value.intern();
    }

    public String getPartitionFieldName() {
        return this.partitionFieldName;
    }

    public void setPartitionFieldName(String field) {
        this.partitionFieldName = field.intern();
    }

    public String getPartitionFieldValue() {
        return this.partitionFieldValue;
    }

    public void setPartitionFieldValue(String value) {
        this.partitionFieldValue = value.intern();
    }

    public String getFunction() {
        return this.function;
    }

    public void setFunction(String name) {
        this.function = name.intern();
    }

    public String getFunctionDescription() {
        return this.functionDescription;
    }

    public void setFunctionDescription(String functionDescription) {
        this.functionDescription = functionDescription.intern();
    }

    public List<Double> getTypical() {
        return this.typical;
    }

    public void setTypical(List<Double> typical) {
        this.typical = typical;
    }

    public List<Double> getActual() {
        return this.actual;
    }

    public void setActual(List<Double> actual) {
        this.actual = actual;
    }

    public boolean isInterim() {
        return this.isInterim;
    }

    public void setInterim(boolean interim) {
        this.isInterim = interim;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String field) {
        this.fieldName = field.intern();
    }

    public String getOverFieldName() {
        return this.overFieldName;
    }

    public void setOverFieldName(String name) {
        this.overFieldName = name.intern();
    }

    public String getOverFieldValue() {
        return this.overFieldValue;
    }

    public void setOverFieldValue(String value) {
        this.overFieldValue = value.intern();
    }

    public List<AnomalyCause> getCauses() {
        return this.causes;
    }

    public void setCauses(List<AnomalyCause> causes) {
        this.causes = causes;
    }

    public void addCause(AnomalyCause cause) {
        if (this.causes == null) {
            this.causes = new ArrayList<AnomalyCause>();
        }
        this.causes.add(cause);
    }

    public List<Influence> getInfluencers() {
        return this.influences;
    }

    public void setInfluencers(List<Influence> influencers) {
        this.influences = influencers;
    }

    public GeoResults getGeoResults() {
        return this.geoResults;
    }

    public void setGeoResults(GeoResults geoResults) {
        this.geoResults = geoResults;
    }

    public int hashCode() {
        return Objects.hash(this.jobId, this.detectorIndex, this.bucketSpan, this.probability, this.multiBucketImpact, this.recordScore, this.initialRecordScore, this.typical, this.actual, this.function, this.functionDescription, this.fieldName, this.byFieldName, this.byFieldValue, this.correlatedByFieldValue, this.partitionFieldName, this.partitionFieldValue, this.overFieldName, this.overFieldValue, this.timestamp, this.isInterim, this.causes, this.influences, this.jobId, this.geoResults);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnomalyRecord)) {
            return false;
        }
        AnomalyRecord that = (AnomalyRecord)other;
        return Objects.equals(this.jobId, that.jobId) && this.detectorIndex == that.detectorIndex && this.bucketSpan == that.bucketSpan && this.probability == that.probability && Objects.equals(this.multiBucketImpact, that.multiBucketImpact) && this.recordScore == that.recordScore && this.initialRecordScore == that.initialRecordScore && Objects.deepEquals(this.typical, that.typical) && Objects.deepEquals(this.actual, that.actual) && Objects.equals(this.function, that.function) && Objects.equals(this.functionDescription, that.functionDescription) && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.byFieldName, that.byFieldName) && Objects.equals(this.byFieldValue, that.byFieldValue) && Objects.equals(this.correlatedByFieldValue, that.correlatedByFieldValue) && Objects.equals(this.partitionFieldName, that.partitionFieldName) && Objects.equals(this.partitionFieldValue, that.partitionFieldValue) && Objects.equals(this.overFieldName, that.overFieldName) && Objects.equals(this.overFieldValue, that.overFieldValue) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.isInterim, that.isInterim) && Objects.equals(this.causes, that.causes) && Objects.equals(this.geoResults, that.geoResults) && Objects.equals(this.influences, that.influences);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }
}

