/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenization;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public abstract class Tokenization
implements NamedXContentObject,
NamedWriteable {
    public static final ParseField DO_LOWER_CASE = new ParseField("do_lower_case", new String[0]);
    public static final ParseField WITH_SPECIAL_TOKENS = new ParseField("with_special_tokens", new String[0]);
    public static final ParseField MAX_SEQUENCE_LENGTH = new ParseField("max_sequence_length", new String[0]);
    public static final ParseField TRUNCATE = new ParseField("truncate", new String[0]);
    private static final int DEFAULT_MAX_SEQUENCE_LENGTH = 512;
    private static final boolean DEFAULT_DO_LOWER_CASE = false;
    private static final boolean DEFAULT_WITH_SPECIAL_TOKENS = true;
    private static final Truncate DEFAULT_TRUNCATION = Truncate.FIRST;
    protected final boolean doLowerCase;
    protected final boolean withSpecialTokens;
    protected final int maxSequenceLength;
    protected final Truncate truncate;

    static <T extends Tokenization> void declareCommonFields(ConstructingObjectParser<T, ?> parser) {
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), DO_LOWER_CASE);
        parser.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), WITH_SPECIAL_TOKENS);
        parser.declareInt(ConstructingObjectParser.optionalConstructorArg(), MAX_SEQUENCE_LENGTH);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TRUNCATE);
    }

    public static BertTokenization createDefault() {
        return new BertTokenization(null, null, null, DEFAULT_TRUNCATION);
    }

    Tokenization(@Nullable Boolean doLowerCase, @Nullable Boolean withSpecialTokens, @Nullable Integer maxSequenceLength, @Nullable Truncate truncate) {
        if (maxSequenceLength != null && maxSequenceLength <= 0) {
            throw new IllegalArgumentException("[" + MAX_SEQUENCE_LENGTH.getPreferredName() + "] must be positive");
        }
        this.doLowerCase = Optional.ofNullable(doLowerCase).orElse(false);
        this.withSpecialTokens = Optional.ofNullable(withSpecialTokens).orElse(true);
        this.maxSequenceLength = Optional.ofNullable(maxSequenceLength).orElse(512);
        this.truncate = Optional.ofNullable(truncate).orElse(DEFAULT_TRUNCATION);
    }

    public Tokenization(StreamInput in) throws IOException {
        this.doLowerCase = in.readBoolean();
        this.withSpecialTokens = in.readBoolean();
        this.maxSequenceLength = in.readVInt();
        this.truncate = (Truncate)in.readEnum(Truncate.class);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.doLowerCase);
        out.writeBoolean(this.withSpecialTokens);
        out.writeVInt(this.maxSequenceLength);
        out.writeEnum((Enum)this.truncate);
    }

    abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DO_LOWER_CASE.getPreferredName(), this.doLowerCase);
        builder.field(WITH_SPECIAL_TOKENS.getPreferredName(), this.withSpecialTokens);
        builder.field(MAX_SEQUENCE_LENGTH.getPreferredName(), this.maxSequenceLength);
        builder.field(TRUNCATE.getPreferredName(), this.truncate.toString());
        builder = this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tokenization that = (Tokenization)o;
        return this.doLowerCase == that.doLowerCase && this.withSpecialTokens == that.withSpecialTokens && this.truncate == that.truncate && this.maxSequenceLength == that.maxSequenceLength;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.doLowerCase, this.truncate, this.withSpecialTokens, this.maxSequenceLength});
    }

    public boolean doLowerCase() {
        return this.doLowerCase;
    }

    public boolean withSpecialTokens() {
        return this.withSpecialTokens;
    }

    public int maxSequenceLength() {
        return this.maxSequenceLength;
    }

    public Truncate getTruncate() {
        return this.truncate;
    }

    public static enum Truncate {
        FIRST,
        SECOND,
        NONE;


        public static Truncate fromString(String value) {
            return Truncate.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

