/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TextClassificationConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class TextClassificationConfigUpdate
extends NlpConfigUpdate
implements NamedXContentObject {
    public static final String NAME = "text_classification";
    private static final ObjectParser<Builder, Void> STRICT_PARSER = TextClassificationConfigUpdate.createParser(false);
    private final List<String> classificationLabels;
    private final Integer numTopClasses;
    private final String resultsField;

    public static TextClassificationConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        Integer numTopClasses = (Integer)options.remove(TextClassificationConfig.NUM_TOP_CLASSES.getPreferredName());
        String resultsField = (String)options.remove(TextClassificationConfig.RESULTS_FIELD.getPreferredName());
        List classificationLabels = (List)options.remove(TextClassificationConfig.CLASSIFICATION_LABELS.getPreferredName());
        TokenizationUpdate tokenizationUpdate = NlpConfigUpdate.tokenizationFromMap(options);
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", options.keySet());
        }
        return new TextClassificationConfigUpdate(classificationLabels, numTopClasses, resultsField, tokenizationUpdate);
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME, lenient, Builder::new);
        parser.declareStringArray(Builder::setClassificationLabels, TextClassificationConfig.CLASSIFICATION_LABELS);
        parser.declareString(Builder::setResultsField, TextClassificationConfig.RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopClasses, TextClassificationConfig.NUM_TOP_CLASSES);
        parser.declareNamedObject(Builder::setTokenizationUpdate, (p, c, n) -> (TokenizationUpdate)p.namedObject(TokenizationUpdate.class, n, (Object)lenient), NlpConfig.TOKENIZATION);
        return parser;
    }

    public static TextClassificationConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public TextClassificationConfigUpdate(List<String> classificationLabels, Integer numTopClasses, String resultsField, TokenizationUpdate tokenizationUpdate) {
        super(tokenizationUpdate);
        this.classificationLabels = classificationLabels;
        this.numTopClasses = numTopClasses;
        this.resultsField = resultsField;
    }

    public TextClassificationConfigUpdate(StreamInput in) throws IOException {
        super(in);
        this.classificationLabels = in.readOptionalStringList();
        this.numTopClasses = in.readOptionalVInt();
        this.resultsField = in.readOptionalString();
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalStringCollection(this.classificationLabels);
        out.writeOptionalVInt(this.numTopClasses);
        out.writeOptionalString(this.resultsField);
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof TextClassificationConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        TextClassificationConfig classificationConfig = (TextClassificationConfig)originalConfig;
        if (this.isNoop(classificationConfig)) {
            return originalConfig;
        }
        TextClassificationConfig.Builder builder = new TextClassificationConfig.Builder(classificationConfig);
        if (this.numTopClasses != null) {
            builder.setNumTopClasses(this.numTopClasses);
        }
        if (this.classificationLabels != null) {
            if (this.classificationLabels.size() != classificationConfig.getClassificationLabels().size()) {
                throw ExceptionsHelper.badRequestException("The number of [{}] the model is defined with [{}] does not match the number in the update [{}]", TextClassificationConfig.CLASSIFICATION_LABELS, classificationConfig.getClassificationLabels().size(), this.classificationLabels.size());
            }
            builder.setClassificationLabels(this.classificationLabels);
        }
        if (this.resultsField != null) {
            builder.setResultsField(this.resultsField);
        }
        if (this.tokenizationUpdate != null) {
            builder.setTokenization(this.tokenizationUpdate.apply(classificationConfig.getTokenization()));
        }
        return builder.build();
    }

    boolean isNoop(TextClassificationConfig originalConfig) {
        return !(this.numTopClasses != null && this.numTopClasses.intValue() != originalConfig.getNumTopClasses() || this.classificationLabels != null || this.resultsField != null && !this.resultsField.equals(originalConfig.getResultsField()) || !super.isNoop());
    }

    @Override
    public boolean isSupported(InferenceConfig config) {
        return config instanceof TextClassificationConfig;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public Integer getNumTopClasses() {
        return this.numTopClasses;
    }

    public List<String> getClassificationLabels() {
        return this.classificationLabels;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setClassificationLabels(this.classificationLabels).setNumTopClasses(this.numTopClasses).setResultsField(this.resultsField).setTokenizationUpdate(this.tokenizationUpdate);
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.numTopClasses != null) {
            builder.field(TextClassificationConfig.NUM_TOP_CLASSES.getPreferredName(), this.numTopClasses);
        }
        if (this.classificationLabels != null) {
            builder.field(TextClassificationConfig.CLASSIFICATION_LABELS.getPreferredName(), this.classificationLabels);
        }
        if (this.resultsField != null) {
            builder.field(TextClassificationConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextClassificationConfigUpdate that = (TextClassificationConfigUpdate)o;
        return Objects.equals(this.classificationLabels, that.classificationLabels) && Objects.equals(this.numTopClasses, that.numTopClasses) && Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.tokenizationUpdate, that.tokenizationUpdate);
    }

    public int hashCode() {
        return Objects.hash(this.classificationLabels, this.numTopClasses, this.resultsField, this.tokenizationUpdate);
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, TextClassificationConfigUpdate> {
        private List<String> classificationLabels;
        private Integer numTopClasses;
        private String resultsField;
        private TokenizationUpdate tokenizationUpdate;

        public Builder setNumTopClasses(Integer numTopClasses) {
            this.numTopClasses = numTopClasses;
            return this;
        }

        public Builder setClassificationLabels(List<String> classificationLabels) {
            this.classificationLabels = classificationLabels;
            return this;
        }

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setTokenizationUpdate(TokenizationUpdate tokenizationUpdate) {
            this.tokenizationUpdate = tokenizationUpdate;
            return this;
        }

        @Override
        public TextClassificationConfigUpdate build() {
            return new TextClassificationConfigUpdate(this.classificationLabels, this.numTopClasses, this.resultsField, this.tokenizationUpdate);
        }
    }
}

