/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;

public class RegressionConfigUpdate
implements InferenceConfigUpdate,
NamedXContentObject {
    public static final ParseField NAME = RegressionConfig.NAME;
    public static RegressionConfigUpdate EMPTY_PARAMS = new RegressionConfigUpdate(null, null);
    private static final ObjectParser<Builder, Void> STRICT_PARSER = RegressionConfigUpdate.createParser(false);
    private final String resultsField;
    private final Integer numTopFeatureImportanceValues;

    public static RegressionConfigUpdate fromMap(Map<String, Object> map) {
        HashMap<String, Object> options = new HashMap<String, Object>(map);
        String resultsField = (String)options.remove(RegressionConfig.RESULTS_FIELD.getPreferredName());
        Integer featureImportance = (Integer)options.remove(RegressionConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName());
        if (!options.isEmpty()) {
            throw ExceptionsHelper.badRequestException("Unrecognized fields {}.", map.keySet());
        }
        return new RegressionConfigUpdate(resultsField, featureImportance);
    }

    public static RegressionConfigUpdate fromConfig(RegressionConfig config) {
        return new RegressionConfigUpdate(config.getResultsField(), config.getNumTopFeatureImportanceValues());
    }

    private static ObjectParser<Builder, Void> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareString(Builder::setResultsField, RegressionConfig.RESULTS_FIELD);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, RegressionConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        return parser;
    }

    public static RegressionConfigUpdate fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public RegressionConfigUpdate(String resultsField, Integer numTopFeatureImportanceValues) {
        this.resultsField = resultsField;
        if (numTopFeatureImportanceValues != null && numTopFeatureImportanceValues < 0) {
            throw new IllegalArgumentException("[" + RegressionConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName() + "] must be greater than or equal to 0");
        }
        this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
        InferenceConfigUpdate.checkFieldUniqueness(resultsField);
    }

    public RegressionConfigUpdate(StreamInput in) throws IOException {
        this.resultsField = in.readOptionalString();
        this.numTopFeatureImportanceValues = in.readOptionalVInt();
    }

    public Integer getNumTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public InferenceConfigUpdate.Builder<? extends InferenceConfigUpdate.Builder<?, ?>, ? extends InferenceConfigUpdate> newBuilder() {
        return new Builder().setNumTopFeatureImportanceValues(this.numTopFeatureImportanceValues).setResultsField(this.resultsField);
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.resultsField);
        out.writeOptionalVInt(this.numTopFeatureImportanceValues);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.resultsField != null) {
            builder.field(RegressionConfig.RESULTS_FIELD.getPreferredName(), this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.field(RegressionConfig.NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.numTopFeatureImportanceValues);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegressionConfigUpdate that = (RegressionConfigUpdate)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.numTopFeatureImportanceValues, that.numTopFeatureImportanceValues);
    }

    public int hashCode() {
        return Objects.hash(this.resultsField, this.numTopFeatureImportanceValues);
    }

    @Override
    public InferenceConfig apply(InferenceConfig originalConfig) {
        if (!(originalConfig instanceof RegressionConfig)) {
            throw ExceptionsHelper.badRequestException("Inference config of type [{}] can not be updated with a inference request of type [{}]", originalConfig.getName(), this.getName());
        }
        RegressionConfig regressionConfig = (RegressionConfig)originalConfig;
        if (this.isNoop(regressionConfig)) {
            return originalConfig;
        }
        RegressionConfig.Builder builder = new RegressionConfig.Builder(regressionConfig);
        if (this.resultsField != null) {
            builder.setResultsField(this.resultsField);
        }
        if (this.numTopFeatureImportanceValues != null) {
            builder.setNumTopFeatureImportanceValues(this.numTopFeatureImportanceValues);
        }
        return builder.build();
    }

    @Override
    public boolean isSupported(InferenceConfig inferenceConfig) {
        return inferenceConfig instanceof RegressionConfig;
    }

    boolean isNoop(RegressionConfig originalConfig) {
        return !(this.resultsField != null && !originalConfig.getResultsField().equals(this.resultsField) || this.numTopFeatureImportanceValues != null && originalConfig.getNumTopFeatureImportanceValues() != this.numTopFeatureImportanceValues.intValue());
    }

    public static class Builder
    implements InferenceConfigUpdate.Builder<Builder, RegressionConfigUpdate> {
        private String resultsField;
        private Integer numTopFeatureImportanceValues;

        @Override
        public Builder setResultsField(String resultsField) {
            this.resultsField = resultsField;
            return this;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        @Override
        public RegressionConfigUpdate build() {
            return new RegressionConfigUpdate(this.resultsField, this.numTopFeatureImportanceValues);
        }
    }
}

