/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.MPNetTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.MPNetTokenizationUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.NlpConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObject;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public abstract class NlpConfigUpdate
implements InferenceConfigUpdate,
NamedXContentObject {
    protected final TokenizationUpdate tokenizationUpdate;

    public static TokenizationUpdate tokenizationFromMap(Map<String, Object> map) {
        Map tokenization = (Map)map.remove("tokenization");
        if (tokenization == null) {
            return null;
        }
        Map<String, Function<Tokenization.Truncate, TokenizationUpdate>> knownTokenizers = Map.of(BertTokenization.NAME.getPreferredName(), BertTokenizationUpdate::new, MPNetTokenization.NAME.getPreferredName(), MPNetTokenizationUpdate::new);
        Map tokenizationConfig = null;
        Function<Tokenization.Truncate, TokenizationUpdate> updater = null;
        for (String tokenizerType : knownTokenizers.keySet()) {
            tokenizationConfig = (Map)tokenization.remove(tokenizerType);
            if (tokenizationConfig == null) continue;
            updater = knownTokenizers.get(tokenizerType);
            break;
        }
        if (tokenizationConfig == null && !tokenization.isEmpty()) {
            throw ExceptionsHelper.badRequestException("unknown tokenization type expecting one of {} got {}", knownTokenizers.keySet().stream().sorted().collect(Collectors.toList()), tokenization.keySet());
        }
        Object truncate = tokenizationConfig.remove("truncate");
        if (truncate == null) {
            return null;
        }
        return (TokenizationUpdate)updater.apply(Tokenization.Truncate.fromString(truncate.toString()));
    }

    public NlpConfigUpdate(@Nullable TokenizationUpdate tokenizationUpdate) {
        this.tokenizationUpdate = tokenizationUpdate;
    }

    public NlpConfigUpdate(StreamInput in) throws IOException {
        this.tokenizationUpdate = in.getVersion().onOrAfter(Version.V_8_1_0) ? (TokenizationUpdate)in.readOptionalNamedWriteable(TokenizationUpdate.class) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_8_1_0)) {
            out.writeOptionalNamedWriteable((NamedWriteable)this.tokenizationUpdate);
        }
    }

    protected boolean isNoop() {
        return this.tokenizationUpdate == null || this.tokenizationUpdate.isNoop();
    }

    public TokenizationUpdate getTokenizationUpdate() {
        return this.tokenizationUpdate;
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.tokenizationUpdate != null) {
            NamedXContentObjectHelper.writeNamedObject(builder, params, NlpConfig.TOKENIZATION.getPreferredName(), this.tokenizationUpdate);
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public String getName() {
        return InferenceConfigUpdate.super.getName();
    }
}

