/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.BertTokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.Tokenization;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TokenizationUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class BertTokenizationUpdate
implements TokenizationUpdate {
    public static final ParseField NAME = BertTokenization.NAME;
    public static ConstructingObjectParser<BertTokenizationUpdate, Void> PARSER = new ConstructingObjectParser("bert_tokenization_update", a -> new BertTokenizationUpdate(a[0] == null ? null : Tokenization.Truncate.fromString((String)a[0])));
    private final Tokenization.Truncate truncate;

    public static BertTokenizationUpdate fromXContent(XContentParser parser) {
        return (BertTokenizationUpdate)PARSER.apply(parser, null);
    }

    public BertTokenizationUpdate(@Nullable Tokenization.Truncate truncate) {
        this.truncate = truncate;
    }

    public BertTokenizationUpdate(StreamInput in) throws IOException {
        this.truncate = (Tokenization.Truncate)in.readOptionalEnum(Tokenization.Truncate.class);
    }

    @Override
    public Tokenization apply(Tokenization originalConfig) {
        if (!(originalConfig instanceof BertTokenization)) {
            throw ExceptionsHelper.badRequestException("Tokenization config of type [{}] can not be updated with a request of type [{}]", originalConfig.getName(), this.getName());
        }
        if (this.isNoop()) {
            return originalConfig;
        }
        return new BertTokenization(originalConfig.doLowerCase(), originalConfig.withSpecialTokens(), originalConfig.maxSequenceLength(), this.truncate);
    }

    @Override
    public boolean isNoop() {
        return this.truncate == null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(Tokenization.TRUNCATE.getPreferredName(), this.truncate.toString());
        builder.endObject();
        return builder;
    }

    public String getWriteableName() {
        return BertTokenization.NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalEnum((Enum)this.truncate);
    }

    @Override
    public String getName() {
        return BertTokenization.NAME.getPreferredName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BertTokenizationUpdate that = (BertTokenizationUpdate)o;
        return this.truncate == that.truncate;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.truncate});
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), Tokenization.TRUNCATE);
    }
}

