/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.allocation;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationState;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingStateAndReason;

public class AllocationStats
implements ToXContentObject,
Writeable {
    private final String modelId;
    private AllocationState state;
    private AllocationStatus allocationStatus;
    private String reason;
    @Nullable
    private final Integer inferenceThreads;
    @Nullable
    private final Integer modelThreads;
    @Nullable
    private final Integer queueCapacity;
    private final Instant startTime;
    private final List<NodeStats> nodeStats;

    public AllocationStats(String modelId, @Nullable Integer inferenceThreads, @Nullable Integer modelThreads, @Nullable Integer queueCapacity, Instant startTime, List<NodeStats> nodeStats) {
        this.modelId = modelId;
        this.inferenceThreads = inferenceThreads;
        this.modelThreads = modelThreads;
        this.queueCapacity = queueCapacity;
        this.startTime = Objects.requireNonNull(startTime);
        this.nodeStats = nodeStats;
        this.state = null;
        this.reason = null;
    }

    public AllocationStats(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.inferenceThreads = in.readOptionalVInt();
        this.modelThreads = in.readOptionalVInt();
        this.queueCapacity = in.readOptionalVInt();
        this.startTime = in.readInstant();
        this.nodeStats = in.readList(NodeStats::new);
        this.state = (AllocationState)in.readOptionalEnum(AllocationState.class);
        this.reason = in.readOptionalString();
        this.allocationStatus = (AllocationStatus)in.readOptionalWriteable(AllocationStatus::new);
    }

    public String getModelId() {
        return this.modelId;
    }

    @Nullable
    public Integer getInferenceThreads() {
        return this.inferenceThreads;
    }

    @Nullable
    public Integer getModelThreads() {
        return this.modelThreads;
    }

    @Nullable
    public Integer getQueueCapacity() {
        return this.queueCapacity;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public List<NodeStats> getNodeStats() {
        return this.nodeStats;
    }

    public AllocationState getState() {
        return this.state;
    }

    public AllocationStats setState(AllocationState state) {
        this.state = state;
        return this;
    }

    public AllocationStats setAllocationStatus(AllocationStatus allocationStatus) {
        this.allocationStatus = allocationStatus;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public AllocationStats setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("model_id", this.modelId);
        if (this.inferenceThreads != null) {
            builder.field(StartTrainedModelDeploymentAction.TaskParams.INFERENCE_THREADS.getPreferredName(), this.inferenceThreads);
        }
        if (this.modelThreads != null) {
            builder.field(StartTrainedModelDeploymentAction.TaskParams.MODEL_THREADS.getPreferredName(), this.modelThreads);
        }
        if (this.queueCapacity != null) {
            builder.field(StartTrainedModelDeploymentAction.TaskParams.QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
        }
        if (this.state != null) {
            builder.field("state", (Enum)this.state);
        }
        if (this.reason != null) {
            builder.field("reason", this.reason);
        }
        if (this.allocationStatus != null) {
            builder.field("allocation_status", (ToXContent)this.allocationStatus);
        }
        builder.timeField("start_time", "start_time_string", this.startTime.toEpochMilli());
        int totalErrorCount = this.nodeStats.stream().mapToInt(NodeStats::getErrorCount).sum();
        int totalRejectedExecutionCount = this.nodeStats.stream().mapToInt(NodeStats::getRejectedExecutionCount).sum();
        int totalTimeoutCount = this.nodeStats.stream().mapToInt(NodeStats::getTimeoutCount).sum();
        long totalInferenceCount = this.nodeStats.stream().filter(n -> n.getInferenceCount().isPresent()).mapToLong(n -> n.getInferenceCount().get()).sum();
        if (totalErrorCount > 0) {
            builder.field("error_count", totalErrorCount);
        }
        if (totalRejectedExecutionCount > 0) {
            builder.field("rejected_execution_count", totalRejectedExecutionCount);
        }
        if (totalTimeoutCount > 0) {
            builder.field("timeout_count", totalTimeoutCount);
        }
        if (totalInferenceCount > 0L) {
            builder.field("inference_count", totalInferenceCount);
        }
        builder.startArray("nodes");
        for (NodeStats nodeStat : this.nodeStats) {
            nodeStat.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalVInt(this.inferenceThreads);
        out.writeOptionalVInt(this.modelThreads);
        out.writeOptionalVInt(this.queueCapacity);
        out.writeInstant(this.startTime);
        out.writeList(this.nodeStats);
        out.writeOptionalEnum((Enum)this.state);
        out.writeOptionalString(this.reason);
        out.writeOptionalWriteable((Writeable)this.allocationStatus);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AllocationStats that = (AllocationStats)o;
        return Objects.equals(this.modelId, that.modelId) && Objects.equals(this.inferenceThreads, that.inferenceThreads) && Objects.equals(this.modelThreads, that.modelThreads) && Objects.equals(this.queueCapacity, that.queueCapacity) && Objects.equals(this.startTime, that.startTime) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.reason, that.reason) && Objects.equals(this.allocationStatus, that.allocationStatus) && Objects.equals(this.nodeStats, that.nodeStats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.modelId, this.inferenceThreads, this.modelThreads, this.queueCapacity, this.startTime, this.nodeStats, this.state, this.reason, this.allocationStatus});
    }

    public static class NodeStats
    implements ToXContentObject,
    Writeable {
        private final DiscoveryNode node;
        private final Long inferenceCount;
        private final Double avgInferenceTime;
        private final Instant lastAccess;
        private final Integer pendingCount;
        private final int errorCount;
        private final int rejectedExecutionCount;
        private final int timeoutCount;
        private final RoutingStateAndReason routingState;
        private final Instant startTime;
        private final Integer inferenceThreads;
        private final Integer modelThreads;

        public static NodeStats forStartedState(DiscoveryNode node, long inferenceCount, Double avgInferenceTime, int pendingCount, int errorCount, int rejectedExecutionCount, int timeoutCount, Instant lastAccess, Instant startTime, Integer inferenceThreads, Integer modelThreads) {
            return new NodeStats(node, inferenceCount, avgInferenceTime, lastAccess, pendingCount, errorCount, rejectedExecutionCount, timeoutCount, new RoutingStateAndReason(RoutingState.STARTED, null), Objects.requireNonNull(startTime), inferenceThreads, modelThreads);
        }

        public static NodeStats forNotStartedState(DiscoveryNode node, RoutingState state, String reason) {
            return new NodeStats(node, null, null, null, null, 0, 0, 0, new RoutingStateAndReason(state, reason), null, null, null);
        }

        public NodeStats(DiscoveryNode node, Long inferenceCount, Double avgInferenceTime, Instant lastAccess, Integer pendingCount, int errorCount, int rejectedExecutionCount, int timeoutCount, RoutingStateAndReason routingState, @Nullable Instant startTime, @Nullable Integer inferenceThreads, @Nullable Integer modelThreads) {
            this.node = node;
            this.inferenceCount = inferenceCount;
            this.avgInferenceTime = avgInferenceTime;
            this.lastAccess = lastAccess;
            this.pendingCount = pendingCount;
            this.errorCount = errorCount;
            this.rejectedExecutionCount = rejectedExecutionCount;
            this.timeoutCount = timeoutCount;
            this.routingState = routingState;
            this.startTime = startTime;
            this.inferenceThreads = inferenceThreads;
            this.modelThreads = modelThreads;
            assert (this.lastAccess != null || inferenceCount == null || inferenceCount == 0L);
        }

        public NodeStats(StreamInput in) throws IOException {
            this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
            this.inferenceCount = in.readOptionalLong();
            this.avgInferenceTime = in.readOptionalDouble();
            this.lastAccess = in.readOptionalInstant();
            this.pendingCount = in.readOptionalVInt();
            this.routingState = (RoutingStateAndReason)in.readOptionalWriteable(RoutingStateAndReason::new);
            this.startTime = in.readOptionalInstant();
            if (in.getVersion().onOrAfter(Version.V_8_1_0)) {
                this.inferenceThreads = in.readOptionalVInt();
                this.modelThreads = in.readOptionalVInt();
                this.errorCount = in.readVInt();
                this.rejectedExecutionCount = in.readVInt();
                this.timeoutCount = in.readVInt();
            } else {
                this.inferenceThreads = null;
                this.modelThreads = null;
                this.errorCount = 0;
                this.rejectedExecutionCount = 0;
                this.timeoutCount = 0;
            }
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public RoutingStateAndReason getRoutingState() {
            return this.routingState;
        }

        public Optional<Long> getInferenceCount() {
            return Optional.ofNullable(this.inferenceCount);
        }

        public Optional<Double> getAvgInferenceTime() {
            return Optional.ofNullable(this.avgInferenceTime);
        }

        public Instant getLastAccess() {
            return this.lastAccess;
        }

        public Integer getPendingCount() {
            return this.pendingCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public int getRejectedExecutionCount() {
            return this.rejectedExecutionCount;
        }

        public int getTimeoutCount() {
            return this.timeoutCount;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.node != null) {
                builder.startObject("node");
                this.node.toXContent(builder, params);
                builder.endObject();
            }
            builder.field("routing_state", (ToXContent)this.routingState);
            if (this.inferenceCount != null) {
                builder.field("inference_count", this.inferenceCount);
            }
            if (this.avgInferenceTime != null && this.inferenceCount != null && this.inferenceCount > 0L) {
                builder.field("average_inference_time_ms", this.avgInferenceTime);
            }
            if (this.lastAccess != null) {
                builder.timeField("last_access", "last_access_string", this.lastAccess.toEpochMilli());
            }
            if (this.pendingCount != null) {
                builder.field("number_of_pending_requests", this.pendingCount);
            }
            if (this.errorCount > 0) {
                builder.field("error_count", this.errorCount);
            }
            if (this.rejectedExecutionCount > 0) {
                builder.field("rejected_execution_count", this.rejectedExecutionCount);
            }
            if (this.timeoutCount > 0) {
                builder.field("timeout_count", this.timeoutCount);
            }
            if (this.startTime != null) {
                builder.timeField("start_time", "start_time_string", this.startTime.toEpochMilli());
            }
            if (this.inferenceThreads != null) {
                builder.field("inference_threads", this.inferenceThreads);
            }
            if (this.modelThreads != null) {
                builder.field("model_threads", this.modelThreads);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.node);
            out.writeOptionalLong(this.inferenceCount);
            out.writeOptionalDouble(this.avgInferenceTime);
            out.writeOptionalInstant(this.lastAccess);
            out.writeOptionalVInt(this.pendingCount);
            out.writeOptionalWriteable((Writeable)this.routingState);
            out.writeOptionalInstant(this.startTime);
            if (out.getVersion().onOrAfter(Version.V_8_1_0)) {
                out.writeOptionalVInt(this.inferenceThreads);
                out.writeOptionalVInt(this.modelThreads);
                out.writeVInt(this.errorCount);
                out.writeVInt(this.rejectedExecutionCount);
                out.writeVInt(this.timeoutCount);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeStats that = (NodeStats)o;
            return Objects.equals(this.inferenceCount, that.inferenceCount) && Objects.equals(that.avgInferenceTime, this.avgInferenceTime) && Objects.equals(this.node, that.node) && Objects.equals(this.lastAccess, that.lastAccess) && Objects.equals(this.pendingCount, that.pendingCount) && Objects.equals(this.errorCount, that.errorCount) && Objects.equals(this.rejectedExecutionCount, that.rejectedExecutionCount) && Objects.equals(this.timeoutCount, that.timeoutCount) && Objects.equals(this.routingState, that.routingState) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.inferenceThreads, that.inferenceThreads) && Objects.equals(this.modelThreads, that.modelThreads);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.inferenceCount, this.avgInferenceTime, this.lastAccess, this.pendingCount, this.errorCount, this.rejectedExecutionCount, this.timeoutCount, this.routingState, this.startTime, this.inferenceThreads, this.modelThreads);
        }
    }
}

