/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.validation.SourceDestValidator;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsConfig;
import org.elasticsearch.xpack.core.ml.dataframe.DataFrameAnalyticsSource;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.MlStrings;

public class PutDataFrameAnalyticsAction
extends ActionType<Response> {
    public static final PutDataFrameAnalyticsAction INSTANCE = new PutDataFrameAnalyticsAction();
    public static final String NAME = "cluster:admin/xpack/ml/data_frame/analytics/put";

    private PutDataFrameAnalyticsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private DataFrameAnalyticsConfig config;

        public Response(DataFrameAnalyticsConfig config) {
            this.config = config;
        }

        Response() {
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.config = new DataFrameAnalyticsConfig(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.config.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.config.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.config, response.config);
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private DataFrameAnalyticsConfig config;

        public static Request parseRequest(String id, XContentParser parser) {
            DataFrameAnalyticsConfig.Builder config = (DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.STRICT_PARSER.apply(parser, null);
            if (config.getId() == null) {
                config.setId(id);
            } else if (!Strings.isNullOrEmpty((String)id) && !id.equals(config.getId())) {
                throw new IllegalArgumentException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", DataFrameAnalyticsConfig.ID, config.getId(), id));
            }
            return new Request(config.build());
        }

        public static Request parseRequestForExplain(XContentParser parser) {
            DataFrameAnalyticsConfig.Builder configBuilder = (DataFrameAnalyticsConfig.Builder)DataFrameAnalyticsConfig.STRICT_PARSER.apply(parser, null);
            DataFrameAnalyticsConfig config = configBuilder.buildForExplain();
            return new Request(config);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.config = new DataFrameAnalyticsConfig(in);
        }

        public Request(DataFrameAnalyticsConfig config) {
            this.config = config;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.config.writeTo(out);
        }

        public DataFrameAnalyticsConfig getConfig() {
            return this.config;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException error = null;
            error = this.checkConfigIdIsValid(this.config, error);
            error = SourceDestValidator.validateRequest(error, this.config.getDest().getIndex());
            error = this.checkNoIncludedAnalyzedFieldsAreExcludedBySourceFiltering(this.config, error);
            return error;
        }

        private ActionRequestValidationException checkConfigIdIsValid(DataFrameAnalyticsConfig analyticsConfig, ActionRequestValidationException error) {
            if (!MlStrings.isValidId(analyticsConfig.getId())) {
                error = ValidateActions.addValidationError((String)Messages.getMessage("Invalid {0}; ''{1}'' can contain lowercase alphanumeric (a-z and 0-9), hyphens or underscores; must start and end with alphanumeric", DataFrameAnalyticsConfig.ID, analyticsConfig.getId()), (ActionRequestValidationException)error);
            }
            if (!MlStrings.hasValidLengthForId(analyticsConfig.getId())) {
                error = ValidateActions.addValidationError((String)Messages.getMessage("Invalid {0}; ''{1}'' cannot contain more than {2} characters.", DataFrameAnalyticsConfig.ID, analyticsConfig.getId(), 64), (ActionRequestValidationException)error);
            }
            return error;
        }

        private ActionRequestValidationException checkNoIncludedAnalyzedFieldsAreExcludedBySourceFiltering(DataFrameAnalyticsConfig analyticsConfig, ActionRequestValidationException error) {
            if (analyticsConfig.getAnalyzedFields() == null) {
                return error;
            }
            for (String analyzedInclude : analyticsConfig.getAnalyzedFields().includes()) {
                if (!analyticsConfig.getSource().isFieldExcluded(analyzedInclude)) continue;
                return ValidateActions.addValidationError((String)("field [" + analyzedInclude + "] is included in [" + DataFrameAnalyticsConfig.ANALYZED_FIELDS.getPreferredName() + "] but not in [" + DataFrameAnalyticsConfig.SOURCE.getPreferredName() + "." + DataFrameAnalyticsSource._SOURCE.getPreferredName() + "]"), (ActionRequestValidationException)error);
            }
            return error;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.config.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.config, request.config);
        }

        public int hashCode() {
            return Objects.hash(this.config);
        }
    }
}

