/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedRunningStateAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedTimingStats;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class GetDatafeedsStatsAction
extends ActionType<Response> {
    public static final GetDatafeedsStatsAction INSTANCE = new GetDatafeedsStatsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/datafeeds/stats/get";
    public static final String ALL = "_all";
    private static final String STATE = "state";
    private static final String NODE = "node";
    private static final String ASSIGNMENT_EXPLANATION = "assignment_explanation";
    private static final String TIMING_STATS = "timing_stats";
    private static final String RUNNING_STATE = "running_state";

    private GetDatafeedsStatsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<DatafeedStats>
    implements ToXContentObject {
        public Response(QueryPage<DatafeedStats> datafeedsStats) {
            super(datafeedsStats);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public QueryPage<DatafeedStats> getResponse() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<DatafeedStats> getReader() {
            return DatafeedStats::new;
        }

        public static class Builder {
            private List<DatafeedStats.Builder> statsBuilders;
            private Map<String, String> datafeedToJobId;
            private Map<String, DatafeedTimingStats> timingStatsMap;
            private GetDatafeedRunningStateAction.Response datafeedRuntimeState;

            public Builder setDatafeedIds(Collection<String> datafeedIds) {
                this.statsBuilders = datafeedIds.stream().map(DatafeedStats::builder).collect(Collectors.toList());
                return this;
            }

            public List<String> getDatafeedIds() {
                return this.statsBuilders.stream().map(DatafeedStats.Builder::getDatafeedId).collect(Collectors.toList());
            }

            public Builder setDatafeedToJobId(Map<String, String> datafeedToJobId) {
                this.datafeedToJobId = datafeedToJobId;
                return this;
            }

            public Builder setTimingStatsMap(Map<String, DatafeedTimingStats> timingStatsMap) {
                this.timingStatsMap = timingStatsMap;
                return this;
            }

            public Builder setDatafeedRuntimeState(GetDatafeedRunningStateAction.Response datafeedRuntimeState) {
                this.datafeedRuntimeState = datafeedRuntimeState;
                return this;
            }

            public Response build(PersistentTasksCustomMetadata tasksInProgress, ClusterState state) {
                List stats = this.statsBuilders.stream().map(statsBuilder -> {
                    String jobId = this.datafeedToJobId.get(statsBuilder.datafeedId);
                    DatafeedTimingStats timingStats = jobId == null ? null : this.timingStatsMap.getOrDefault(jobId, new DatafeedTimingStats(jobId));
                    PersistentTasksCustomMetadata.PersistentTask<?> maybeTask = MlTasks.getDatafeedTask(statsBuilder.datafeedId, tasksInProgress);
                    DatafeedState datafeedState = MlTasks.getDatafeedState(statsBuilder.datafeedId, tasksInProgress);
                    return statsBuilder.setNode(maybeTask != null ? state.getNodes().get(maybeTask.getExecutorNode()) : null).setDatafeedState(datafeedState).setAssignmentExplanation(maybeTask != null ? maybeTask.getAssignment().getExplanation() : null).setTimingStats(timingStats).setRunningState(this.datafeedRuntimeState.getRunningState(statsBuilder.datafeedId).orElse(null)).build();
                }).collect(Collectors.toList());
                return new Response(new QueryPage<DatafeedStats>(stats, stats.size(), DatafeedConfig.RESULTS_FIELD));
            }
        }

        public static class DatafeedStats
        implements ToXContentObject,
        Writeable {
            private final String datafeedId;
            private final DatafeedState datafeedState;
            @Nullable
            private final DiscoveryNode node;
            @Nullable
            private final String assignmentExplanation;
            @Nullable
            private final DatafeedTimingStats timingStats;
            @Nullable
            private final GetDatafeedRunningStateAction.Response.RunningState runningState;

            public DatafeedStats(String datafeedId, DatafeedState datafeedState, @Nullable DiscoveryNode node, @Nullable String assignmentExplanation, @Nullable DatafeedTimingStats timingStats, @Nullable GetDatafeedRunningStateAction.Response.RunningState runningState) {
                this.datafeedId = Objects.requireNonNull(datafeedId);
                this.datafeedState = Objects.requireNonNull(datafeedState);
                this.node = node;
                this.assignmentExplanation = assignmentExplanation;
                this.timingStats = timingStats;
                this.runningState = runningState;
            }

            DatafeedStats(StreamInput in) throws IOException {
                this.datafeedId = in.readString();
                this.datafeedState = DatafeedState.fromStream(in);
                this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
                this.assignmentExplanation = in.readOptionalString();
                this.timingStats = (DatafeedTimingStats)in.readOptionalWriteable(DatafeedTimingStats::new);
                this.runningState = (GetDatafeedRunningStateAction.Response.RunningState)in.readOptionalWriteable(GetDatafeedRunningStateAction.Response.RunningState::new);
            }

            public String getDatafeedId() {
                return this.datafeedId;
            }

            public DatafeedState getDatafeedState() {
                return this.datafeedState;
            }

            public DiscoveryNode getNode() {
                return this.node;
            }

            public String getAssignmentExplanation() {
                return this.assignmentExplanation;
            }

            public DatafeedTimingStats getTimingStats() {
                return this.timingStats;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(DatafeedConfig.ID.getPreferredName(), this.datafeedId);
                builder.field(GetDatafeedsStatsAction.STATE, this.datafeedState.toString());
                if (this.node != null) {
                    builder.startObject(GetDatafeedsStatsAction.NODE);
                    builder.field("id", this.node.getId());
                    builder.field("name", this.node.getName());
                    builder.field("ephemeral_id", this.node.getEphemeralId());
                    builder.field("transport_address", this.node.getAddress().toString());
                    builder.startObject("attributes");
                    for (Map.Entry entry : this.node.getAttributes().entrySet()) {
                        if (!((String)entry.getKey()).startsWith("ml.")) continue;
                        builder.field((String)entry.getKey(), (String)entry.getValue());
                    }
                    builder.endObject();
                    builder.endObject();
                }
                if (this.assignmentExplanation != null) {
                    builder.field(GetDatafeedsStatsAction.ASSIGNMENT_EXPLANATION, this.assignmentExplanation);
                }
                if (this.timingStats != null) {
                    builder.field(GetDatafeedsStatsAction.TIMING_STATS, (ToXContent)this.timingStats, (ToXContent.Params)new ToXContent.MapParams(Collections.singletonMap("include_calculated_fields", "true")));
                }
                if (this.runningState != null) {
                    builder.field(GetDatafeedsStatsAction.RUNNING_STATE, (ToXContent)this.runningState);
                }
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                out.writeString(this.datafeedId);
                this.datafeedState.writeTo(out);
                out.writeOptionalWriteable((Writeable)this.node);
                out.writeOptionalString(this.assignmentExplanation);
                out.writeOptionalWriteable((Writeable)this.timingStats);
                out.writeOptionalWriteable((Writeable)this.runningState);
            }

            public int hashCode() {
                return Objects.hash(new Object[]{this.datafeedId, this.datafeedState, this.node, this.assignmentExplanation, this.timingStats, this.runningState});
            }

            public boolean equals(Object obj) {
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                DatafeedStats other = (DatafeedStats)obj;
                return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals((Object)this.datafeedState, (Object)other.datafeedState) && Objects.equals(this.node, other.node) && Objects.equals(this.assignmentExplanation, other.assignmentExplanation) && Objects.equals(this.runningState, other.runningState) && Objects.equals(this.timingStats, other.timingStats);
            }

            public static Builder builder(String datafeedId) {
                return new Builder(datafeedId);
            }

            private static class Builder {
                private final String datafeedId;
                private DatafeedState datafeedState;
                private DiscoveryNode node;
                private String assignmentExplanation;
                private DatafeedTimingStats timingStats;
                private GetDatafeedRunningStateAction.Response.RunningState runningState;

                private Builder(String datafeedId) {
                    this.datafeedId = datafeedId;
                }

                private String getDatafeedId() {
                    return this.datafeedId;
                }

                private Builder setDatafeedState(DatafeedState datafeedState) {
                    this.datafeedState = datafeedState;
                    return this;
                }

                private Builder setNode(DiscoveryNode node) {
                    this.node = node;
                    return this;
                }

                private Builder setAssignmentExplanation(String assignmentExplanation) {
                    this.assignmentExplanation = assignmentExplanation;
                    return this;
                }

                private Builder setTimingStats(DatafeedTimingStats timingStats) {
                    this.timingStats = timingStats;
                    return this;
                }

                private Builder setRunningState(GetDatafeedRunningStateAction.Response.RunningState runningState) {
                    this.runningState = runningState;
                    return this;
                }

                private DatafeedStats build() {
                    return new DatafeedStats(this.datafeedId, this.datafeedState, this.node, this.assignmentExplanation, this.timingStats, this.runningState);
                }
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        public static final String ALLOW_NO_MATCH = "allow_no_match";
        private String datafeedId;
        private boolean allowNoMatch = true;

        public Request(String datafeedId) {
            this.datafeedId = ExceptionsHelper.requireNonNull(datafeedId, DatafeedConfig.ID.getPreferredName());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedId = in.readString();
            this.allowNoMatch = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.datafeedId);
            out.writeBoolean(this.allowNoMatch);
        }

        public String getDatafeedId() {
            return this.datafeedId;
        }

        public boolean allowNoMatch() {
            return this.allowNoMatch;
        }

        public void setAllowNoMatch(boolean allowNoMatch) {
            this.allowNoMatch = allowNoMatch;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.datafeedId, this.allowNoMatch);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.datafeedId, other.datafeedId) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
        }
    }
}

