/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.allocation.TrainedModelAllocation;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class CreateTrainedModelAllocationAction
extends ActionType<Response> {
    public static final CreateTrainedModelAllocationAction INSTANCE = new CreateTrainedModelAllocationAction();
    public static final String NAME = "cluster:internal/xpack/ml/model_allocation/create";

    private CreateTrainedModelAllocationAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private static final ParseField ALLOCATION = new ParseField("allocation", new String[0]);
        private static final ConstructingObjectParser<Response, Void> PARSER = new ConstructingObjectParser("create_trained_model_allocation_response", a -> new Response((TrainedModelAllocation)a[0]));
        private final TrainedModelAllocation trainedModelAllocation;

        static Response fromXContent(XContentParser parser) {
            return (Response)((Object)PARSER.apply(parser, null));
        }

        public Response(TrainedModelAllocation trainedModelAllocation) {
            this.trainedModelAllocation = trainedModelAllocation;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.trainedModelAllocation = new TrainedModelAllocation(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.trainedModelAllocation.writeTo(out);
        }

        public TrainedModelAllocation getTrainedModelAllocation() {
            return this.trainedModelAllocation;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("allocation", (ToXContent)this.trainedModelAllocation);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.trainedModelAllocation, response.trainedModelAllocation);
        }

        public int hashCode() {
            return Objects.hash(this.trainedModelAllocation);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> TrainedModelAllocation.fromXContent(p), ALLOCATION);
        }
    }

    public static class Request
    extends MasterNodeRequest<Request> {
        private final StartTrainedModelDeploymentAction.TaskParams taskParams;

        public Request(StartTrainedModelDeploymentAction.TaskParams taskParams) {
            this.taskParams = ExceptionsHelper.requireNonNull(taskParams, "taskParams");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.taskParams = new StartTrainedModelDeploymentAction.TaskParams(in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.taskParams.writeTo(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.taskParams, request.taskParams);
        }

        public int hashCode() {
            return Objects.hash(this.taskParams);
        }

        public StartTrainedModelDeploymentAction.TaskParams getTaskParams() {
            return this.taskParams;
        }
    }
}

