/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.TimeseriesLifecycleType;

public class PutLifecycleAction
extends ActionType<AcknowledgedResponse> {
    public static final PutLifecycleAction INSTANCE = new PutLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/put";

    protected PutLifecycleAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        public static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
        private static final ConstructingObjectParser<Request, String> PARSER = new ConstructingObjectParser("put_lifecycle_request", a -> new Request((LifecyclePolicy)a[0]));
        private LifecyclePolicy policy;

        public Request(LifecyclePolicy policy) {
            this.policy = policy;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.policy = new LifecyclePolicy(in);
        }

        public Request() {
        }

        public LifecyclePolicy getPolicy() {
            return this.policy;
        }

        public ActionRequestValidationException validate() {
            this.policy.validate();
            ActionRequestValidationException err = null;
            String phaseTimingErr = TimeseriesLifecycleType.validateMonotonicallyIncreasingPhaseTimings(this.policy.getPhases().values());
            if (Strings.hasText((String)phaseTimingErr)) {
                err = new ActionRequestValidationException();
                err.addValidationError(phaseTimingErr);
            }
            return err;
        }

        public static Request parseRequest(String name, XContentParser parser) {
            return (Request)((Object)PARSER.apply(parser, (Object)name));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(POLICY_FIELD.getPreferredName(), (ToXContent)this.policy);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.policy.writeTo(out);
        }

        public int hashCode() {
            return Objects.hash(this.policy);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.policy, other.policy);
        }

        public String toString() {
            return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), LifecyclePolicy::parse, POLICY_FIELD);
        }
    }
}

