/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyMetadata;

public class WaitForSnapshotStep
extends ClusterStateWaitStep {
    static final String NAME = "wait-for-snapshot";
    private static final Logger logger = LogManager.getLogger(WaitForSnapshotStep.class);
    private static final String MESSAGE_FIELD = "message";
    private static final String POLICY_NOT_EXECUTED_MESSAGE = "waiting for policy '%s' to be executed since %s";
    private static final String POLICY_NOT_FOUND_MESSAGE = "configured policy '%s' not found";
    private static final String NO_INDEX_METADATA_MESSAGE = "no index metadata found for index '%s'";
    private static final String NO_ACTION_TIME_MESSAGE = "no information about ILM action start in index metadata for index '%s'";
    private final String policy;

    WaitForSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, String policy) {
        super(key, nextStepKey);
        this.policy = policy;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        IndexMetadata indexMetadata = clusterState.metadata().index(index);
        if (indexMetadata == null) {
            throw this.error(NO_INDEX_METADATA_MESSAGE, index.getName());
        }
        Long actionTime = indexMetadata.getLifecycleExecutionState().actionTime();
        if (actionTime == null) {
            throw this.error(NO_ACTION_TIME_MESSAGE, index.getName());
        }
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)clusterState.metadata().custom("snapshot_lifecycle");
        if (snapMeta == null || !snapMeta.getSnapshotConfigurations().containsKey(this.policy)) {
            throw this.error(POLICY_NOT_FOUND_MESSAGE, this.policy);
        }
        SnapshotLifecyclePolicyMetadata snapPolicyMeta = snapMeta.getSnapshotConfigurations().get(this.policy);
        if (snapPolicyMeta.getLastSuccess() == null || snapPolicyMeta.getLastSuccess().getSnapshotStartTimestamp() == null || snapPolicyMeta.getLastSuccess().getSnapshotStartTimestamp() < actionTime) {
            if (snapPolicyMeta.getLastSuccess() == null) {
                logger.debug("skipping ILM policy execution because there is no last snapshot success, action time: {}", (Object)actionTime);
            } else if (snapPolicyMeta.getLastSuccess().getSnapshotStartTimestamp() == null) {
                logger.debug("skipping ILM policy execution because no last snapshot start date, action time: {}", (Object)actionTime);
            } else {
                logger.debug("skipping ILM policy execution because snapshot start time {} is before action time {}, snapshot timestamp is {}", (Object)snapPolicyMeta.getLastSuccess().getSnapshotStartTimestamp(), (Object)actionTime, (Object)snapPolicyMeta.getLastSuccess().getSnapshotFinishTimestamp());
            }
            return new ClusterStateWaitStep.Result(false, this.notExecutedMessage(actionTime));
        }
        logger.debug("executing policy because snapshot start time {} is after action time {}, snapshot timestamp is {}", (Object)snapPolicyMeta.getLastSuccess().getSnapshotStartTimestamp(), (Object)actionTime, (Object)snapPolicyMeta.getLastSuccess().getSnapshotFinishTimestamp());
        return new ClusterStateWaitStep.Result(true, null);
    }

    public String getPolicy() {
        return this.policy;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    private ToXContentObject notExecutedMessage(long time) {
        return (builder, params) -> {
            builder.startObject();
            builder.field(MESSAGE_FIELD, String.format(Locale.ROOT, POLICY_NOT_EXECUTED_MESSAGE, this.policy, new Date(time)));
            builder.endObject();
            return builder;
        };
    }

    private IllegalStateException error(String message, Object ... args) {
        return new IllegalStateException(String.format(Locale.ROOT, message, args));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WaitForSnapshotStep that = (WaitForSnapshotStep)o;
        return this.policy.equals(that.policy);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policy);
    }
}

