/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.RolloverAction;
import org.elasticsearch.xpack.core.ilm.Step;

public class WaitForRolloverReadyStep
extends AsyncWaitStep {
    private static final Logger logger = LogManager.getLogger(WaitForRolloverReadyStep.class);
    public static final String NAME = "check-rollover-ready";
    private final ByteSizeValue maxSize;
    private final ByteSizeValue maxPrimaryShardSize;
    private final TimeValue maxAge;
    private final Long maxDocs;

    public WaitForRolloverReadyStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, ByteSizeValue maxSize, ByteSizeValue maxPrimaryShardSize, TimeValue maxAge, Long maxDocs) {
        super(key, nextStepKey, client);
        this.maxSize = maxSize;
        this.maxPrimaryShardSize = maxPrimaryShardSize;
        this.maxAge = maxAge;
        this.maxDocs = maxDocs;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        String rolloverTarget;
        IndexAbstraction indexAbstraction = (IndexAbstraction)metadata.getIndicesLookup().get(index.getName());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
        IndexAbstraction.DataStream dataStream = indexAbstraction.getParentDataStream();
        if (dataStream != null) {
            assert (dataStream.getWriteIndex() != null) : "datastream " + dataStream.getName() + " has no write index";
            if (!dataStream.getWriteIndex().equals((Object)index)) {
                logger.warn("index [{}] is not the write index for data stream [{}]. skipping rollover for policy [{}]", (Object)index.getName(), (Object)dataStream.getName(), LifecycleSettings.LIFECYCLE_NAME_SETTING.get(metadata.index(index).getSettings()));
                listener.onResponse(true, EmptyInfo.INSTANCE);
                return;
            }
            rolloverTarget = dataStream.getName();
        } else {
            boolean indexingComplete;
            IndexMetadata indexMetadata = metadata.index(index);
            String rolloverAlias = (String)RolloverAction.LIFECYCLE_ROLLOVER_ALIAS_SETTING.get(indexMetadata.getSettings());
            if (Strings.isNullOrEmpty((String)rolloverAlias)) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "setting [%s] for index [%s] is empty or not defined", "index.lifecycle.rollover_alias", index.getName())));
                return;
            }
            if (indexMetadata.getRolloverInfos().get((Object)rolloverAlias) != null) {
                logger.info("index [{}] was already rolled over for alias [{}], not attempting to roll over again", (Object)index.getName(), (Object)rolloverAlias);
                listener.onResponse(true, EmptyInfo.INSTANCE);
                return;
            }
            boolean aliasPointsToThisIndex = indexMetadata.getAliases().containsKey((Object)rolloverAlias);
            Boolean isWriteIndex = null;
            if (aliasPointsToThisIndex) {
                isWriteIndex = ((AliasMetadata)indexMetadata.getAliases().get((Object)rolloverAlias)).writeIndex();
            }
            if (indexingComplete = ((Boolean)LifecycleSettings.LIFECYCLE_INDEXING_COMPLETE_SETTING.get(indexMetadata.getSettings())).booleanValue()) {
                logger.trace(index + " has lifecycle complete set, skipping check-rollover-ready");
                if (aliasPointsToThisIndex && Boolean.TRUE.equals(isWriteIndex)) {
                    listener.onFailure(new IllegalStateException(String.format(Locale.ROOT, "index [%s] has [%s] set to [true], but is still the write index for alias [%s]", index.getName(), "index.lifecycle.indexing_complete", rolloverAlias)));
                    return;
                }
                listener.onResponse(true, EmptyInfo.INSTANCE);
                return;
            }
            if (!aliasPointsToThisIndex) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "%s [%s] does not point to index [%s]", "index.lifecycle.rollover_alias", rolloverAlias, index.getName())));
                return;
            }
            if (Boolean.FALSE.equals(isWriteIndex)) {
                listener.onFailure(new IllegalArgumentException(String.format(Locale.ROOT, "index [%s] is not the write index for alias [%s]", index.getName(), rolloverAlias)));
                return;
            }
            rolloverTarget = rolloverAlias;
        }
        RolloverRequest rolloverRequest = (RolloverRequest)new RolloverRequest(rolloverTarget, null).masterNodeTimeout(masterTimeout);
        rolloverRequest.dryRun(true);
        if (this.maxSize != null) {
            rolloverRequest.addMaxIndexSizeCondition(this.maxSize);
        }
        if (this.maxPrimaryShardSize != null) {
            rolloverRequest.addMaxPrimaryShardSizeCondition(this.maxPrimaryShardSize);
        }
        if (this.maxAge != null) {
            rolloverRequest.addMaxIndexAgeCondition(this.maxAge);
        }
        if (this.maxDocs != null) {
            rolloverRequest.addMaxIndexDocsCondition(this.maxDocs.longValue());
        }
        this.getClient().admin().indices().rolloverIndex(rolloverRequest, ActionListener.wrap(response -> listener.onResponse(response.getConditionStatus().values().stream().anyMatch(i -> i), EmptyInfo.INSTANCE), listener::onFailure));
    }

    ByteSizeValue getMaxSize() {
        return this.maxSize;
    }

    ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    TimeValue getMaxAge() {
        return this.maxAge;
    }

    Long getMaxDocs() {
        return this.maxDocs;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxSize, this.maxPrimaryShardSize, this.maxAge, this.maxDocs);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WaitForRolloverReadyStep other = (WaitForRolloverReadyStep)obj;
        return super.equals(obj) && Objects.equals(this.maxSize, other.maxSize) && Objects.equals(this.maxPrimaryShardSize, other.maxPrimaryShardSize) && Objects.equals(this.maxAge, other.maxAge) && Objects.equals(this.maxDocs, other.maxDocs);
    }

    private static final class EmptyInfo
    implements ToXContentObject {
        static final EmptyInfo INSTANCE = new EmptyInfo();

        private EmptyInfo() {
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder;
        }
    }
}

