/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotAction;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;

public class MountSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "mount-snapshot";
    private static final Logger logger = LogManager.getLogger(MountSnapshotStep.class);
    private final String restoredIndexPrefix;
    private final MountSearchableSnapshotRequest.Storage storageType;

    public MountSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String restoredIndexPrefix, MountSearchableSnapshotRequest.Storage storageType) {
        super(key, nextStepKey, client);
        this.restoredIndexPrefix = restoredIndexPrefix;
        this.storageType = Objects.requireNonNull(storageType, "a storage type must be specified");
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String getRestoredIndexPrefix() {
        return this.restoredIndexPrefix;
    }

    public MountSearchableSnapshotRequest.Storage getStorage() {
        return this.storageType;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, ActionListener<Void> listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
        String snapshotRepository = lifecycleState.snapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String snapshotName = lifecycleState.snapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onFailure((Exception)new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        String mountedIndexName = this.restoredIndexPrefix + indexName;
        if (currentClusterState.metadata().index(mountedIndexName) != null) {
            logger.debug("mounted index [{}] for policy [{}] and index [{}] already exists. will not attempt to mount the index again", (Object)mountedIndexName, (Object)policyName, (Object)indexName);
            listener.onResponse(null);
            return;
        }
        String snapshotIndexName = lifecycleState.snapshotIndexName();
        if (snapshotIndexName == null) {
            indexName = MountSnapshotStep.bestEffortIndexNameResolution(indexName);
            logger.debug("index [{}] using policy [{}] does not have a stored snapshot index name, using our best effort guess of [{}] for the original snapshotted index name", (Object)indexMetadata.getIndex().getName(), (Object)policyName, (Object)indexName);
        } else {
            logger.debug("index [{}] using policy [{}] has a different name [{}] within the snapshot to be restored, using the snapshot index name from generated metadata for mounting", (Object)indexName, (Object)policyName, (Object)snapshotIndexName);
            indexName = snapshotIndexName;
        }
        Settings.Builder settingsBuilder = Settings.builder();
        MountSnapshotStep.overrideTierPreference(this.getKey().getPhase()).ifPresent(override -> settingsBuilder.put("index.routing.allocation.include._tier_preference", override));
        MountSearchableSnapshotRequest mountSearchableSnapshotRequest = new MountSearchableSnapshotRequest(mountedIndexName, snapshotRepository, snapshotName, indexName, settingsBuilder.build(), new String[]{"index.lifecycle.name"}, false, this.storageType);
        mountSearchableSnapshotRequest.masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().execute((ActionType)MountSearchableSnapshotAction.INSTANCE, (ActionRequest)mountSearchableSnapshotRequest, ActionListener.wrap(response -> {
            if (response.status() != RestStatus.OK && response.status() != RestStatus.ACCEPTED) {
                logger.debug("mount snapshot response failed to complete");
                throw new ElasticsearchException("mount snapshot response failed to complete, got response " + response.status(), new Object[0]);
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    static String bestEffortIndexNameResolution(String indexName) {
        String originalName = indexName.replaceFirst("^partial-", "");
        originalName = originalName.replaceFirst("^restored-", "");
        return originalName;
    }

    static Optional<String> overrideTierPreference(String phase) {
        if ("hot".equals(phase)) {
            return Optional.of("data_hot");
        }
        return Optional.empty();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.restoredIndexPrefix, this.storageType});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MountSnapshotStep other = (MountSnapshotStep)obj;
        return super.equals(obj) && Objects.equals(this.restoredIndexPrefix, other.restoredIndexPrefix) && Objects.equals((Object)this.storageType, (Object)other.storageType);
    }
}

