/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequestBuilder;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class CleanupSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "cleanup-snapshot";

    public CleanupSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void performDuringNoSnapshot(final IndexMetadata indexMetadata, ClusterState currentClusterState, final ActionListener<Void> listener) {
        final String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        final String repositoryName = lifecycleState.snapshotRepository();
        if (!Strings.hasText((String)repositoryName)) {
            listener.onResponse(null);
            return;
        }
        final String snapshotName = lifecycleState.snapshotName();
        if (!Strings.hasText((String)snapshotName)) {
            listener.onResponse(null);
            return;
        }
        ((DeleteSnapshotRequestBuilder)this.getClient().admin().cluster().prepareDeleteSnapshot(repositoryName, new String[]{snapshotName}).setMasterNodeTimeout(TimeValue.MAX_VALUE)).execute((ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                if (!acknowledgedResponse.isAcknowledged()) {
                    String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
                    throw new ElasticsearchException("cleanup snapshot step request for repository [" + repositoryName + "] and snapshot [" + snapshotName + "] policy [" + policyName + "] and index [" + indexName + "] failed to be acknowledged", new Object[0]);
                }
                listener.onResponse(null);
            }

            public void onFailure(Exception e) {
                if (e instanceof SnapshotMissingException) {
                    listener.onResponse(null);
                } else if (e instanceof RepositoryMissingException) {
                    String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
                    listener.onFailure((Exception)new IllegalStateException("repository [" + repositoryName + "] is missing. [" + policyName + "] policy for index [" + indexName + "] cannot continue until the repository is created", e));
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }
}

