/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core;

import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.Build;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.ssl.SslClientAuthenticationMode;
import org.elasticsearch.common.ssl.SslVerificationMode;
import org.elasticsearch.jdk.JavaVersion;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public class XPackSettings {
    public static final boolean USER_PROFILE_FEATURE_FLAG_ENABLED = Build.CURRENT.isSnapshot() || "true".equals(System.getProperty("es.user_profile_feature_flag_enabled"));
    private static final boolean IS_DARWIN_AARCH64;
    public static final Setting<Boolean> CCR_ENABLED_SETTING;
    public static final Setting<Boolean> SECURITY_ENABLED;
    public static final Setting<Boolean> WATCHER_ENABLED;
    public static final Setting<Boolean> GRAPH_ENABLED;
    public static final Setting<Boolean> MACHINE_LEARNING_ENABLED;
    public static final Setting<Boolean> AUDIT_ENABLED;
    public static final Setting<Boolean> DLS_FLS_ENABLED;
    public static final Setting<Boolean> TRANSPORT_SSL_ENABLED;
    public static final Setting<Boolean> HTTP_SSL_ENABLED;
    public static final Setting<Boolean> RESERVED_REALM_ENABLED_SETTING;
    public static final Setting<Boolean> TOKEN_SERVICE_ENABLED_SETTING;
    public static final Setting<Boolean> API_KEY_SERVICE_ENABLED_SETTING;
    public static final Setting<Boolean> FIPS_MODE_ENABLED;
    public static final Setting<Boolean> ENROLLMENT_ENABLED;
    public static final Setting<Boolean> SECURITY_AUTOCONFIGURATION_ENABLED;
    private static final List<String> JDK11_CIPHERS;
    private static final List<String> JDK12_CIPHERS;
    public static final List<String> DEFAULT_CIPHERS;
    public static final Setting<String> PASSWORD_HASHING_ALGORITHM;
    public static final Setting<String> SERVICE_TOKEN_HASHING_ALGORITHM;
    public static final List<String> DEFAULT_SUPPORTED_PROTOCOLS;
    public static final SslClientAuthenticationMode CLIENT_AUTH_DEFAULT;
    public static final SslClientAuthenticationMode HTTP_CLIENT_AUTH_DEFAULT;
    public static final SslVerificationMode VERIFICATION_MODE_DEFAULT;
    public static final String HTTP_SSL_PREFIX;
    private static final SSLConfigurationSettings HTTP_SSL;
    public static final String TRANSPORT_SSL_PREFIX;
    private static final SSLConfigurationSettings TRANSPORT_SSL;

    private XPackSettings() {
        throw new IllegalStateException("Utility class should not be instantiated");
    }

    public static List<Setting<?>> getAllSettings() {
        ArrayList<Object> settings = new ArrayList<Object>();
        settings.addAll(HTTP_SSL.getEnabledSettings());
        settings.addAll(TRANSPORT_SSL.getEnabledSettings());
        settings.add(SECURITY_ENABLED);
        settings.add(GRAPH_ENABLED);
        settings.add(MACHINE_LEARNING_ENABLED);
        settings.add(AUDIT_ENABLED);
        settings.add(WATCHER_ENABLED);
        settings.add(DLS_FLS_ENABLED);
        settings.add(TRANSPORT_SSL_ENABLED);
        settings.add(HTTP_SSL_ENABLED);
        settings.add(RESERVED_REALM_ENABLED_SETTING);
        settings.add(TOKEN_SERVICE_ENABLED_SETTING);
        settings.add(API_KEY_SERVICE_ENABLED_SETTING);
        settings.add(SecurityField.USER_SETTING);
        settings.add(PASSWORD_HASHING_ALGORITHM);
        settings.add(ENROLLMENT_ENABLED);
        settings.add(SECURITY_AUTOCONFIGURATION_ENABLED);
        if (USER_PROFILE_FEATURE_FLAG_ENABLED) {
            settings.add(RealmSettings.DOMAIN_TO_REALM_ASSOC_SETTING);
        }
        return Collections.unmodifiableList(settings);
    }

    static {
        String name = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        IS_DARWIN_AARCH64 = "aarch64".equals(arch) && name.startsWith("Mac OS X");
        CCR_ENABLED_SETTING = Setting.boolSetting((String)"xpack.ccr.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SECURITY_ENABLED = Setting.boolSetting((String)"xpack.security.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        WATCHER_ENABLED = Setting.boolSetting((String)"xpack.watcher.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        GRAPH_ENABLED = Setting.boolSetting((String)"xpack.graph.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        MACHINE_LEARNING_ENABLED = Setting.boolSetting((String)"xpack.ml.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        AUDIT_ENABLED = Setting.boolSetting((String)"xpack.security.audit.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        DLS_FLS_ENABLED = Setting.boolSetting((String)"xpack.security.dls_fls.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        TRANSPORT_SSL_ENABLED = Setting.boolSetting((String)"xpack.security.transport.ssl.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        HTTP_SSL_ENABLED = Setting.boolSetting((String)"xpack.security.http.ssl.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        RESERVED_REALM_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.reserved_realm.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        TOKEN_SERVICE_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.token.enabled", HTTP_SSL_ENABLED, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        API_KEY_SERVICE_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authc.api_key.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        FIPS_MODE_ENABLED = Setting.boolSetting((String)"xpack.security.fips_mode.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        ENROLLMENT_ENABLED = Setting.boolSetting((String)"xpack.security.enrollment.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        SECURITY_AUTOCONFIGURATION_ENABLED = Setting.boolSetting((String)"xpack.security.autoconfiguration.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
        JDK11_CIPHERS = List.of("TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA");
        JDK12_CIPHERS = List.of("TLS_AES_256_GCM_SHA384", "TLS_AES_128_GCM_SHA256", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_GCM_SHA384", "TLS_RSA_WITH_AES_128_GCM_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA256", "TLS_RSA_WITH_AES_128_CBC_SHA256", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA");
        DEFAULT_CIPHERS = JavaVersion.current().compareTo(JavaVersion.parse((String)"12")) > -1 ? JDK12_CIPHERS : JDK11_CIPHERS;
        PASSWORD_HASHING_ALGORITHM = new Setting((Setting.Key)new Setting.SimpleKey("xpack.security.authc.password_hashing.algorithm"), s -> {
            if (((Boolean)FIPS_MODE_ENABLED.get(s)).booleanValue()) {
                return Hasher.PBKDF2_STRETCH.name();
            }
            return Hasher.BCRYPT.name();
        }, Function.identity(), v -> {
            if (!Hasher.getAvailableAlgoStoredHash().contains(v.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("Invalid algorithm: " + v + ". Valid values for password hashing are " + Hasher.getAvailableAlgoStoredHash().toString());
            }
            if (v.regionMatches(true, 0, "pbkdf2", 0, "pbkdf2".length())) {
                try {
                    SecretKeyFactory.getInstance("PBKDF2withHMACSHA512");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Support for PBKDF2WithHMACSHA512 must be available in order to use any of the PBKDF2 algorithms for the [xpack.security.authc.password_hashing.algorithm] setting.", e);
                }
            }
        }, new Setting.Property[]{Setting.Property.NodeScope});
        SERVICE_TOKEN_HASHING_ALGORITHM = new Setting((Setting.Key)new Setting.SimpleKey("xpack.security.authc.service_token_hashing.algorithm"), s -> "PBKDF2_STRETCH", Function.identity(), v -> {
            if (!Hasher.getAvailableAlgoStoredHash().contains(v.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("Invalid algorithm: " + v + ". Valid values for password hashing are " + Hasher.getAvailableAlgoStoredHash().toString());
            }
            if (v.regionMatches(true, 0, "pbkdf2", 0, "pbkdf2".length())) {
                try {
                    SecretKeyFactory.getInstance("PBKDF2withHMACSHA512");
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalArgumentException("Support for PBKDF2WithHMACSHA512 must be available in order to use any of the PBKDF2 algorithms for the [xpack.security.authc.service_token_hashing.algorithm] setting.", e);
                }
            }
        }, new Setting.Property[]{Setting.Property.NodeScope});
        boolean supportsTLSv13 = false;
        try {
            SSLContext.getInstance("TLSv1.3");
            supportsTLSv13 = true;
        }
        catch (NoSuchAlgorithmException e) {
            LogManager.getLogger(XPackSettings.class).debug("TLSv1.3 is not supported", (Throwable)e);
        }
        DEFAULT_SUPPORTED_PROTOCOLS = supportsTLSv13 ? Arrays.asList("TLSv1.3", "TLSv1.2", "TLSv1.1") : Arrays.asList("TLSv1.2", "TLSv1.1");
        CLIENT_AUTH_DEFAULT = SslClientAuthenticationMode.REQUIRED;
        HTTP_CLIENT_AUTH_DEFAULT = SslClientAuthenticationMode.NONE;
        VERIFICATION_MODE_DEFAULT = SslVerificationMode.FULL;
        HTTP_SSL_PREFIX = SecurityField.setting("http.ssl.");
        HTTP_SSL = SSLConfigurationSettings.withPrefix(HTTP_SSL_PREFIX, true);
        TRANSPORT_SSL_PREFIX = SecurityField.setting("transport.ssl.");
        TRANSPORT_SSL = SSLConfigurationSettings.withPrefix(TRANSPORT_SSL_PREFIX, true);
    }
}

