/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.cluster.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MigrateToDataTiersResponse
extends ActionResponse
implements ToXContentObject {
    public static final ParseField REMOVED_LEGACY_TEMPLATE = new ParseField("removed_legacy_template", new String[0]);
    public static final ParseField MIGRATED_INDICES = new ParseField("migrated_indices", new String[0]);
    public static final ParseField MIGRATED_ILM_POLICIES = new ParseField("migrated_ilm_policies", new String[0]);
    public static final ParseField MIGRATED_LEGACY_TEMPLATES = new ParseField("migrated_legacy_templates", new String[0]);
    public static final ParseField MIGRATED_COMPOSABLE_TEMPLATES = new ParseField("migrated_composable_templates", new String[0]);
    public static final ParseField MIGRATED_COMPONENT_TEMPLATES = new ParseField("migrated_component_templates", new String[0]);
    public static final ParseField DRY_RUN = new ParseField("dry_run", new String[0]);
    @Nullable
    private final String removedIndexTemplateName;
    private final List<String> migratedPolicies;
    private final List<String> migratedIndices;
    private final boolean dryRun;
    private final List<String> migratedLegacyTemplates;
    private final List<String> migratedComposableTemplates;
    private final List<String> migratedComponentTemplates;

    public MigrateToDataTiersResponse(@Nullable String removedIndexTemplateName, List<String> migratedPolicies, List<String> migratedIndices, List<String> migratedLegacyTemplates, List<String> migratedComposableTemplates, List<String> migratedComponentTemplates, boolean dryRun) {
        this.removedIndexTemplateName = removedIndexTemplateName;
        this.migratedPolicies = migratedPolicies;
        this.migratedIndices = migratedIndices;
        this.migratedLegacyTemplates = migratedLegacyTemplates;
        this.migratedComposableTemplates = migratedComposableTemplates;
        this.migratedComponentTemplates = migratedComponentTemplates;
        this.dryRun = dryRun;
    }

    public MigrateToDataTiersResponse(StreamInput in) throws IOException {
        super(in);
        this.removedIndexTemplateName = in.readOptionalString();
        this.migratedPolicies = in.readStringList();
        this.migratedIndices = in.readStringList();
        this.dryRun = in.readBoolean();
        if (in.getVersion().onOrAfter(Version.V_7_17_0)) {
            this.migratedLegacyTemplates = in.readStringList();
            this.migratedComposableTemplates = in.readStringList();
            this.migratedComponentTemplates = in.readStringList();
        } else {
            this.migratedLegacyTemplates = List.of();
            this.migratedComposableTemplates = List.of();
            this.migratedComponentTemplates = List.of();
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DRY_RUN.getPreferredName(), this.dryRun);
        if (this.removedIndexTemplateName != null) {
            builder.field(REMOVED_LEGACY_TEMPLATE.getPreferredName(), this.removedIndexTemplateName);
        }
        if (this.migratedPolicies.size() > 0) {
            builder.startArray(MIGRATED_ILM_POLICIES.getPreferredName());
            for (String policy : this.migratedPolicies) {
                builder.value(policy);
            }
            builder.endArray();
        }
        if (this.migratedIndices.size() > 0) {
            builder.startArray(MIGRATED_INDICES.getPreferredName());
            for (String index : this.migratedIndices) {
                builder.value(index);
            }
            builder.endArray();
        }
        if (this.migratedLegacyTemplates.size() > 0) {
            builder.startArray(MIGRATED_LEGACY_TEMPLATES.getPreferredName());
            for (String legacyTemplate : this.migratedLegacyTemplates) {
                builder.value(legacyTemplate);
            }
            builder.endArray();
        }
        if (this.migratedComposableTemplates.size() > 0) {
            builder.startArray(MIGRATED_COMPOSABLE_TEMPLATES.getPreferredName());
            for (String composableTemplate : this.migratedComposableTemplates) {
                builder.value(composableTemplate);
            }
            builder.endArray();
        }
        if (this.migratedComponentTemplates.size() > 0) {
            builder.startArray(MIGRATED_COMPONENT_TEMPLATES.getPreferredName());
            for (String componentTemplate : this.migratedComponentTemplates) {
                builder.value(componentTemplate);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    public String getRemovedIndexTemplateName() {
        return this.removedIndexTemplateName;
    }

    public List<String> getMigratedPolicies() {
        return this.migratedPolicies;
    }

    public List<String> getMigratedIndices() {
        return this.migratedIndices;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<String> getMigratedLegacyTemplates() {
        return this.migratedLegacyTemplates;
    }

    public List<String> getMigratedComposableTemplates() {
        return this.migratedComposableTemplates;
    }

    public List<String> getMigratedComponentTemplates() {
        return this.migratedComponentTemplates;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.removedIndexTemplateName);
        out.writeStringCollection(this.migratedPolicies);
        out.writeStringCollection(this.migratedIndices);
        out.writeBoolean(this.dryRun);
        if (out.getVersion().onOrAfter(Version.V_7_17_0)) {
            out.writeStringCollection(this.migratedLegacyTemplates);
            out.writeStringCollection(this.migratedComposableTemplates);
            out.writeStringCollection(this.migratedComponentTemplates);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MigrateToDataTiersResponse that = (MigrateToDataTiersResponse)((Object)o);
        return this.dryRun == that.dryRun && Objects.equals(this.removedIndexTemplateName, that.removedIndexTemplateName) && Objects.equals(this.migratedPolicies, that.migratedPolicies) && Objects.equals(this.migratedIndices, that.migratedIndices) && Objects.equals(this.migratedLegacyTemplates, that.migratedLegacyTemplates) && Objects.equals(this.migratedComposableTemplates, that.migratedComposableTemplates) && Objects.equals(this.migratedComponentTemplates, that.migratedComponentTemplates);
    }

    public int hashCode() {
        return Objects.hash(this.removedIndexTemplateName, this.migratedPolicies, this.migratedIndices, this.dryRun, this.migratedLegacyTemplates, this.migratedComposableTemplates, this.migratedComponentTemplates);
    }
}

