/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.time.Clock;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.license.PostStartBasicRequest;
import org.elasticsearch.license.PostStartBasicResponse;
import org.elasticsearch.license.SelfGeneratedLicense;
import org.elasticsearch.xpack.core.XPackPlugin;

public class StartBasicClusterTask
extends ClusterStateUpdateTask {
    private static final String ACKNOWLEDGEMENT_HEADER = "This license update requires acknowledgement. To acknowledge the license, please read the following messages and call /start_basic again, this time with the \"acknowledge=true\" parameter:";
    private final Logger logger;
    private final String clusterName;
    private final PostStartBasicRequest request;
    private final String description;
    private final ActionListener<PostStartBasicResponse> listener;
    private final Clock clock;
    private AtomicReference<Map<String, String[]>> ackMessages = new AtomicReference(Collections.emptyMap());

    StartBasicClusterTask(Logger logger, String clusterName, Clock clock, PostStartBasicRequest request, String description, ActionListener<PostStartBasicResponse> listener) {
        this.logger = logger;
        this.clusterName = clusterName;
        this.request = request;
        this.description = description;
        this.listener = listener;
        this.clock = clock;
    }

    public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
        LicensesMetadata oldLicensesMetadata = (LicensesMetadata)oldState.metadata().custom("licenses");
        this.logger.debug("license prior to starting basic license: {}", (Object)oldLicensesMetadata);
        License oldLicense = LicensesMetadata.extractLicense(oldLicensesMetadata);
        Map<String, String[]> acknowledgeMessages = this.ackMessages.get();
        if (!acknowledgeMessages.isEmpty()) {
            this.listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.NEED_ACKNOWLEDGEMENT, acknowledgeMessages, ACKNOWLEDGEMENT_HEADER));
        } else if (oldLicense != null && License.LicenseType.isBasic(oldLicense.type())) {
            this.listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.ALREADY_USING_BASIC));
        } else {
            this.listener.onResponse((Object)new PostStartBasicResponse(PostStartBasicResponse.Status.GENERATED_BASIC));
        }
    }

    public ClusterState execute(ClusterState currentState) throws Exception {
        XPackPlugin.checkReadyForXPackCustomMetadata(currentState);
        LicensesMetadata currentLicensesMetadata = (LicensesMetadata)currentState.metadata().custom("licenses");
        License currentLicense = LicensesMetadata.extractLicense(currentLicensesMetadata);
        if (this.shouldGenerateNewBasicLicense(currentLicense)) {
            Map<String, String[]> ackMessageMap;
            License selfGeneratedLicense = this.generateBasicLicense(currentState);
            if (!this.request.isAcknowledged() && currentLicense != null && !(ackMessageMap = LicenseService.getAckMessages(selfGeneratedLicense, currentLicense)).isEmpty()) {
                this.ackMessages.set(ackMessageMap);
                return currentState;
            }
            Version trialVersion = currentLicensesMetadata != null ? currentLicensesMetadata.getMostRecentTrialVersion() : null;
            LicensesMetadata newLicensesMetadata = new LicensesMetadata(selfGeneratedLicense, trialVersion);
            Metadata.Builder mdBuilder = Metadata.builder((Metadata)currentState.metadata());
            mdBuilder.putCustom("licenses", (Metadata.Custom)newLicensesMetadata);
            return ClusterState.builder((ClusterState)currentState).metadata(mdBuilder).build();
        }
        return currentState;
    }

    public void onFailure(@Nullable Exception e) {
        this.logger.error((Message)new ParameterizedMessage("unexpected failure during [{}]", (Object)this.description), (Throwable)e);
        this.listener.onFailure(e);
    }

    private boolean shouldGenerateNewBasicLicense(License currentLicense) {
        return currentLicense == null || !License.LicenseType.isBasic(currentLicense.type()) || 1000 != currentLicense.maxNodes() || LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS != currentLicense.expiryDate();
    }

    private License generateBasicLicense(ClusterState currentState) {
        License.Builder specBuilder = License.builder().uid(UUID.randomUUID().toString()).issuedTo(this.clusterName).maxNodes(1000).issueDate(this.clock.millis()).type(License.LicenseType.BASIC).expiryDate(LicenseService.BASIC_SELF_GENERATED_LICENSE_EXPIRATION_MILLIS);
        return SelfGeneratedLicense.create(specBuilder, currentState.nodes());
    }

    public String getDescription() {
        return this.description;
    }
}

