/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.protocol.xpack.license.GetLicenseRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class RestGetLicenseAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestGetLicenseAction.class);

    RestGetLicenseAction() {
    }

    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_license").replaces(RestRequest.Method.GET, "/_xpack/license", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "get_license";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Map overrideParams = Maps.newMapWithExpectedSize((int)2);
        overrideParams.put("rest_view", "true");
        overrideParams.put("license_version", String.valueOf(5));
        if (request.getRestApiVersion() == RestApiVersion.V_7) {
            boolean hideEnterprise = !request.paramAsBoolean("accept_enterprise", false);
            int licenseVersion = hideEnterprise ? 4 : 5;
            overrideParams.put("license_version", String.valueOf(licenseVersion));
            overrideParams.put("hide_enterprise", String.valueOf(hideEnterprise));
        }
        if (request.hasParam("accept_enterprise")) {
            deprecationLogger.warn(DeprecationCategory.API, "get_license_accept_enterprise", "Including [accept_enterprise] in get license requests is deprecated. The parameter will be removed in the next major version", new Object[0]);
            if (!request.paramAsBoolean("accept_enterprise", true) && request.getRestApiVersion().matches(RestApiVersion.onOrAfter((RestApiVersion)RestApiVersion.V_8))) {
                throw new IllegalArgumentException("The [accept_enterprise] parameters may not be false");
            }
        }
        ToXContent.DelegatingMapParams params = new ToXContent.DelegatingMapParams(overrideParams, (ToXContent.Params)request);
        GetLicenseRequest getLicenseRequest = new GetLicenseRequest();
        getLicenseRequest.local(request.paramAsBoolean("local", getLicenseRequest.local()));
        return arg_0 -> this.lambda$prepareRequest$0(client, getLicenseRequest, request, (ToXContent.Params)params, arg_0);
    }

    private /* synthetic */ void lambda$prepareRequest$0(NodeClient client, GetLicenseRequest getLicenseRequest, final RestRequest request, final ToXContent.Params params, RestChannel channel) throws Exception {
        client.admin().cluster().execute((ActionType)GetLicenseAction.INSTANCE, (ActionRequest)getLicenseRequest, (ActionListener)new RestBuilderListener<GetLicenseResponse>(channel){

            public RestResponse buildResponse(GetLicenseResponse response, XContentBuilder builder) throws Exception {
                if (!request.hasParam("pretty")) {
                    builder.prettyPrint().lfAtEnd();
                }
                boolean hasLicense = response.license() != null;
                builder.startObject();
                if (hasLicense) {
                    builder.startObject("license");
                    response.license().toInnerXContent(builder, params);
                    builder.endObject();
                }
                builder.endObject();
                return new BytesRestResponse(hasLicense ? RestStatus.OK : RestStatus.NOT_FOUND, builder);
            }
        });
    }
}

