/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.script.field.DocValuesField;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongField;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongFieldMapper;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongScriptDocValues;

public class UnsignedLongDocValuesField
implements UnsignedLongField,
DocValuesField {
    private final SortedNumericDocValues input;
    private final String name;
    private long[] values = new long[0];
    private int count = 0;
    private UnsignedLongScriptDocValues unsignedLongScriptDocValues = null;

    public UnsignedLongDocValuesField(SortedNumericDocValues input, String name) {
        this.input = input;
        this.name = name;
    }

    public void setNextDocId(int docId) throws IOException {
        if (this.input.advanceExact(docId)) {
            this.resize(this.input.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.input.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    public ScriptDocValues<?> getScriptDocValues() {
        if (this.unsignedLongScriptDocValues == null) {
            this.unsignedLongScriptDocValues = new UnsignedLongScriptDocValues(this);
        }
        return this.unsignedLongScriptDocValues;
    }

    protected void resize(int newSize) {
        this.count = newSize;
        this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int size() {
        return this.count;
    }

    protected long toFormatted(int index) {
        return this.values[index] ^ Long.MIN_VALUE;
    }

    @Override
    public List<Long> getValues() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Long> longValues = new ArrayList<Long>(this.count);
        for (int index = 0; index < this.count; ++index) {
            longValues.add(this.toFormatted(index));
        }
        return longValues;
    }

    @Override
    public long getValue(long defaultValue) {
        return this.getValue(0, defaultValue);
    }

    @Override
    public long getValue(int index, long defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.toFormatted(index);
    }

    protected BigInteger toBigInteger(int index) {
        return BigInteger.valueOf(this.toFormatted(index)).and(UnsignedLongFieldMapper.BIGINTEGER_2_64_MINUS_ONE);
    }

    @Override
    public List<BigInteger> asBigIntegers() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BigInteger> bigIntegerValues = new ArrayList<BigInteger>(this.count);
        for (int index = 0; index < this.count; ++index) {
            bigIntegerValues.add(this.toBigInteger(index));
        }
        return bigIntegerValues;
    }

    @Override
    public BigInteger asBigInteger(BigInteger defaultValue) {
        return this.asBigInteger(0, defaultValue);
    }

    @Override
    public BigInteger asBigInteger(int index, BigInteger defaultValue) {
        if (this.isEmpty() || index < 0 || index >= this.count) {
            return defaultValue;
        }
        return this.toBigInteger(index);
    }
}

