/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.reindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.index.reindex.ReindexAction;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.RemoteInfo;
import org.elasticsearch.index.reindex.ScrollableHitSource;
import org.elasticsearch.index.reindex.WorkerBulkByScrollTaskState;
import org.elasticsearch.reindex.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.reindex.BulkByScrollParallelizationHelper;
import org.elasticsearch.reindex.ReindexSslConfig;
import org.elasticsearch.reindex.TransportReindexAction;
import org.elasticsearch.reindex.remote.RemoteScrollableHitSource;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;

public class Reindexer {
    private static final Logger logger = LogManager.getLogger(Reindexer.class);
    private final ClusterService clusterService;
    private final Client client;
    private final ThreadPool threadPool;
    private final ScriptService scriptService;
    private final ReindexSslConfig reindexSslConfig;

    Reindexer(ClusterService clusterService, Client client, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig reindexSslConfig) {
        this.clusterService = clusterService;
        this.client = client;
        this.threadPool = threadPool;
        this.scriptService = scriptService;
        this.reindexSslConfig = reindexSslConfig;
    }

    public void initTask(BulkByScrollTask task, ReindexRequest request, ActionListener<Void> listener) {
        BulkByScrollParallelizationHelper.initTaskState(task, request, this.client, listener);
    }

    public void execute(BulkByScrollTask task, ReindexRequest request, Client bulkClient, ActionListener<BulkByScrollResponse> listener) {
        BulkByScrollParallelizationHelper.executeSlicedAction(task, request, (ActionType<BulkByScrollResponse>)ReindexAction.INSTANCE, listener, this.client, this.clusterService.localNode(), () -> {
            ParentTaskAssigningClient assigningClient = new ParentTaskAssigningClient(this.client, this.clusterService.localNode(), (Task)task);
            ParentTaskAssigningClient assigningBulkClient = new ParentTaskAssigningClient(bulkClient, this.clusterService.localNode(), (Task)task);
            AsyncIndexBySearchAction searchAction = new AsyncIndexBySearchAction(task, logger, assigningClient, assigningBulkClient, this.threadPool, this.scriptService, this.reindexSslConfig, request, listener);
            searchAction.start();
        });
    }

    static RestClient buildRestClient(RemoteInfo remoteInfo, ReindexSslConfig sslConfig, long taskId, List<Thread> threadCollector) {
        Header[] clientHeaders = new Header[remoteInfo.getHeaders().size()];
        int i = 0;
        for (Map.Entry header : remoteInfo.getHeaders().entrySet()) {
            clientHeaders[i++] = new BasicHeader((String)header.getKey(), (String)header.getValue());
        }
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(remoteInfo.getHost(), remoteInfo.getPort(), remoteInfo.getScheme())}).setDefaultHeaders(clientHeaders).setRequestConfigCallback(c -> {
            c.setConnectTimeout(Math.toIntExact(remoteInfo.getConnectTimeout().millis()));
            c.setSocketTimeout(Math.toIntExact(remoteInfo.getSocketTimeout().millis()));
            return c;
        }).setHttpClientConfigCallback(c -> {
            if (remoteInfo.getUsername() != null) {
                UsernamePasswordCredentials creds = new UsernamePasswordCredentials(remoteInfo.getUsername(), remoteInfo.getPassword());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)creds);
                c.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            AtomicInteger threads = new AtomicInteger();
            c.setThreadFactory(r -> {
                String name = "es-client-" + taskId + "-" + threads.getAndIncrement();
                Thread t = new Thread(r, name);
                threadCollector.add(t);
                return t;
            });
            c.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(1).build());
            c.setSSLStrategy((SchemeIOSessionStrategy)sslConfig.getStrategy());
            return c;
        });
        if (Strings.hasLength((String)remoteInfo.getPathPrefix()) && !"/".equals(remoteInfo.getPathPrefix())) {
            builder.setPathPrefix(remoteInfo.getPathPrefix());
        }
        return builder.build();
    }

    static class AsyncIndexBySearchAction
    extends AbstractAsyncBulkByScrollAction<ReindexRequest, TransportReindexAction> {
        private List<Thread> createdThreads = Collections.emptyList();

        AsyncIndexBySearchAction(BulkByScrollTask task, Logger logger, ParentTaskAssigningClient searchClient, ParentTaskAssigningClient bulkClient, ThreadPool threadPool, ScriptService scriptService, ReindexSslConfig sslConfig, ReindexRequest request, ActionListener<BulkByScrollResponse> listener) {
            super(task, request.getDestination().versionType() != VersionType.INTERNAL, false, logger, searchClient, bulkClient, threadPool, request, listener, scriptService, sslConfig);
        }

        @Override
        protected ScrollableHitSource buildScrollableResultSource(BackoffPolicy backoffPolicy, SearchRequest searchRequest) {
            if (((ReindexRequest)this.mainRequest).getRemoteInfo() != null) {
                RemoteInfo remoteInfo = ((ReindexRequest)this.mainRequest).getRemoteInfo();
                this.createdThreads = Collections.synchronizedList(new ArrayList());
                assert (this.sslConfig != null) : "Reindex ssl config must be set";
                RestClient restClient = Reindexer.buildRestClient(remoteInfo, this.sslConfig, this.task.getId(), this.createdThreads);
                return new RemoteScrollableHitSource(this.logger, backoffPolicy, this.threadPool, () -> ((WorkerBulkByScrollTaskState)this.worker).countSearchRetry(), this::onScrollResponse, this::finishHim, restClient, remoteInfo.getQuery(), searchRequest);
            }
            return super.buildScrollableResultSource(backoffPolicy, searchRequest);
        }

        @Override
        protected void finishHim(Exception failure, List<BulkItemResponse.Failure> indexingFailures, List<ScrollableHitSource.SearchFailure> searchFailures, boolean timedOut) {
            super.finishHim(failure, indexingFailures, searchFailures, timedOut);
            for (Thread thread : this.createdThreads) {
                if (!thread.isAlive()) continue;
                assert (false) : "Failed to properly stop client thread [" + thread.getName() + "]";
                this.logger.error("Failed to properly stop client thread [{}]", (Object)thread.getName());
            }
        }

        @Override
        public BiFunction<AbstractAsyncBulkByScrollAction.RequestWrapper<?>, ScrollableHitSource.Hit, AbstractAsyncBulkByScrollAction.RequestWrapper<?>> buildScriptApplier() {
            Script script = ((ReindexRequest)this.mainRequest).getScript();
            if (script != null) {
                assert (this.scriptService != null) : "Script service must be set";
                return new ReindexScriptApplier(this.worker, this.scriptService, script, script.getParams());
            }
            return super.buildScriptApplier();
        }

        @Override
        protected AbstractAsyncBulkByScrollAction.RequestWrapper<IndexRequest> buildRequest(ScrollableHitSource.Hit doc) {
            IndexRequest index;
            block25: {
                index = new IndexRequest();
                index.index(((ReindexRequest)this.mainRequest).getDestination().index());
                index.versionType(((ReindexRequest)this.mainRequest).getDestination().versionType());
                if (index.versionType() == VersionType.INTERNAL) {
                    assert (doc.getVersion() == -1L) : "fetched version when we didn't have to";
                    index.version(((ReindexRequest)this.mainRequest).getDestination().version());
                } else {
                    index.version(doc.getVersion());
                }
                index.id(doc.getId());
                XContentType sourceXContentType = doc.getXContentType();
                XContentType mainRequestXContentType = ((ReindexRequest)this.mainRequest).getDestination().getContentType();
                if (mainRequestXContentType != null && doc.getXContentType() != mainRequestXContentType) {
                    try (StreamInput stream = doc.getSource().streamInput();
                         XContentParser parser = sourceXContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)stream);
                         XContentBuilder builder = XContentBuilder.builder((XContent)mainRequestXContentType.xContent());){
                        parser.nextToken();
                        builder.copyCurrentStructure(parser);
                        index.source(BytesReference.bytes((XContentBuilder)builder), builder.contentType());
                        break block25;
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException("failed to convert hit from " + sourceXContentType + " to " + mainRequestXContentType, e);
                    }
                }
                index.source(doc.getSource(), doc.getXContentType());
            }
            index.routing(((ReindexRequest)this.mainRequest).getDestination().routing());
            index.setPipeline(((ReindexRequest)this.mainRequest).getDestination().getPipeline());
            if (((ReindexRequest)this.mainRequest).getDestination().opType() == DocWriteRequest.OpType.CREATE) {
                index.opType(((ReindexRequest)this.mainRequest).getDestination().opType());
            }
            return AsyncIndexBySearchAction.wrap(index);
        }

        @Override
        protected void copyRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, String routing) {
            String routingSpec = ((ReindexRequest)this.mainRequest).getDestination().routing();
            if (routingSpec == null) {
                super.copyRouting(request, routing);
                return;
            }
            if (routingSpec.startsWith("=")) {
                super.copyRouting(request, ((ReindexRequest)this.mainRequest).getDestination().routing().substring(1));
                return;
            }
            switch (routingSpec) {
                case "keep": {
                    super.copyRouting(request, routing);
                    break;
                }
                case "discard": {
                    super.copyRouting(request, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported routing command");
                }
            }
        }

        class ReindexScriptApplier
        extends AbstractAsyncBulkByScrollAction.ScriptApplier {
            ReindexScriptApplier(WorkerBulkByScrollTaskState taskWorker, ScriptService scriptService, Script script, Map<String, Object> params) {
                super(taskWorker, scriptService, script, params);
            }

            @Override
            protected void scriptChangedIndex(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                Objects.requireNonNull(to, "Can't reindex without a destination index!");
                request.setIndex(to.toString());
            }

            @Override
            protected void scriptChangedId(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setId(Objects.toString(to, null));
            }

            @Override
            protected void scriptChangedVersion(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                if (to == null) {
                    request.setVersion(-3L);
                    request.setVersionType(VersionType.INTERNAL);
                } else {
                    request.setVersion(this.asLong(to, "_version"));
                }
            }

            @Override
            protected void scriptChangedRouting(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, Object to) {
                request.setRouting(Objects.toString(to, null));
            }

            private long asLong(Object from, String name) {
                Number fromNumber;
                try {
                    fromNumber = (Number)from;
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]", e);
                }
                long l = fromNumber.longValue();
                if (fromNumber.doubleValue() != (double)l) {
                    throw new IllegalArgumentException(name + " may only be set to an int or a long but was [" + from + "]");
                }
                return l;
            }
        }
    }
}

