/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.core.transform.TransformField;

public class SettingsConfig
implements Writeable,
ToXContentObject {
    public static final ConstructingObjectParser<SettingsConfig, Void> STRICT_PARSER = SettingsConfig.createParser(false);
    public static final ConstructingObjectParser<SettingsConfig, Void> LENIENT_PARSER = SettingsConfig.createParser(true);
    private static final int DEFAULT_MAX_PAGE_SEARCH_SIZE = -1;
    private static final float DEFAULT_DOCS_PER_SECOND = -1.0f;
    private static final int DEFAULT_DATES_AS_EPOCH_MILLIS = -1;
    private static final int DEFAULT_ALIGN_CHECKPOINTS = -1;
    private static final int DEFAULT_USE_PIT = -1;
    private final Integer maxPageSearchSize;
    private final Float docsPerSecond;
    private final Integer datesAsEpochMillis;
    private final Integer alignCheckpoints;
    private final Integer usePit;

    private static ConstructingObjectParser<SettingsConfig, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser("transform_config_settings", lenient, args -> new SettingsConfig((Integer)args[0], (Float)args[1], (Integer)args[2], (Integer)args[3], (Integer)args[4]));
        parser.declareIntOrNull(ConstructingObjectParser.optionalConstructorArg(), -1, TransformField.MAX_PAGE_SEARCH_SIZE);
        parser.declareFloatOrNull(ConstructingObjectParser.optionalConstructorArg(), -1.0f, TransformField.DOCS_PER_SECOND);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), TransformField.DATES_AS_EPOCH_MILLIS, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), TransformField.ALIGN_CHECKPOINTS, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        parser.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> p.currentToken() == XContentParser.Token.VALUE_NULL ? -1 : (p.booleanValue() ? 1 : 0), TransformField.USE_PIT, ObjectParser.ValueType.BOOLEAN_OR_NULL);
        return parser;
    }

    public SettingsConfig() {
        this(null, null, (Integer)null, (Integer)null, (Integer)null);
    }

    public SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond, Boolean datesAsEpochMillis, Boolean alignCheckpoints, Boolean usePit) {
        this(maxPageSearchSize, docsPerSecond, datesAsEpochMillis == null ? null : Integer.valueOf(datesAsEpochMillis != false ? 1 : 0), alignCheckpoints == null ? null : Integer.valueOf(alignCheckpoints != false ? 1 : 0), usePit == null ? null : Integer.valueOf(usePit != false ? 1 : 0));
    }

    public SettingsConfig(Integer maxPageSearchSize, Float docsPerSecond, Integer datesAsEpochMillis, Integer alignCheckpoints, Integer usePit) {
        this.maxPageSearchSize = maxPageSearchSize;
        this.docsPerSecond = docsPerSecond;
        this.datesAsEpochMillis = datesAsEpochMillis;
        this.alignCheckpoints = alignCheckpoints;
        this.usePit = usePit;
    }

    public SettingsConfig(StreamInput in) throws IOException {
        this.maxPageSearchSize = in.readOptionalInt();
        this.docsPerSecond = in.readOptionalFloat();
        this.datesAsEpochMillis = in.getVersion().onOrAfter(Version.V_7_11_0) ? in.readOptionalInt() : Integer.valueOf(-1);
        this.alignCheckpoints = in.getVersion().onOrAfter(Version.V_7_15_0) ? in.readOptionalInt() : Integer.valueOf(-1);
        this.usePit = in.getVersion().onOrAfter(Version.V_7_16_1) ? in.readOptionalInt() : Integer.valueOf(-1);
    }

    public Integer getMaxPageSearchSize() {
        return this.maxPageSearchSize;
    }

    public Float getDocsPerSecond() {
        return this.docsPerSecond;
    }

    public Boolean getDatesAsEpochMillis() {
        return this.datesAsEpochMillis != null ? Boolean.valueOf(this.datesAsEpochMillis > 0) : null;
    }

    public Integer getDatesAsEpochMillisForUpdate() {
        return this.datesAsEpochMillis;
    }

    public Boolean getAlignCheckpoints() {
        return this.alignCheckpoints != null ? Boolean.valueOf(this.alignCheckpoints > 0 || this.alignCheckpoints == -1) : null;
    }

    public Integer getAlignCheckpointsForUpdate() {
        return this.alignCheckpoints;
    }

    public Boolean getUsePit() {
        return this.usePit != null ? Boolean.valueOf(this.usePit > 0 || this.usePit == -1) : null;
    }

    public Integer getUsePitForUpdate() {
        return this.usePit;
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.maxPageSearchSize != null && (this.maxPageSearchSize < 10 || this.maxPageSearchSize > 65536)) {
            validationException = ValidateActions.addValidationError((String)("settings.max_page_search_size [" + this.maxPageSearchSize + "] is out of range. The minimum value is 10 and the maximum is 65536"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void checkForDeprecations(String id, NamedXContentRegistry namedXContentRegistry, Consumer<DeprecationIssue> onDeprecation) {
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalInt(this.maxPageSearchSize);
        out.writeOptionalFloat(this.docsPerSecond);
        if (out.getVersion().onOrAfter(Version.V_7_11_0)) {
            out.writeOptionalInt(this.datesAsEpochMillis);
        }
        if (out.getVersion().onOrAfter(Version.V_7_15_0)) {
            out.writeOptionalInt(this.alignCheckpoints);
        }
        if (out.getVersion().onOrAfter(Version.V_7_16_1)) {
            out.writeOptionalInt(this.usePit);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.maxPageSearchSize != null && !this.maxPageSearchSize.equals(-1)) {
            builder.field(TransformField.MAX_PAGE_SEARCH_SIZE.getPreferredName(), this.maxPageSearchSize);
        }
        if (this.docsPerSecond != null && !this.docsPerSecond.equals(Float.valueOf(-1.0f))) {
            builder.field(TransformField.DOCS_PER_SECOND.getPreferredName(), this.docsPerSecond);
        }
        if (this.datesAsEpochMillis != null && !this.datesAsEpochMillis.equals(-1)) {
            builder.field(TransformField.DATES_AS_EPOCH_MILLIS.getPreferredName(), this.datesAsEpochMillis > 0);
        }
        if (this.alignCheckpoints != null && !this.alignCheckpoints.equals(-1)) {
            builder.field(TransformField.ALIGN_CHECKPOINTS.getPreferredName(), this.alignCheckpoints > 0);
        }
        if (this.usePit != null && !this.usePit.equals(-1)) {
            builder.field(TransformField.USE_PIT.getPreferredName(), this.usePit > 0);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SettingsConfig that = (SettingsConfig)other;
        return Objects.equals(this.maxPageSearchSize, that.maxPageSearchSize) && Objects.equals(this.docsPerSecond, that.docsPerSecond) && Objects.equals(this.datesAsEpochMillis, that.datesAsEpochMillis) && Objects.equals(this.alignCheckpoints, that.alignCheckpoints) && Objects.equals(this.usePit, that.usePit);
    }

    public int hashCode() {
        return Objects.hash(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis, this.alignCheckpoints, this.usePit);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static SettingsConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        return lenient ? (SettingsConfig)LENIENT_PARSER.apply(parser, null) : (SettingsConfig)STRICT_PARSER.apply(parser, null);
    }

    public static class Builder {
        private Integer maxPageSearchSize;
        private Float docsPerSecond;
        private Integer datesAsEpochMillis;
        private Integer alignCheckpoints;
        private Integer usePit;

        public Builder() {
        }

        public Builder(SettingsConfig base) {
            this.maxPageSearchSize = base.maxPageSearchSize;
            this.docsPerSecond = base.docsPerSecond;
            this.datesAsEpochMillis = base.datesAsEpochMillis;
            this.alignCheckpoints = base.alignCheckpoints;
            this.usePit = base.usePit;
        }

        public Builder setMaxPageSearchSize(Integer maxPageSearchSize) {
            this.maxPageSearchSize = maxPageSearchSize == null ? -1 : maxPageSearchSize;
            return this;
        }

        public Builder setRequestsPerSecond(Float documentsPerSecond) {
            this.docsPerSecond = Float.valueOf(documentsPerSecond == null ? -1.0f : documentsPerSecond.floatValue());
            return this;
        }

        public Builder setDatesAsEpochMillis(Boolean datesAsEpochMillis) {
            this.datesAsEpochMillis = datesAsEpochMillis == null ? -1 : (datesAsEpochMillis != false ? 1 : 0);
            return this;
        }

        public Builder setAlignCheckpoints(Boolean alignCheckpoints) {
            this.alignCheckpoints = alignCheckpoints == null ? -1 : (alignCheckpoints != false ? 1 : 0);
            return this;
        }

        public Builder setUsePit(Boolean usePit) {
            this.usePit = usePit == null ? -1 : (usePit != false ? 1 : 0);
            return this;
        }

        public Builder update(SettingsConfig update) {
            if (update.getDocsPerSecond() != null) {
                Float f = this.docsPerSecond = update.getDocsPerSecond().equals(Float.valueOf(-1.0f)) ? null : update.getDocsPerSecond();
            }
            if (update.getMaxPageSearchSize() != null) {
                Integer n = this.maxPageSearchSize = update.getMaxPageSearchSize().equals(-1) ? null : update.getMaxPageSearchSize();
            }
            if (update.getDatesAsEpochMillisForUpdate() != null) {
                Integer n = this.datesAsEpochMillis = update.getDatesAsEpochMillisForUpdate().equals(-1) ? null : update.getDatesAsEpochMillisForUpdate();
            }
            if (update.getAlignCheckpointsForUpdate() != null) {
                Integer n = this.alignCheckpoints = update.getAlignCheckpointsForUpdate().equals(-1) ? null : update.getAlignCheckpointsForUpdate();
            }
            if (update.getUsePitForUpdate() != null) {
                this.usePit = update.getUsePitForUpdate().equals(-1) ? null : update.getUsePitForUpdate();
            }
            return this;
        }

        public SettingsConfig build() {
            return new SettingsConfig(this.maxPageSearchSize, this.docsPerSecond, this.datesAsEpochMillis, this.alignCheckpoints, this.usePit);
        }
    }
}

