/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class TransformMetadata
implements Metadata.Custom {
    public static final String TYPE = "transform";
    public static final ParseField RESET_MODE = new ParseField("reset_mode", new String[0]);
    public static final TransformMetadata EMPTY_METADATA = new TransformMetadata(false);
    public static final ObjectParser<Builder, Void> LENIENT_PARSER = new ObjectParser("transform_metadata", true, Builder::new);
    private final boolean resetMode;

    private TransformMetadata(boolean resetMode) {
        this.resetMode = resetMode;
    }

    public boolean isResetMode() {
        return this.resetMode;
    }

    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public String getWriteableName() {
        return TYPE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new TransformMetadataDiff((TransformMetadata)previousState, this);
    }

    public TransformMetadata(StreamInput in) throws IOException {
        this.resetMode = in.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.resetMode);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RESET_MODE.getPreferredName(), this.resetMode);
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransformMetadata that = (TransformMetadata)o;
        return this.resetMode == that.resetMode;
    }

    public final String toString() {
        return Strings.toString((ToXContent)this);
    }

    public int hashCode() {
        return Objects.hash(this.resetMode);
    }

    public static TransformMetadata getTransformMetadata(ClusterState state) {
        TransformMetadata TransformMetadata2;
        TransformMetadata transformMetadata = TransformMetadata2 = state == null ? null : (TransformMetadata)state.getMetadata().custom(TYPE);
        if (TransformMetadata2 == null) {
            return EMPTY_METADATA;
        }
        return TransformMetadata2;
    }

    static {
        LENIENT_PARSER.declareBoolean(Builder::isResetMode, RESET_MODE);
    }

    public static class TransformMetadataDiff
    implements NamedDiff<Metadata.Custom> {
        final boolean resetMode;

        TransformMetadataDiff(TransformMetadata before, TransformMetadata after) {
            this.resetMode = after.resetMode;
        }

        public TransformMetadataDiff(StreamInput in) throws IOException {
            this.resetMode = in.readBoolean();
        }

        public Metadata.Custom apply(Metadata.Custom part) {
            return new TransformMetadata(this.resetMode);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.resetMode);
        }

        public String getWriteableName() {
            return TransformMetadata.TYPE;
        }

        public Version getMinimalSupportedVersion() {
            return Version.CURRENT.minimumCompatibilityVersion();
        }
    }

    public static class Builder {
        private boolean resetMode;

        public static Builder from(@Nullable TransformMetadata previous) {
            return new Builder(previous);
        }

        public Builder() {
        }

        public Builder(@Nullable TransformMetadata previous) {
            if (previous != null) {
                this.resetMode = previous.resetMode;
            }
        }

        public Builder isResetMode(boolean isResetMode) {
            this.resetMode = isResetMode;
            return this;
        }

        public TransformMetadata build() {
            return new TransformMetadata(this.resetMode);
        }
    }
}

