/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.stream.Collectors;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchTransportService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationFailedException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.IndicesAccessControl;
import org.elasticsearch.xpack.core.security.authz.support.DLSRoleQueryValidator;
import org.elasticsearch.xpack.core.termsenum.action.MultiShardTermsEnum;
import org.elasticsearch.xpack.core.termsenum.action.NodeTermsEnumRequest;
import org.elasticsearch.xpack.core.termsenum.action.NodeTermsEnumResponse;
import org.elasticsearch.xpack.core.termsenum.action.TermCount;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumRequest;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumResponse;

public class TransportTermsEnumAction
extends HandledTransportAction<TermsEnumRequest, TermsEnumResponse> {
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final RemoteClusterService remoteClusterService;
    private final SearchService searchService;
    private final IndicesService indicesService;
    private final ScriptService scriptService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    final String transportShardAction;
    private final String shardExecutor;
    private final XPackLicenseState licenseState;
    private final Settings settings;

    @Inject
    public TransportTermsEnumAction(ClusterService clusterService, SearchService searchService, SearchTransportService searchTransportService, TransportService transportService, IndicesService indicesService, ScriptService scriptService, ActionFilters actionFilters, XPackLicenseState licenseState, Settings settings, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:data/read/xpack/termsenum/list", transportService, actionFilters, TermsEnumRequest::new);
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.transportShardAction = this.actionName + "[s]";
        this.shardExecutor = "auto_complete";
        this.indicesService = indicesService;
        this.scriptService = scriptService;
        this.licenseState = licenseState;
        this.settings = settings;
        this.remoteClusterService = searchTransportService.getRemoteClusterService();
        transportService.registerRequestHandler(this.transportShardAction, "same", NodeTermsEnumRequest::new, (TransportRequestHandler)new NodeTransportHandler());
    }

    protected void doExecute(Task task, TermsEnumRequest request, ActionListener<TermsEnumResponse> listener) {
        new AsyncBroadcastAction(task, request, listener).start();
    }

    protected NodeTermsEnumRequest newNodeRequest(OriginalIndices originalIndices, String nodeId, Set<ShardId> shardIds, TermsEnumRequest request, long taskStartMillis) {
        return new NodeTermsEnumRequest(originalIndices, nodeId, shardIds, request, taskStartMillis);
    }

    protected NodeTermsEnumResponse readShardResponse(StreamInput in) throws IOException {
        return new NodeTermsEnumResponse(in);
    }

    protected Map<String, Set<ShardId>> getNodeBundles(ClusterState clusterState, String[] concreteIndices) {
        HashMap<String, Set<ShardId>> fastNodeBundles = new HashMap<String, Set<ShardId>>();
        block0: for (String indexName : concreteIndices) {
            String[] singleIndex = new String[]{indexName};
            GroupShardsIterator shards = this.clusterService.operationRouting().searchShards(clusterState, singleIndex, null, null);
            for (ShardIterator copiesOfShard : shards) {
                Set<ShardId> bundle;
                ShardRouting selectedCopyOfShard = null;
                for (ShardRouting copy : copiesOfShard) {
                    if (!copy.active() || !copy.assignedToNode()) continue;
                    selectedCopyOfShard = copy;
                    break;
                }
                if (selectedCopyOfShard == null) continue block0;
                String nodeId = selectedCopyOfShard.currentNodeId();
                if (fastNodeBundles.containsKey(nodeId)) {
                    bundle = (Set)fastNodeBundles.get(nodeId);
                } else {
                    bundle = new HashSet();
                    fastNodeBundles.put(nodeId, bundle);
                }
                if (bundle == null) continue;
                bundle.add(selectedCopyOfShard.shardId());
            }
        }
        return fastNodeBundles;
    }

    protected ClusterBlockException checkGlobalBlock(ClusterState state, TermsEnumRequest request) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, TermsEnumRequest countRequest, String[] concreteIndices) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.READ, concreteIndices);
    }

    /*
     * WARNING - void declaration
     */
    protected TermsEnumResponse mergeResponses(TermsEnumRequest request, AtomicReferenceArray<?> atomicResponses, boolean complete, Map<String, Set<ShardId>> nodeBundles) {
        int successfulShards = 0;
        int failedShards = 0;
        ArrayList<DefaultShardOperationFailedException> shardFailures = null;
        ArrayList<List<TermCount>> termsList = new ArrayList<List<TermCount>>();
        for (int i = 0; i < atomicResponses.length(); ++i) {
            DefaultShardOperationFailedException[] shards;
            Object atomicResponse = atomicResponses.get(i);
            if (atomicResponse == null) continue;
            if (atomicResponse instanceof NodeTermsEnumResponse) {
                NodeTermsEnumResponse str = (NodeTermsEnumResponse)((Object)atomicResponse);
                if (!str.isComplete()) {
                    complete = false;
                }
                shards = nodeBundles.get(str.getNodeId());
                if (str.getError() != null) {
                    complete = false;
                    failedShards += shards.size();
                    if (shardFailures == null) {
                        shardFailures = new ArrayList<DefaultShardOperationFailedException>();
                    }
                    for (ShardId shardId : shards) {
                        shardFailures.add(new DefaultShardOperationFailedException((ElasticsearchException)new BroadcastShardOperationFailedException(shardId, str.getError())));
                    }
                } else {
                    successfulShards += shards.size();
                }
                termsList.add(str.terms());
                continue;
            }
            if (atomicResponse instanceof RemoteClusterTermsEnumResponse) {
                void var15_19;
                RemoteClusterTermsEnumResponse rc = (RemoteClusterTermsEnumResponse)atomicResponse;
                if (!rc.resp.isComplete() || rc.resp.getFailedShards() > 0) {
                    complete = false;
                }
                successfulShards += rc.resp.getSuccessfulShards();
                failedShards += rc.resp.getFailedShards();
                shards = rc.resp.getShardFailures();
                int n = shards.length;
                boolean bl = false;
                while (var15_19 < n) {
                    DefaultShardOperationFailedException exc = shards[var15_19];
                    shardFailures.add(new DefaultShardOperationFailedException(rc.clusterAlias + ":" + exc.index(), exc.shardId(), exc.getCause()));
                    ++var15_19;
                }
                List terms = rc.resp.getTerms().stream().map(a -> new TermCount((String)a, 1L)).collect(Collectors.toList());
                termsList.add(terms);
                continue;
            }
            throw new AssertionError((Object)("Unknown atomic response type: " + atomicResponse.getClass().getName()));
        }
        List<String> ans = termsList.size() == 1 ? ((List)termsList.get(0)).stream().map(TermCount::getTerm).collect(Collectors.toList()) : this.mergeResponses(termsList, request.size());
        return new TermsEnumResponse(ans, failedShards + successfulShards, successfulShards, failedShards, shardFailures, complete);
    }

    private List<String> mergeResponses(List<List<TermCount>> termsList, int size) {
        TermCountIterator it;
        PriorityQueue<TermCountIterator> pq = new PriorityQueue<TermCountIterator>(termsList.size()){

            protected boolean lessThan(TermCountIterator a, TermCountIterator b) {
                return a.compareTo(b) < 0;
            }
        };
        for (List<TermCount> terms : termsList) {
            it = terms.iterator();
            if (!it.hasNext()) continue;
            pq.add((Object)new TermCountIterator(it));
        }
        TermCount lastTerm = null;
        ArrayList<String> ans = new ArrayList<String>();
        while (pq.size() != 0) {
            it = (TermCountIterator)pq.top();
            String term = it.term();
            long docCount = it.docCount();
            if (lastTerm != null && lastTerm.getTerm().compareTo(term) != 0) {
                ans.add(lastTerm.getTerm());
                if (ans.size() == size) break;
                lastTerm = null;
            }
            if (lastTerm == null) {
                lastTerm = new TermCount(term, 0L);
            }
            lastTerm.addToDocCount(docCount);
            if (it.hasNext()) {
                String itTerm = it.term();
                it.next();
                assert (itTerm.compareTo(it.term()) <= 0);
                pq.updateTop();
                continue;
            }
            pq.pop();
        }
        if (lastTerm != null && ans.size() < size) {
            ans.add(lastTerm.getTerm());
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeTermsEnumResponse dataNodeOperation(NodeTermsEnumRequest request, Task task) throws IOException {
        ArrayList<TermCount> termsList = new ArrayList<TermCount>();
        String error = null;
        long timeout_millis = request.timeout();
        long scheduledEnd = request.nodeStartedTimeMillis() + timeout_millis;
        ArrayList<TermsEnum> shardTermsEnums = new ArrayList<TermsEnum>();
        ArrayList<Engine.Searcher> openedResources = new ArrayList<Engine.Searcher>();
        try {
            Object indexService;
            for (ShardId shardId : request.shardIds()) {
                TermsEnum terms;
                if (System.currentTimeMillis() > scheduledEnd) {
                    NodeTermsEnumResponse nodeTermsEnumResponse = new NodeTermsEnumResponse(request.nodeId(), termsList, error, false);
                    return nodeTermsEnumResponse;
                }
                indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
                IndexShard indexShard = indexService.getShard(shardId.getId());
                Engine.Searcher searcher = indexShard.acquireSearcher("search");
                openedResources.add(searcher);
                SearchExecutionContext queryShardContext = indexService.newSearchExecutionContext(shardId.id(), 0, (IndexSearcher)searcher, request::nodeStartedTimeMillis, null, Collections.emptyMap());
                MappedFieldType mappedFieldType = indexShard.mapperService().fieldType(request.field());
                if (mappedFieldType == null || (terms = mappedFieldType.getTerms(request.caseInsensitive(), request.string() == null ? "" : request.string(), queryShardContext, request.searchAfter())) == null) continue;
                shardTermsEnums.add(terms);
            }
            if (shardTermsEnums.size() == 0) {
                Object object = new NodeTermsEnumResponse(request.nodeId(), termsList, error, true);
                return object;
            }
            MultiShardTermsEnum te = new MultiShardTermsEnum(shardTermsEnums.toArray(new TermsEnum[0]));
            int shard_size = request.size();
            if (System.currentTimeMillis() > scheduledEnd) {
                indexService = new NodeTermsEnumResponse(request.nodeId(), termsList, error, false);
                return indexService;
            }
            int numTermsBetweenClockChecks = 100;
            int termCount = 0;
            while (te.next() != null) {
                if (++termCount > numTermsBetweenClockChecks) {
                    if (System.currentTimeMillis() > scheduledEnd) {
                        boolean complete = te.next() == null;
                        NodeTermsEnumResponse nodeTermsEnumResponse = new NodeTermsEnumResponse(request.nodeId(), termsList, error, complete);
                        return nodeTermsEnumResponse;
                    }
                    termCount = 0;
                }
                long df = te.docFreq();
                BytesRef bytes = te.term();
                termsList.add(new TermCount(bytes.utf8ToString(), df));
                if (termsList.size() < shard_size) continue;
                break;
            }
        }
        catch (Exception e) {
            error = ExceptionsHelper.stackTrace((Throwable)e);
        }
        finally {
            IOUtils.close(openedResources);
        }
        return new NodeTermsEnumResponse(request.nodeId(), termsList, error, true);
    }

    private boolean canAccess(ShardId shardId, NodeTermsEnumRequest request, XPackLicenseState frozenLicenseState, ThreadContext threadContext) throws IOException {
        boolean dls;
        IndicesAccessControl indicesAccessControl;
        IndicesAccessControl.IndexAccessControl indexAccessControl;
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue() && (indexAccessControl = (indicesAccessControl = (IndicesAccessControl)threadContext.getTransient("_indices_permissions")).getIndexPermissions(shardId.getIndexName())) != null && (dls = indexAccessControl.getDocumentPermissions().hasDocumentLevelPermissions()) && SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(frozenLicenseState)) {
            SecurityContext securityContext = new SecurityContext(this.clusterService.getSettings(), threadContext);
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            SearchExecutionContext queryShardContext = indexService.newSearchExecutionContext(shardId.id(), 0, null, request::nodeStartedTimeMillis, null, Collections.emptyMap());
            Set<BytesReference> queries = indexAccessControl.getDocumentPermissions().getQueries();
            for (BytesReference querySource : queries) {
                QueryBuilder queryBuilder = DLSRoleQueryValidator.evaluateAndVerifyRoleQuery(querySource, this.scriptService, queryShardContext.getXContentRegistry(), securityContext.getUser());
                QueryBuilder rewrittenQueryBuilder = (QueryBuilder)Rewriteable.rewrite((Rewriteable)queryBuilder, (QueryRewriteContext)queryShardContext);
                if (!(rewrittenQueryBuilder instanceof MatchAllQueryBuilder)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean canMatchShard(ShardId shardId, NodeTermsEnumRequest req) throws IOException {
        if (req.indexFilter() == null || req.indexFilter() instanceof MatchAllQueryBuilder) {
            return true;
        }
        ShardSearchRequest searchRequest = new ShardSearchRequest(shardId, req.nodeStartedTimeMillis(), AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(req.indexFilter()));
        return this.searchService.canMatch(searchRequest).canMatch();
    }

    private void asyncNodeOperation(NodeTermsEnumRequest request, Task task, ActionListener<NodeTermsEnumResponse> listener) throws IOException {
        request.startTimerOnDataNode();
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        XPackLicenseState frozenLicenseState = this.licenseState.copyCurrentLicenseState();
        for (ShardId shardId : request.shardIds().toArray(new ShardId[0])) {
            if (this.canAccess(shardId, request, frozenLicenseState, threadContext) && this.canMatchShard(shardId, request)) continue;
            request.remove(shardId);
        }
        if (request.shardIds().size() == 0) {
            listener.onResponse((Object)new NodeTermsEnumResponse(request.nodeId(), Collections.emptyList(), null, true));
        } else {
            assert (this.transportService.getThreadPool().executor("search") instanceof EsThreadPoolExecutor) : "SEARCH threadpool must be an instance of ThreadPoolExecutor";
            EsThreadPoolExecutor ex = (EsThreadPoolExecutor)this.transportService.getThreadPool().executor("search");
            String executorName = ex.getQueue().size() == 0 ? "search" : this.shardExecutor;
            this.transportService.getThreadPool().executor(executorName).execute((Runnable)ActionRunnable.supply(listener, () -> this.dataNodeOperation(request, task)));
        }
    }

    class NodeTransportHandler
    implements TransportRequestHandler<NodeTermsEnumRequest> {
        NodeTransportHandler() {
        }

        public void messageReceived(NodeTermsEnumRequest request, TransportChannel channel, Task task) throws Exception {
            TransportTermsEnumAction.this.asyncNodeOperation(request, task, (ActionListener<NodeTermsEnumResponse>)ActionListener.wrap(arg_0 -> ((TransportChannel)channel).sendResponse(arg_0), e -> {
                try {
                    channel.sendResponse(e);
                }
                catch (Exception e1) {
                    TransportTermsEnumAction.this.logger.warn(() -> new ParameterizedMessage("Failed to send error response for action [{}] and request [{}]", (Object)TransportTermsEnumAction.this.actionName, (Object)request), (Throwable)e1);
                }
            }));
        }
    }

    protected class AsyncBroadcastAction {
        private final Task task;
        private final TermsEnumRequest request;
        private ActionListener<TermsEnumResponse> listener;
        private final DiscoveryNodes nodes;
        private final int expectedOps;
        private final AtomicInteger counterOps = new AtomicInteger();
        private final AtomicReferenceArray<Object> atomicResponses;
        private final Map<String, Set<ShardId>> nodeBundles;
        private final OriginalIndices localIndices;
        private final Map<String, OriginalIndices> remoteClusterIndices;

        protected AsyncBroadcastAction(Task task, TermsEnumRequest request, ActionListener<TermsEnumResponse> listener) {
            this.task = task;
            this.request = request;
            this.listener = listener;
            ClusterState clusterState = TransportTermsEnumAction.this.clusterService.state();
            ClusterBlockException blockException = TransportTermsEnumAction.this.checkGlobalBlock(clusterState, request);
            if (blockException != null) {
                throw blockException;
            }
            this.remoteClusterIndices = TransportTermsEnumAction.this.remoteClusterService.groupIndices(request.indicesOptions(), request.indices());
            this.localIndices = this.remoteClusterIndices.remove("");
            String[] concreteIndices = this.localIndices == null ? new String[]{} : TransportTermsEnumAction.this.indexNameExpressionResolver.concreteIndexNames(clusterState, (IndicesRequest)this.localIndices);
            blockException = TransportTermsEnumAction.this.checkRequestBlock(clusterState, request, concreteIndices);
            if (blockException != null) {
                throw blockException;
            }
            this.nodes = clusterState.nodes();
            TransportTermsEnumAction.this.logger.trace("resolving shards based on cluster state version [{}]", (Object)clusterState.version());
            this.nodeBundles = TransportTermsEnumAction.this.getNodeBundles(clusterState, concreteIndices);
            this.expectedOps = this.nodeBundles.size() + this.remoteClusterIndices.size();
            this.atomicResponses = new AtomicReferenceArray(this.expectedOps);
        }

        public void start() {
            if (this.expectedOps == 0) {
                try {
                    this.listener.onResponse((Object)TransportTermsEnumAction.this.mergeResponses(this.request, new AtomicReferenceArray(0), true, this.nodeBundles));
                }
                catch (Exception e) {
                    this.listener.onFailure(e);
                }
                return;
            }
            int numOps = 0;
            for (String nodeId : this.nodeBundles.keySet()) {
                if (this.checkForEarlyFinish()) {
                    return;
                }
                Set<ShardId> shardIds = this.nodeBundles.get(nodeId);
                if (shardIds.size() > 0) {
                    this.performOperation(nodeId, shardIds, numOps);
                } else {
                    this.onNodeFailure(nodeId, numOps, null);
                }
                ++numOps;
            }
            for (String clusterAlias : this.remoteClusterIndices.keySet()) {
                this.performRemoteClusterOperation(clusterAlias, this.remoteClusterIndices.get(clusterAlias), numOps);
                ++numOps;
            }
        }

        boolean checkForEarlyFinish() {
            long now = System.currentTimeMillis();
            if (now - this.task.getStartTime() > this.request.timeout().getMillis()) {
                this.finishHim(false);
                return true;
            }
            return false;
        }

        protected void performOperation(final String nodeId, Set<ShardId> shardIds, final int opsIndex) {
            if (shardIds.size() == 0) {
                this.onNodeFailure(nodeId, opsIndex, null);
            } else {
                try {
                    NodeTermsEnumRequest nodeRequest = TransportTermsEnumAction.this.newNodeRequest(this.localIndices, nodeId, shardIds, this.request, this.task.getStartTime());
                    nodeRequest.setParentTask(TransportTermsEnumAction.this.clusterService.localNode().getId(), this.task.getId());
                    DiscoveryNode node = this.nodes.get(nodeId);
                    if (node == null) {
                        this.onNodeFailure(nodeId, opsIndex, null);
                    } else if (!this.checkForEarlyFinish()) {
                        TransportTermsEnumAction.this.transportService.sendRequest(node, TransportTermsEnumAction.this.transportShardAction, (TransportRequest)nodeRequest, (TransportResponseHandler)new TransportResponseHandler<NodeTermsEnumResponse>(){

                            public NodeTermsEnumResponse read(StreamInput in) throws IOException {
                                return TransportTermsEnumAction.this.readShardResponse(in);
                            }

                            public void handleResponse(NodeTermsEnumResponse response) {
                                AsyncBroadcastAction.this.onNodeResponse(nodeId, opsIndex, response);
                            }

                            public void handleException(TransportException exc) {
                                AsyncBroadcastAction.this.onNodeFailure(nodeId, opsIndex, (Exception)exc);
                            }
                        });
                    }
                }
                catch (Exception exc) {
                    this.onNodeFailure(nodeId, opsIndex, exc);
                }
            }
        }

        void performRemoteClusterOperation(final String clusterAlias, OriginalIndices remoteIndices, final int opsIndex) {
            try {
                TermsEnumRequest req = (TermsEnumRequest)new TermsEnumRequest(this.request).indices(remoteIndices.indices());
                Client remoteClient = TransportTermsEnumAction.this.remoteClusterService.getRemoteClusterClient(TransportTermsEnumAction.this.transportService.getThreadPool(), clusterAlias);
                remoteClient.execute((ActionType)TermsEnumAction.INSTANCE, (ActionRequest)req, (ActionListener)new ActionListener<TermsEnumResponse>(){

                    public void onResponse(TermsEnumResponse termsEnumResponse) {
                        AsyncBroadcastAction.this.onRemoteClusterResponse(clusterAlias, opsIndex, new RemoteClusterTermsEnumResponse(clusterAlias, termsEnumResponse));
                    }

                    public void onFailure(Exception exc) {
                        AsyncBroadcastAction.this.onRemoteClusterFailure(clusterAlias, opsIndex, exc);
                    }
                });
            }
            catch (Exception exc) {
                this.onRemoteClusterFailure(clusterAlias, opsIndex, null);
            }
        }

        private void onNodeResponse(String nodeId, int opsIndex, NodeTermsEnumResponse response) {
            TransportTermsEnumAction.this.logger.trace("received response for node {}", (Object)nodeId);
            this.atomicResponses.set(opsIndex, (Object)response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            } else {
                this.checkForEarlyFinish();
            }
        }

        private void onRemoteClusterResponse(String clusterAlias, int opsIndex, RemoteClusterTermsEnumResponse response) {
            TransportTermsEnumAction.this.logger.trace("received response for cluster {}", (Object)clusterAlias);
            this.atomicResponses.set(opsIndex, response);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            } else {
                this.checkForEarlyFinish();
            }
        }

        private void onNodeFailure(String nodeId, int opsIndex, Exception exc) {
            TransportTermsEnumAction.this.logger.trace("received failure {} for node {}", (Object)exc, (Object)nodeId);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            }
        }

        private void onRemoteClusterFailure(String clusterAlias, int opsIndex, Exception exc) {
            TransportTermsEnumAction.this.logger.trace("received failure {} for cluster {}", (Object)exc, (Object)clusterAlias);
            if (this.expectedOps == this.counterOps.incrementAndGet()) {
                this.finishHim(true);
            }
        }

        protected synchronized void finishHim(boolean complete) {
            if (this.listener == null) {
                return;
            }
            try {
                this.listener.onResponse((Object)TransportTermsEnumAction.this.mergeResponses(this.request, this.atomicResponses, complete, this.nodeBundles));
            }
            catch (Exception e) {
                this.listener.onFailure(e);
            }
            finally {
                this.listener = null;
            }
        }
    }

    private static class RemoteClusterTermsEnumResponse {
        final String clusterAlias;
        final TermsEnumResponse resp;

        private RemoteClusterTermsEnumResponse(String clusterAlias, TermsEnumResponse resp) {
            this.clusterAlias = clusterAlias;
            this.resp = resp;
        }
    }

    private static class TermCountIterator
    implements Iterator<TermCount>,
    Comparable<TermCountIterator> {
        private final Iterator<TermCount> iterator;
        private TermCount current;

        private TermCountIterator(Iterator<TermCount> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }

        public String term() {
            return this.current.getTerm();
        }

        public long docCount() {
            return this.current.getDocCount();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public TermCount next() {
            this.current = this.iterator.next();
            return this.current;
        }

        @Override
        public int compareTo(TermCountIterator o) {
            return this.current.getTerm().compareTo(o.term());
        }
    }
}

