/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslClientAuthenticationMode;
import org.elasticsearch.common.ssl.SslVerificationMode;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.ssl.X509KeyPairSettings;

public class SSLConfigurationSettings {
    final X509KeyPairSettings x509KeyPair;
    final Setting<List<String>> ciphers;
    final Setting<List<String>> supportedProtocols;
    final Setting<Optional<String>> truststorePath;
    final Setting<SecureString> truststorePassword;
    final Setting<String> truststoreAlgorithm;
    final Setting<Optional<String>> truststoreType;
    final Setting<Optional<String>> trustRestrictionsPath;
    final Setting<List<String>> caPaths;
    final Setting<Optional<SslClientAuthenticationMode>> clientAuth;
    final Setting<Optional<SslVerificationMode>> verificationMode;
    private final Setting<SecureString> legacyTruststorePassword;
    private final List<Setting<?>> enabledSettings;
    private final List<Setting<?>> disabledSettings;
    private static final Function<String, Setting<List<String>>> CIPHERS_SETTING_TEMPLATE = key -> Setting.listSetting((String)key, List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    private static final SslSetting<List<String>> CIPHERS = SslSetting.setting("cipher_suites", CIPHERS_SETTING_TEMPLATE);
    private static final SslSetting<List<String>> SUPPORTED_PROTOCOLS = SslSetting.setting("supported_protocols", key -> Setting.listSetting((String)key, List.of(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
    private static final SslSetting<Optional<String>> KEYSTORE_PATH = SslSetting.setting("keystore.path", X509KeyPairSettings.KEYSTORE_PATH_TEMPLATE);
    private static final SslSetting<SecureString> LEGACY_KEYSTORE_PASSWORD = SslSetting.setting("keystore.password", X509KeyPairSettings.LEGACY_KEYSTORE_PASSWORD_TEMPLATE);
    private static final SslSetting<SecureString> KEYSTORE_PASSWORD = SslSetting.secureSetting("keystore.secure_password", X509KeyPairSettings.KEYSTORE_PASSWORD_TEMPLATE);
    private static final SslSetting<SecureString> LEGACY_KEYSTORE_KEY_PASSWORD = SslSetting.setting("keystore.key_password", X509KeyPairSettings.LEGACY_KEYSTORE_KEY_PASSWORD_TEMPLATE);
    private static final SslSetting<SecureString> KEYSTORE_KEY_PASSWORD = SslSetting.secureSetting("keystore.secure_key_password", X509KeyPairSettings.KEYSTORE_KEY_PASSWORD_TEMPLATE);
    public static final SslSetting<Optional<String>> TRUSTSTORE_PATH = SslSetting.setting("truststore.path", key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
    private static final SslSetting<Optional<String>> KEY_PATH = SslSetting.setting("key", X509KeyPairSettings.KEY_PATH_TEMPLATE);
    public static final SslSetting<SecureString> LEGACY_TRUSTSTORE_PASSWORD = SslSetting.setting("truststore.password", key -> new Setting(key, "", SecureString::new, new Setting.Property[]{Setting.Property.DeprecatedWarning, Setting.Property.Filtered, Setting.Property.NodeScope}));
    public static final SslSetting<SecureString> TRUSTSTORE_PASSWORD = SslSetting.secureSetting("truststore.secure_password", key -> SecureSetting.secureString((String)key, LEGACY_TRUSTSTORE_PASSWORD.template().apply(key.replace("truststore.secure_password", "truststore.password")), (Setting.Property[])new Setting.Property[0]));
    private static final SslSetting<String> KEY_STORE_ALGORITHM = SslSetting.setting("keystore.algorithm", X509KeyPairSettings.KEY_STORE_ALGORITHM_TEMPLATE);
    public static final Function<String, Setting<String>> TRUST_STORE_ALGORITHM_TEMPLATE = key -> new Setting(key, s -> TrustManagerFactory.getDefaultAlgorithm(), Function.identity(), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final SslSetting<String> TRUSTSTORE_ALGORITHM = SslSetting.setting("truststore.algorithm", TRUST_STORE_ALGORITHM_TEMPLATE);
    private static final SslSetting<Optional<String>> KEY_STORE_TYPE = SslSetting.setting("keystore.type", X509KeyPairSettings.KEY_STORE_TYPE_TEMPLATE);
    public static final Function<String, Setting<Optional<String>>> TRUST_STORE_TYPE_TEMPLATE = X509KeyPairSettings.KEY_STORE_TYPE_TEMPLATE;
    public static final SslSetting<Optional<String>> TRUSTSTORE_TYPE = SslSetting.setting("truststore.type", TRUST_STORE_TYPE_TEMPLATE);
    private static final Function<String, Setting<Optional<String>>> TRUST_RESTRICTIONS_TEMPLATE = key -> new Setting(key, s -> null, Optional::ofNullable, new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    private static final SslSetting<Optional<String>> TRUST_RESTRICTIONS = SslSetting.setting("trust_restrictions.path", TRUST_RESTRICTIONS_TEMPLATE);
    private static final SslSetting<SecureString> LEGACY_KEY_PASSWORD = SslSetting.setting("key_passphrase", X509KeyPairSettings.LEGACY_KEY_PASSWORD_TEMPLATE);
    private static final SslSetting<SecureString> KEY_PASSWORD = SslSetting.secureSetting("secure_key_passphrase", X509KeyPairSettings.KEY_PASSWORD_TEMPLATE);
    private static final SslSetting<Optional<String>> CERT = SslSetting.setting("certificate", X509KeyPairSettings.CERT_TEMPLATE);
    public static final Function<String, Setting<List<String>>> CAPATH_SETTING_TEMPLATE = key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    public static final SslSetting<List<String>> CERT_AUTH_PATH = SslSetting.setting("certificate_authorities", CAPATH_SETTING_TEMPLATE);
    public static final Function<String, Setting.AffixSetting<List<String>>> CAPATH_SETTING_REALM = CERT_AUTH_PATH::realm;
    private static final Function<String, Setting<Optional<SslClientAuthenticationMode>>> CLIENT_AUTH_SETTING_TEMPLATE = key -> new Setting(key, (String)null, s -> s == null ? Optional.empty() : Optional.of(SslClientAuthenticationMode.parse((String)s)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    private static final SslSetting<Optional<SslClientAuthenticationMode>> CLIENT_AUTH_SETTING = SslSetting.setting("client_authentication", CLIENT_AUTH_SETTING_TEMPLATE);
    private static final Function<String, Setting<Optional<SslVerificationMode>>> VERIFICATION_MODE_SETTING_TEMPLATE = key -> new Setting(key, (String)null, s -> s == null ? Optional.empty() : Optional.of(SslVerificationMode.parse((String)s)), new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    private static final SslSetting<Optional<SslVerificationMode>> VERIFICATION_MODE = SslSetting.setting("verification_mode", VERIFICATION_MODE_SETTING_TEMPLATE);
    public static final Function<String, Setting.AffixSetting<Optional<SslVerificationMode>>> VERIFICATION_MODE_SETTING_REALM = VERIFICATION_MODE::realm;

    private SSLConfigurationSettings(String prefix, boolean acceptNonSecurePasswords) {
        assert (prefix != null) : "Prefix cannot be null (but can be blank)";
        this.x509KeyPair = X509KeyPairSettings.withPrefix(prefix, acceptNonSecurePasswords);
        this.ciphers = CIPHERS.withPrefix(prefix);
        this.supportedProtocols = SUPPORTED_PROTOCOLS.withPrefix(prefix);
        this.truststorePath = TRUSTSTORE_PATH.withPrefix(prefix);
        this.legacyTruststorePassword = LEGACY_TRUSTSTORE_PASSWORD.withPrefix(prefix);
        this.truststorePassword = TRUSTSTORE_PASSWORD.withPrefix(prefix);
        this.truststoreAlgorithm = TRUSTSTORE_ALGORITHM.withPrefix(prefix);
        this.truststoreType = TRUSTSTORE_TYPE.withPrefix(prefix);
        this.trustRestrictionsPath = TRUST_RESTRICTIONS.withPrefix(prefix);
        this.caPaths = CERT_AUTH_PATH.withPrefix(prefix);
        this.clientAuth = CLIENT_AUTH_SETTING.withPrefix(prefix);
        this.verificationMode = VERIFICATION_MODE.withPrefix(prefix);
        ArrayList enabled = CollectionUtils.arrayAsArrayList((Object[])new Setting[]{this.ciphers, this.supportedProtocols, this.truststorePath, this.truststorePassword, this.truststoreAlgorithm, this.truststoreType, this.trustRestrictionsPath, this.caPaths, this.clientAuth, this.verificationMode});
        ArrayList disabled = new ArrayList();
        if (acceptNonSecurePasswords) {
            enabled.add(this.legacyTruststorePassword);
        } else {
            disabled.add(this.legacyTruststorePassword);
        }
        enabled.addAll(this.x509KeyPair.getEnabledSettings());
        disabled.addAll(this.x509KeyPair.getDisabledSettings());
        this.enabledSettings = Collections.unmodifiableList(enabled);
        this.disabledSettings = Collections.unmodifiableList(disabled);
    }

    public List<Setting<?>> getEnabledSettings() {
        return this.enabledSettings;
    }

    public List<Setting<?>> getDisabledSettings() {
        return this.disabledSettings;
    }

    public static SSLConfigurationSettings withoutPrefix(boolean acceptNonSecurePasswords) {
        return new SSLConfigurationSettings("", acceptNonSecurePasswords);
    }

    public static SSLConfigurationSettings withPrefix(String prefix, boolean acceptNonSecurePasswords) {
        assert (prefix.endsWith(".")) : "The ssl config prefix (" + prefix + ") should end in '.'";
        return new SSLConfigurationSettings(prefix, acceptNonSecurePasswords);
    }

    private static Collection<SslSetting<?>> settings() {
        return Arrays.asList(CIPHERS, SUPPORTED_PROTOCOLS, KEYSTORE_PATH, LEGACY_KEYSTORE_PASSWORD, KEYSTORE_PASSWORD, LEGACY_KEYSTORE_KEY_PASSWORD, KEYSTORE_KEY_PASSWORD, TRUSTSTORE_PATH, LEGACY_TRUSTSTORE_PASSWORD, TRUSTSTORE_PASSWORD, KEY_STORE_ALGORITHM, TRUSTSTORE_ALGORITHM, KEY_STORE_TYPE, TRUSTSTORE_TYPE, TRUST_RESTRICTIONS, KEY_PATH, LEGACY_KEY_PASSWORD, KEY_PASSWORD, CERT, CERT_AUTH_PATH, CLIENT_AUTH_SETTING, VERIFICATION_MODE);
    }

    public static Collection<Setting<?>> getProfileSettings() {
        return SSLConfigurationSettings.settings().stream().map(SslSetting::transportProfile).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<Setting.AffixSetting<?>> getRealmSettings(String realmType) {
        return SSLConfigurationSettings.settings().stream().map(s -> s.realm(realmType)).collect(Collectors.toList());
    }

    public List<Setting<? extends SecureString>> getSecureSettingsInUse(Settings settings) {
        return this.getSecureSettings().stream().filter(s -> s.exists(settings)).collect(Collectors.toList());
    }

    List<Setting<? extends SecureString>> getSecureSettings() {
        return List.of(this.truststorePassword, this.x509KeyPair.keyPassword, this.x509KeyPair.keystorePassword, this.x509KeyPair.keystoreKeyPassword);
    }

    public static class SslSetting<T> {
        protected final String name;
        protected final Function<String, Setting<T>> template;

        public SslSetting(String name, Function<String, Setting<T>> template) {
            this.name = name;
            this.template = template;
        }

        public static SslSetting<SecureString> secureSetting(String name, Function<String, Setting<SecureString>> template) {
            return new SslSetting<SecureString>(name, template);
        }

        public static <T> SslSetting<T> setting(String name, Function<String, Setting<T>> template) {
            return new SslSetting<T>(name, template);
        }

        Function<String, Setting<T>> template() {
            return this.template;
        }

        Setting<T> rawSetting() {
            return this.applyTemplate(this.name);
        }

        public Setting<T> withPrefix(String prefix) {
            if (prefix.length() == 0) {
                return this.rawSetting();
            }
            if (prefix.endsWith(".")) {
                return this.applyTemplate(prefix + this.name);
            }
            throw new IllegalArgumentException("The ssl config prefix (" + prefix + ") should end in '.'");
        }

        Setting<T> applyTemplate(String key) {
            return this.template.apply(key);
        }

        public Setting.AffixSetting<T> realm(String realmType) {
            return this.affixSetting("xpack.security.authc.realms." + realmType + ".", "ssl.");
        }

        public Setting<T> realm(RealmConfig.RealmIdentifier realmId) {
            return this.realm(realmId.getType()).getConcreteSettingForNamespace(realmId.getName());
        }

        Setting.AffixSetting<T> transportProfile() {
            return this.affixSetting("transport.profiles.", "xpack.security.ssl.");
        }

        public Setting.AffixSetting<T> affixSetting(String groupPrefix, String keyPrefix) {
            return Setting.affixKeySetting((String)groupPrefix, (String)(keyPrefix + this.name), this.template, (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        }

        public Setting<T> transportProfile(String settingName) {
            return this.transportProfile().getConcreteSetting(settingName);
        }
    }
}

