/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class ReservedRolesStore
implements BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>> {
    public static final String ALERTS_LEGACY_INDEX = ".siem-signals*";
    public static final String ALERTS_BACKING_INDEX = ".internal.alerts*";
    public static final String ALERTS_INDEX_ALIAS = ".alerts*";
    public static final String PREVIEW_ALERTS_INDEX_ALIAS = ".preview.alerts*";
    public static final String PREVIEW_ALERTS_BACKING_INDEX_ALIAS = ".internal.preview.alerts*";
    public static final RoleDescriptor SUPERUSER_ROLE_DESCRIPTOR = new RoleDescriptor("superuser", new String[]{"all"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("all").allowRestrictedIndices(true).build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("*").privileges("*").resources("*").build()}, null, new String[]{"*"}, MetadataUtils.DEFAULT_RESERVED_METADATA, Collections.emptyMap());
    private static final Map<String, RoleDescriptor> RESERVED_ROLES = ReservedRolesStore.initializeReservedRoles();

    private static Map<String, RoleDescriptor> initializeReservedRoles() {
        return MapBuilder.newMapBuilder().put((Object)"superuser", (Object)SUPERUSER_ROLE_DESCRIPTOR).put((Object)"transport_client", (Object)new RoleDescriptor("transport_client", new String[]{"transport_client"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"kibana_admin", (Object)ReservedRolesStore.kibanaAdminUser("kibana_admin", MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"kibana_user", (Object)ReservedRolesStore.kibanaAdminUser("kibana_user", MetadataUtils.getDeprecatedReservedMetadata("Please use the [kibana_admin] role instead"))).put((Object)"monitoring_user", (Object)new RoleDescriptor("monitoring_user", new String[]{"cluster:monitor/main", "cluster:monitor/xpack/info", "cluster:monitor/remote/info"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("read", "read_cross_cluster").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_monitoring").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"remote_monitoring_agent", (Object)new RoleDescriptor("remote_monitoring_agent", new String[]{"manage_index_templates", "manage_ingest_pipelines", "monitor", "cluster:admin/ilm/get", "cluster:admin/ilm/put", "cluster:monitor/xpack/watcher/watch/get", "cluster:admin/xpack/watcher/watch/put", "cluster:admin/xpack/watcher/watch/delete"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metricbeat-*").privileges("index", "create_index", "view_index_metadata", "indices:admin/aliases").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"remote_monitoring_collector", (Object)new RoleDescriptor("remote_monitoring_collector", new String[]{"monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("monitor").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*").privileges("read").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"ingest_admin", (Object)new RoleDescriptor("ingest_admin", new String[]{"manage_index_templates", "manage_pipeline"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"reporting_user", (Object)new RoleDescriptor("reporting_user", null, null, null, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use Kibana feature privileges instead"), null)).put((Object)"kibana_system", (Object)ReservedRolesStore.kibanaSystemRoleDescriptor("kibana_system")).put((Object)"logstash_system", (Object)new RoleDescriptor("logstash_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"beats_admin", (Object)new RoleDescriptor("beats_admin", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("all").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"beats_system", (Object)new RoleDescriptor("beats_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-beats-*").privileges("create_index", "create").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"apm_system", (Object)new RoleDescriptor("apm_system", new String[]{"monitor", "cluster:admin/xpack/monitoring/bulk"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-beats-*").privileges("create_index", "create_doc").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"apm_user", (Object)new RoleDescriptor("apm_user", null, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("traces-apm.*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("traces-apm-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("observability-annotations").privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_apm_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("This role will be removed in 8.0"), null)).put((Object)"machine_learning_user", (Object)new RoleDescriptor("machine_learning_user", new String[]{"monitor_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*").privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"machine_learning_admin", (Object)new RoleDescriptor("machine_learning_admin", new String[]{"manage_ml"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-notifications*", ".ml-state*", ".ml-meta*", ".ml-stats-*").allowRestrictedIndices(true).privileges("view_index_metadata", "read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*").privileges("view_index_metadata", "read", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_admin").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"data_frame_transforms_admin", (Object)new RoleDescriptor("data_frame_transforms_admin", new String[]{"manage_data_frame_transforms"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use the [transform_admin] role instead"), null)).put((Object)"data_frame_transforms_user", (Object)new RoleDescriptor("data_frame_transforms_user", new String[]{"monitor_data_frame_transforms"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-*").resources("*").privileges("reserved_ml_user").build()}, null, null, MetadataUtils.getDeprecatedReservedMetadata("Please use the [transform_user] role instead"), null)).put((Object)"transform_admin", (Object)new RoleDescriptor("transform_admin", new String[]{"manage_transform"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"transform_user", (Object)new RoleDescriptor("transform_user", new String[]{"monitor_transform"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".transform-notifications-*", ".data-frame-notifications-*", ".transform-notifications-read").privileges("view_index_metadata", "read").build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"watcher_admin", (Object)new RoleDescriptor("watcher_admin", new String[]{"manage_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches", ".triggered_watches", ".watcher-history-*").privileges("read").allowRestrictedIndices(true).build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"watcher_user", (Object)new RoleDescriptor("watcher_user", new String[]{"monitor_watcher"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".watches").privileges("read").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".watcher-history-*").privileges("read").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"logstash_admin", (Object)new RoleDescriptor("logstash_admin", new String[]{"manage_logstash_pipelines"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".logstash*").privileges("create", "delete", "index", "manage", "read").allowRestrictedIndices(true).build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"rollup_user", (Object)new RoleDescriptor("rollup_user", new String[]{"monitor_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"rollup_admin", (Object)new RoleDescriptor("rollup_admin", new String[]{"manage_rollup"}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"snapshot_user", (Object)new RoleDescriptor("snapshot_user", new String[]{"create_snapshot", "cluster:admin/repository/get"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("view_index_metadata").allowRestrictedIndices(true).build()}, null, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null)).put((Object)"enrich_user", (Object)new RoleDescriptor("enrich_user", new String[]{"manage_enrich", "manage_ingest_pipelines", "monitor"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".enrich-*").privileges("manage", "read", "write").build()}, null, MetadataUtils.DEFAULT_RESERVED_METADATA)).put((Object)"viewer", (Object)ReservedRolesStore.buildViewerRoleDescriptor()).put((Object)"editor", (Object)ReservedRolesStore.buildEditorRoleDescriptor()).immutableMap();
    }

    private static RoleDescriptor buildViewerRoleDescriptor() {
        return new RoleDescriptor("viewer", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/~(([.]|ilm-history-).*)/").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".siem-signals-*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_INDEX_ALIAS, PREVIEW_ALERTS_INDEX_ALIAS).privileges("read", "view_index_metadata").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("read").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    private static RoleDescriptor buildEditorRoleDescriptor() {
        return new RoleDescriptor("editor", new String[0], new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices("/~(([.]|ilm-history-).*)/").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("observability-annotations").privileges("read", "view_index_metadata", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".siem-signals-*", ".lists-*", ".items-*").privileges("read", "view_index_metadata", "write", "maintenance").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_BACKING_INDEX, ALERTS_INDEX_ALIAS, PREVIEW_ALERTS_BACKING_INDEX_ALIAS, PREVIEW_ALERTS_INDEX_ALIAS).privileges("read", "view_index_metadata", "write").build()}, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("all").build()}, null, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    private static RoleDescriptor kibanaAdminUser(String name, Map<String, Object> metadata) {
        return new RoleDescriptor(name, null, null, new RoleDescriptor.ApplicationResourcePrivileges[]{RoleDescriptor.ApplicationResourcePrivileges.builder().application("kibana-.kibana").resources("*").privileges("all").build()}, null, null, metadata, null);
    }

    public static RoleDescriptor kibanaSystemRoleDescriptor(String name) {
        return new RoleDescriptor(name, new String[]{"monitor", "manage_index_templates", "cluster:admin/xpack/monitoring/bulk", "manage_saml", "manage_token", "manage_oidc", "manage_pipeline", "manage_ilm", "manage_transform", "cluster:admin/xpack/security/api_key/invalidate", "grant_api_key", "manage_own_api_key", "cluster:admin/xpack/security/privilege/builtin/get", "delegate_pki", "manage_ml", "cluster:admin/analyze", "monitor_text_structure", "cancel_task"}, new RoleDescriptor.IndicesPrivileges[]{RoleDescriptor.IndicesPrivileges.builder().indices(".kibana*", ".reporting-*").privileges("all").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".monitoring-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".management-beats").privileges("create_index", "read", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-anomalies*", ".ml-stats-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".ml-annotations*", ".ml-notifications*").privileges("read", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".apm-agent-configuration").privileges("all").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices(".apm-custom-link").privileges("all").allowRestrictedIndices(true).build(), RoleDescriptor.IndicesPrivileges.builder().indices("apm-*").privileges("read", "read_cross_cluster").build(), RoleDescriptor.IndicesPrivileges.builder().indices("*").privileges("view_index_metadata", "monitor").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".logs-endpoint.diagnostic.collection-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".fleet*").allowRestrictedIndices(true).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_LEGACY_INDEX).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_BACKING_INDEX).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(ALERTS_INDEX_ALIAS).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(PREVIEW_ALERTS_INDEX_ALIAS).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices(PREVIEW_ALERTS_BACKING_INDEX_ALIAS).privileges("all").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-endpoint.policy-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-endpoint.metrics-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices("logs-*", "synthetics-*", "traces-*", "/metrics-.*&~(metrics-endpoint\\.metadata_current_default)/", ".logs-endpoint.action.responses-*", ".logs-endpoint.diagnostic.collection-*", ".logs-endpoint.actions-*").privileges("indices:admin/settings/update", "indices:admin/mapping/put", "indices:admin/rollover").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".logs-endpoint.action.responses-*").privileges("read").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".logs-endpoint.actions-*").privileges("auto_configure", "read", "write").build(), RoleDescriptor.IndicesPrivileges.builder().indices(".logs-endpoint.diagnostic.collection-*", "traces-apm.sampled-*").privileges("indices:admin/delete").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-endpoint.metadata*").privileges("read", "view_index_metadata").build(), RoleDescriptor.IndicesPrivileges.builder().indices("metrics-endpoint.metadata_current_default", ".metrics-endpoint.metadata_current_default", ".metrics-endpoint.metadata_united_default").privileges("create_index", "delete_index", "read", "index").build()}, null, new ConfigurableClusterPrivilege[]{new ConfigurableClusterPrivileges.ManageApplicationPrivileges(Collections.singleton("kibana-*"))}, null, MetadataUtils.DEFAULT_RESERVED_METADATA, null);
    }

    public static boolean isReserved(String role) {
        return RESERVED_ROLES.containsKey(role) || "_system".equals(role) || "_xpack".equals(role) || "_async_search".equals(role);
    }

    public Map<String, Object> usageStats() {
        return Collections.emptyMap();
    }

    public RoleDescriptor roleDescriptor(String role) {
        return RESERVED_ROLES.get(role);
    }

    public Collection<RoleDescriptor> roleDescriptors() {
        return RESERVED_ROLES.values();
    }

    public static Set<String> names() {
        return RESERVED_ROLES.keySet();
    }

    @Override
    public void accept(Set<String> roleNames, ActionListener<RoleRetrievalResult> listener) {
        Set<RoleDescriptor> descriptors = roleNames.stream().map(RESERVED_ROLES::get).filter(Objects::nonNull).collect(Collectors.toSet());
        listener.onResponse((Object)RoleRetrievalResult.success(descriptors));
    }

    public String toString() {
        return "reserved roles store";
    }
}

