/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;

public class GetServiceAccountCredentialsNodesResponse
extends BaseNodesResponse<Node> {
    public GetServiceAccountCredentialsNodesResponse(ClusterName clusterName, List<Node> nodes, List<FailedNodeException> failures) {
        super(clusterName, nodes, failures);
    }

    public GetServiceAccountCredentialsNodesResponse(StreamInput in) throws IOException {
        super(in);
    }

    protected List<Node> readNodesFrom(StreamInput in) throws IOException {
        return in.readList(Node::new);
    }

    protected void writeNodesTo(StreamOutput out, List<Node> nodes) throws IOException {
        out.writeList(nodes);
    }

    public List<TokenInfo> getFileTokenInfos() {
        HashMap fileTokenDistribution = new HashMap();
        for (Node node : this.getNodes()) {
            if (node.fileTokenNames == null) continue;
            Arrays.stream(node.fileTokenNames).forEach(name -> {
                Set distribution = fileTokenDistribution.computeIfAbsent(name, k -> new HashSet());
                distribution.add(node.getNode().getName());
            });
        }
        return fileTokenDistribution.entrySet().stream().map(entry -> TokenInfo.fileToken((String)entry.getKey(), ((Set)entry.getValue()).stream().sorted().collect(Collectors.toUnmodifiableList()))).collect(Collectors.toUnmodifiableList());
    }

    public static class Node
    extends BaseNodeResponse {
        public final String[] fileTokenNames;

        public Node(StreamInput in) throws IOException {
            super(in);
            this.fileTokenNames = in.readStringArray();
        }

        public Node(DiscoveryNode node, String[] fileTokenNames) {
            super(node);
            this.fileTokenNames = fileTokenNames;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.fileTokenNames);
        }
    }
}

