/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.enrollment;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class NodeEnrollmentResponse
extends ActionResponse
implements ToXContentObject {
    private static final ParseField HTTP_CA_KEY = new ParseField("http_ca_key", new String[0]);
    private static final ParseField HTTP_CA_CERT = new ParseField("http_ca_cert", new String[0]);
    private static final ParseField TRANSPORT_KEY = new ParseField("transport_key", new String[0]);
    private static final ParseField TRANSPORT_CERT = new ParseField("transport_cert", new String[0]);
    private static final ParseField TRANSPORT_CA_CERT = new ParseField("transport_ca_cert", new String[0]);
    private static final ParseField NODES_ADDRESSES = new ParseField("nodes_addresses", new String[0]);
    private final String httpCaKey;
    private final String httpCaCert;
    private final String transportCaCert;
    private final String transportKey;
    private final String transportCert;
    private final List<String> nodesAddresses;

    public NodeEnrollmentResponse(StreamInput in) throws IOException {
        super(in);
        this.httpCaKey = in.readString();
        this.httpCaCert = in.readString();
        this.transportCaCert = in.readString();
        this.transportKey = in.readString();
        this.transportCert = in.readString();
        this.nodesAddresses = in.readStringList();
    }

    public NodeEnrollmentResponse(String httpCaKey, String httpCaCert, String transportCaCert, String transportKey, String transportCert, List<String> nodesAddresses) {
        this.httpCaKey = httpCaKey;
        this.httpCaCert = httpCaCert;
        this.transportCaCert = transportCaCert;
        this.transportKey = transportKey;
        this.transportCert = transportCert;
        this.nodesAddresses = nodesAddresses;
    }

    public String getHttpCaKey() {
        return this.httpCaKey;
    }

    public String getHttpCaCert() {
        return this.httpCaCert;
    }

    public String getTransportCaCert() {
        return this.transportCaCert;
    }

    public String getTransportKey() {
        return this.transportKey;
    }

    public String getTransportCert() {
        return this.transportCert;
    }

    public List<String> getNodesAddresses() {
        return this.nodesAddresses;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.httpCaKey);
        out.writeString(this.httpCaCert);
        out.writeString(this.transportCaCert);
        out.writeString(this.transportKey);
        out.writeString(this.transportCert);
        out.writeStringCollection(this.nodesAddresses);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(HTTP_CA_KEY.getPreferredName(), this.httpCaKey);
        builder.field(HTTP_CA_CERT.getPreferredName(), this.httpCaCert);
        builder.field(TRANSPORT_CA_CERT.getPreferredName(), this.transportCaCert);
        builder.field(TRANSPORT_KEY.getPreferredName(), this.transportKey);
        builder.field(TRANSPORT_CERT.getPreferredName(), this.transportCert);
        builder.field(NODES_ADDRESSES.getPreferredName(), this.nodesAddresses);
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        NodeEnrollmentResponse that = (NodeEnrollmentResponse)((Object)o);
        return this.httpCaKey.equals(that.httpCaKey) && this.httpCaCert.equals(that.httpCaCert) && this.transportCaCert.equals(that.transportCaCert) && this.transportKey.equals(that.transportKey) && this.transportCert.equals(that.transportCert) && this.nodesAddresses.equals(that.nodesAddresses);
    }

    public int hashCode() {
        return Objects.hash(this.httpCaKey, this.httpCaCert, this.transportCaCert, this.transportKey, this.transportCert, this.nodesAddresses);
    }
}

