/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class NerResults
extends NlpInferenceResults {
    public static final String NAME = "ner_result";
    public static final String ENTITY_FIELD = "entities";
    private final String resultsField;
    private final String annotatedResult;
    private final List<EntityGroup> entityGroups;

    public NerResults(String resultsField, String annotatedResult, List<EntityGroup> entityGroups, boolean isTruncated) {
        super(isTruncated);
        this.entityGroups = Objects.requireNonNull(entityGroups);
        this.resultsField = Objects.requireNonNull(resultsField);
        this.annotatedResult = Objects.requireNonNull(annotatedResult);
    }

    public NerResults(StreamInput in) throws IOException {
        super(in);
        this.entityGroups = in.readList(EntityGroup::new);
        this.resultsField = in.readString();
        this.annotatedResult = in.readString();
    }

    @Override
    void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.annotatedResult);
        builder.startArray(ENTITY_FIELD);
        for (EntityGroup entity : this.entityGroups) {
            entity.toXContent(builder, params);
        }
        builder.endArray();
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    void doWriteTo(StreamOutput out) throws IOException {
        out.writeList(this.entityGroups);
        out.writeString(this.resultsField);
        out.writeString(this.annotatedResult);
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.annotatedResult);
        map.put(ENTITY_FIELD, this.entityGroups.stream().map(EntityGroup::toMap).collect(Collectors.toList()));
    }

    @Override
    public Object predictedValue() {
        return this.annotatedResult;
    }

    public List<EntityGroup> getEntityGroups() {
        return this.entityGroups;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    public String getAnnotatedResult() {
        return this.annotatedResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NerResults that = (NerResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.annotatedResult, that.annotatedResult) && Objects.equals(this.entityGroups, that.entityGroups);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.annotatedResult, this.entityGroups);
    }

    public static class EntityGroup
    implements ToXContentObject,
    Writeable {
        static final String CLASS_NAME = "class_name";
        static final String CLASS_PROBABILITY = "class_probability";
        static final String START_POS = "start_pos";
        static final String END_POS = "end_pos";
        private final String entity;
        private final String className;
        private final double classProbability;
        private final int startPos;
        private final int endPos;

        public EntityGroup(String entity, String className, double classProbability, int startPos, int endPos) {
            this.entity = entity;
            this.className = className;
            this.classProbability = classProbability;
            this.startPos = startPos;
            this.endPos = endPos;
            if (endPos < startPos) {
                throw new IllegalArgumentException("end_pos [" + endPos + "] less than start_pos [" + startPos + "]");
            }
        }

        public EntityGroup(StreamInput in) throws IOException {
            this.entity = in.readString();
            this.className = in.readString();
            this.classProbability = in.readDouble();
            this.startPos = in.readInt();
            this.endPos = in.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.entity);
            out.writeString(this.className);
            out.writeDouble(this.classProbability);
            out.writeInt(this.startPos);
            out.writeInt(this.endPos);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("entity", this.entity);
            builder.field(CLASS_NAME, this.className);
            builder.field(CLASS_PROBABILITY, this.classProbability);
            if (this.startPos >= 0) {
                builder.field(START_POS, this.startPos);
            }
            if (this.endPos >= 0) {
                builder.field(END_POS, this.endPos);
            }
            builder.endObject();
            return builder;
        }

        public Map<String, Object> toMap() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("entity", this.entity);
            map.put(CLASS_NAME, this.className);
            map.put(CLASS_PROBABILITY, this.classProbability);
            if (this.startPos >= 0) {
                map.put(START_POS, this.startPos);
            }
            if (this.endPos >= 0) {
                map.put(END_POS, this.endPos);
            }
            return map;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getClassName() {
            return this.className;
        }

        public double getClassProbability() {
            return this.classProbability;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EntityGroup that = (EntityGroup)o;
            return Double.compare(that.classProbability, this.classProbability) == 0 && this.startPos == that.startPos && this.endPos == that.endPos && Objects.equals(this.entity, that.entity) && Objects.equals(this.className, that.className);
        }

        public int hashCode() {
            return Objects.hash(this.entity, this.className, this.classProbability, this.startPos, this.endPos);
        }
    }
}

