/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.allocation;

import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.common.time.TimeUtils;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationState;
import org.elasticsearch.xpack.core.ml.inference.allocation.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.allocation.RoutingStateAndReason;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class TrainedModelAllocation
extends AbstractDiffable<TrainedModelAllocation>
implements Diffable<TrainedModelAllocation>,
ToXContentObject {
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField ALLOCATION_STATE = new ParseField("allocation_state", new String[0]);
    private static final ParseField ROUTING_TABLE = new ParseField("routing_table", new String[0]);
    private static final ParseField TASK_PARAMETERS = new ParseField("task_parameters", new String[0]);
    private static final ParseField START_TIME = new ParseField("start_time", new String[0]);
    private static final ConstructingObjectParser<TrainedModelAllocation, Void> PARSER = new ConstructingObjectParser("trained_model_allocation", true, a -> new TrainedModelAllocation((StartTrainedModelDeploymentAction.TaskParams)a[0], (Map)a[1], AllocationState.fromString((String)a[2]), (String)a[3], (Instant)a[4]));
    private final StartTrainedModelDeploymentAction.TaskParams taskParams;
    private final Map<String, RoutingStateAndReason> nodeRoutingTable;
    private final AllocationState allocationState;
    private final String reason;
    private final Instant startTime;

    public static TrainedModelAllocation fromXContent(XContentParser parser) throws IOException {
        return (TrainedModelAllocation)((Object)PARSER.apply(parser, null));
    }

    TrainedModelAllocation(StartTrainedModelDeploymentAction.TaskParams taskParams, Map<String, RoutingStateAndReason> nodeRoutingTable, AllocationState allocationState, String reason, Instant startTime) {
        this.taskParams = ExceptionsHelper.requireNonNull(taskParams, TASK_PARAMETERS);
        this.nodeRoutingTable = ExceptionsHelper.requireNonNull(nodeRoutingTable, ROUTING_TABLE);
        this.allocationState = ExceptionsHelper.requireNonNull(allocationState, ALLOCATION_STATE);
        this.reason = reason;
        this.startTime = ExceptionsHelper.requireNonNull(startTime, START_TIME);
    }

    public TrainedModelAllocation(StreamInput in) throws IOException {
        this.taskParams = new StartTrainedModelDeploymentAction.TaskParams(in);
        this.nodeRoutingTable = in.readOrderedMap(StreamInput::readString, RoutingStateAndReason::new);
        this.allocationState = (AllocationState)in.readEnum(AllocationState.class);
        this.reason = in.readOptionalString();
        this.startTime = in.readInstant();
    }

    public boolean isRoutedToNode(String nodeId) {
        return this.nodeRoutingTable.containsKey(nodeId);
    }

    public Map<String, RoutingStateAndReason> getNodeRoutingTable() {
        return Collections.unmodifiableMap(this.nodeRoutingTable);
    }

    public String getModelId() {
        return this.taskParams.getModelId();
    }

    public StartTrainedModelDeploymentAction.TaskParams getTaskParams() {
        return this.taskParams;
    }

    public AllocationState getAllocationState() {
        return this.allocationState;
    }

    public String[] getStartedNodes() {
        return (String[])this.nodeRoutingTable.entrySet().stream().filter(entry -> RoutingState.STARTED.equals(((RoutingStateAndReason)entry.getValue()).getState())).map(Map.Entry::getKey).toArray(String[]::new);
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason);
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TrainedModelAllocation that = (TrainedModelAllocation)((Object)o);
        return Objects.equals(this.nodeRoutingTable, that.nodeRoutingTable) && Objects.equals(this.taskParams, that.taskParams) && Objects.equals(this.reason, that.reason) && Objects.equals((Object)this.allocationState, (Object)that.allocationState) && Objects.equals(this.startTime, that.startTime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeRoutingTable, this.taskParams, this.allocationState, this.reason, this.startTime});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TASK_PARAMETERS.getPreferredName(), (ToXContent)this.taskParams);
        builder.field(ROUTING_TABLE.getPreferredName(), this.nodeRoutingTable);
        builder.field(ALLOCATION_STATE.getPreferredName(), (Enum)this.allocationState);
        if (this.reason != null) {
            builder.field(REASON.getPreferredName(), this.reason);
        }
        builder.timeField(START_TIME.getPreferredName(), (Object)this.startTime);
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.taskParams.writeTo(out);
        out.writeMap(this.nodeRoutingTable, StreamOutput::writeString, (o, w) -> w.writeTo(o));
        out.writeEnum((Enum)this.allocationState);
        out.writeOptionalString(this.reason);
        out.writeInstant(this.startTime);
    }

    public Optional<AllocationStatus> calculateAllocationStatus(List<DiscoveryNode> allocatableNodes) {
        if (this.allocationState.equals((Object)AllocationState.STOPPING)) {
            return Optional.empty();
        }
        int numAllocatableNodes = 0;
        int numStarted = 0;
        for (DiscoveryNode node : allocatableNodes) {
            if (!StartTrainedModelDeploymentAction.TaskParams.mayAllocateToNode(node)) continue;
            RoutingState nodeState = Optional.ofNullable(this.nodeRoutingTable.get(node.getId())).map(RoutingStateAndReason::getState).orElse(RoutingState.STOPPED);
            ++numAllocatableNodes;
            if (!nodeState.equals(RoutingState.STARTED)) continue;
            ++numStarted;
        }
        return Optional.of(new AllocationStatus(numStarted, numAllocatableNodes));
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> StartTrainedModelDeploymentAction.TaskParams.fromXContent(p), TASK_PARAMETERS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(LinkedHashMap::new, RoutingStateAndReason::fromXContent), ROUTING_TABLE);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ALLOCATION_STATE);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtils.parseTimeFieldToInstant(p, START_TIME.getPreferredName()), START_TIME, ObjectParser.ValueType.VALUE);
    }

    public static class Builder {
        private final Map<String, RoutingStateAndReason> nodeRoutingTable;
        private final StartTrainedModelDeploymentAction.TaskParams taskParams;
        private AllocationState allocationState;
        private boolean isChanged;
        private String reason;
        private Instant startTime;

        public static Builder fromAllocation(TrainedModelAllocation allocation) {
            return new Builder(allocation.taskParams, allocation.nodeRoutingTable, allocation.allocationState, allocation.reason, allocation.startTime);
        }

        public static Builder empty(StartTrainedModelDeploymentAction.TaskParams taskParams) {
            return new Builder(taskParams);
        }

        private Builder(StartTrainedModelDeploymentAction.TaskParams taskParams, Map<String, RoutingStateAndReason> nodeRoutingTable, AllocationState allocationState, String reason, Instant startTime) {
            this.taskParams = taskParams;
            this.nodeRoutingTable = new LinkedHashMap<String, RoutingStateAndReason>(nodeRoutingTable);
            this.allocationState = allocationState;
            this.reason = reason;
            this.startTime = startTime;
        }

        private Builder(StartTrainedModelDeploymentAction.TaskParams taskParams) {
            this(taskParams, new LinkedHashMap<String, RoutingStateAndReason>(), AllocationState.STARTING, null, Instant.now());
        }

        public Builder addNewRoutingEntry(String nodeId) {
            if (this.nodeRoutingTable.containsKey(nodeId)) {
                throw new ResourceAlreadyExistsException("routing entry for node [{}] for model [{}] already exists", new Object[]{nodeId, this.taskParams.getModelId()});
            }
            this.isChanged = true;
            this.nodeRoutingTable.put(nodeId, new RoutingStateAndReason(RoutingState.STARTING, ""));
            return this;
        }

        Builder addRoutingEntry(String nodeId, RoutingState state) {
            this.nodeRoutingTable.put(nodeId, new RoutingStateAndReason(state, ""));
            return this;
        }

        public Builder addNewFailedRoutingEntry(String nodeId, String failureReason) {
            if (this.nodeRoutingTable.containsKey(nodeId)) {
                throw new ResourceAlreadyExistsException("routing entry for node [{}] for model [{}] already exists", new Object[]{nodeId, this.taskParams.getModelId()});
            }
            this.isChanged = true;
            this.nodeRoutingTable.put(nodeId, new RoutingStateAndReason(RoutingState.FAILED, failureReason));
            return this;
        }

        public Builder updateExistingRoutingEntry(String nodeId, RoutingStateAndReason state) {
            RoutingStateAndReason stateAndReason = this.nodeRoutingTable.get(nodeId);
            if (stateAndReason == null) {
                throw new ResourceNotFoundException("routing entry for node [{}] for model [{}] does not exist", new Object[]{nodeId, this.taskParams.getModelId()});
            }
            if (stateAndReason.equals(state)) {
                return this;
            }
            this.nodeRoutingTable.put(nodeId, state);
            this.isChanged = true;
            return this;
        }

        public Builder removeRoutingEntry(String nodeId) {
            if (this.nodeRoutingTable.remove(nodeId) != null) {
                this.isChanged = true;
            }
            return this;
        }

        public Builder setReason(String reason) {
            if (Objects.equals(reason, this.reason)) {
                return this;
            }
            this.isChanged = true;
            this.reason = reason;
            return this;
        }

        public Builder stopAllocation(String stopReason) {
            if (this.allocationState.equals((Object)AllocationState.STOPPING)) {
                return this;
            }
            this.isChanged = true;
            this.reason = stopReason;
            this.allocationState = AllocationState.STOPPING;
            return this;
        }

        public AllocationState calculateAllocationState() {
            if (this.allocationState.equals((Object)AllocationState.STOPPING)) {
                return this.allocationState;
            }
            if (this.nodeRoutingTable.values().stream().anyMatch(r -> r.getState().equals(RoutingState.STARTED))) {
                return AllocationState.STARTED;
            }
            return AllocationState.STARTING;
        }

        public Builder calculateAndSetAllocationState() {
            return this.setAllocationState(this.calculateAllocationState());
        }

        public Builder setAllocationState(AllocationState state) {
            if (this.allocationState.equals((Object)AllocationState.STOPPING)) {
                return this;
            }
            if (this.allocationState.equals((Object)state)) {
                return this;
            }
            this.isChanged = true;
            this.allocationState = state;
            return this;
        }

        public Builder clearReason() {
            if (this.reason == null) {
                return this;
            }
            this.isChanged = true;
            this.reason = null;
            return this;
        }

        public boolean isChanged() {
            return this.isChanged;
        }

        public TrainedModelAllocation build() {
            return new TrainedModelAllocation(this.taskParams, this.nodeRoutingTable, this.allocationState, this.reason, this.startTime);
        }
    }
}

