/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.EmptyConfigUpdate;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfigUpdate;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class InferTrainedModelDeploymentAction
extends ActionType<Response> {
    public static final InferTrainedModelDeploymentAction INSTANCE = new InferTrainedModelDeploymentAction();
    public static final String NAME = "cluster:monitor/xpack/ml/trained_models/deployment/infer";

    public InferTrainedModelDeploymentAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private final InferenceResults results;

        public Response(InferenceResults result) {
            super(Collections.emptyList(), Collections.emptyList());
            this.results = Objects.requireNonNull(result);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.results = (InferenceResults)in.readNamedWriteable(InferenceResults.class);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.results.toXContent(builder, params);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeNamedWriteable((NamedWriteable)this.results);
        }

        public InferenceResults getResults() {
            return this.results;
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        public static final ParseField DEPLOYMENT_ID = new ParseField("deployment_id", new String[0]);
        public static final ParseField DOCS = new ParseField("docs", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ParseField INFERENCE_CONFIG = new ParseField("inference_config", new String[0]);
        public static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds((long)10L);
        static final ObjectParser<Builder, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/trained_models/deployment/infer", Builder::new);
        private final String deploymentId;
        private final List<Map<String, Object>> docs;
        private final InferenceConfigUpdate update;
        private final TimeValue inferenceTimeout;

        public static Builder parseRequest(String deploymentId, XContentParser parser) {
            Builder builder = (Builder)PARSER.apply(parser, null);
            if (deploymentId != null) {
                builder.setDeploymentId(deploymentId);
            }
            return builder;
        }

        public Request(String deploymentId, InferenceConfigUpdate update, List<Map<String, Object>> docs, TimeValue inferenceTimeout) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, DEPLOYMENT_ID);
            this.docs = ExceptionsHelper.requireNonNull(Collections.unmodifiableList(docs), DOCS);
            this.update = update;
            this.inferenceTimeout = inferenceTimeout;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.deploymentId = in.readString();
            this.docs = Collections.unmodifiableList(in.readList(StreamInput::readMap));
            this.update = (InferenceConfigUpdate)in.readOptionalNamedWriteable(InferenceConfigUpdate.class);
            this.inferenceTimeout = in.readOptionalTimeValue();
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public List<Map<String, Object>> getDocs() {
            return this.docs;
        }

        public InferenceConfigUpdate getUpdate() {
            return Optional.ofNullable(this.update).orElse(new EmptyConfigUpdate());
        }

        public TimeValue getInferenceTimeout() {
            return this.inferenceTimeout == null ? DEFAULT_TIMEOUT : this.inferenceTimeout;
        }

        @Nullable
        public TimeValue getTimeout() {
            return null;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = super.validate();
            if (this.docs == null) {
                validationException = ValidateActions.addValidationError((String)("[" + DOCS.getPreferredName() + "] must not be null"), (ActionRequestValidationException)validationException);
            } else {
                if (this.docs.isEmpty()) {
                    validationException = ValidateActions.addValidationError((String)"at least one document is required", (ActionRequestValidationException)validationException);
                }
                if (this.docs.size() > 1) {
                    validationException = ValidateActions.addValidationError((String)"multiple documents are not supported", (ActionRequestValidationException)validationException);
                }
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.deploymentId);
            out.writeCollection(this.docs, StreamOutput::writeMap);
            out.writeOptionalNamedWriteable((NamedWriteable)this.update);
            out.writeOptionalTimeValue(this.inferenceTimeout);
        }

        public boolean match(Task task) {
            return StartTrainedModelDeploymentAction.TaskMatcher.match(task, this.deploymentId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)((Object)o);
            return Objects.equals(this.deploymentId, that.deploymentId) && Objects.equals(this.docs, that.docs) && Objects.equals(this.update, that.update) && Objects.equals(this.inferenceTimeout, that.inferenceTimeout);
        }

        public int hashCode() {
            return Objects.hash(this.deploymentId, this.update, this.docs, this.inferenceTimeout);
        }

        static {
            PARSER.declareString(Builder::setDeploymentId, DEPLOYMENT_ID);
            PARSER.declareObjectArray(Builder::setDocs, (p, c) -> p.mapOrdered(), DOCS);
            PARSER.declareString(Builder::setInferenceTimeout, TIMEOUT);
            PARSER.declareNamedObject(Builder::setUpdate, (p, c, name) -> (InferenceConfigUpdate)p.namedObject(InferenceConfigUpdate.class, name, c), INFERENCE_CONFIG);
        }

        public static class Builder {
            private String deploymentId;
            private List<Map<String, Object>> docs;
            private TimeValue timeout;
            private InferenceConfigUpdate update;

            private Builder() {
            }

            public Builder setDeploymentId(String deploymentId) {
                this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, DEPLOYMENT_ID);
                return this;
            }

            public Builder setDocs(List<Map<String, Object>> docs) {
                this.docs = ExceptionsHelper.requireNonNull(docs, DOCS);
                return this;
            }

            public Builder setInferenceTimeout(TimeValue inferenceTimeout) {
                this.timeout = inferenceTimeout;
                return this;
            }

            public Builder setUpdate(InferenceConfigUpdate update) {
                this.update = update;
                return this;
            }

            private Builder setInferenceTimeout(String inferenceTimeout) {
                return this.setInferenceTimeout(TimeValue.parseTimeValue((String)inferenceTimeout, (String)TIMEOUT.getPreferredName()));
            }

            public Request build() {
                return new Request(this.deploymentId, this.update, this.docs, this.timeout);
            }
        }
    }
}

