/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.job.config.Job;

public class DeleteExpiredDataAction
extends ActionType<Response> {
    public static final DeleteExpiredDataAction INSTANCE = new DeleteExpiredDataAction();
    public static final String NAME = "cluster:admin/xpack/ml/delete_expired_data";

    private DeleteExpiredDataAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private static final ParseField DELETED = new ParseField("deleted", new String[0]);
        private final boolean deleted;

        public Response(boolean deleted) {
            this.deleted = deleted;
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.deleted = in.readBoolean();
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.deleted);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(DELETED.getPreferredName(), this.deleted);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.deleted, response.deleted);
        }

        public int hashCode() {
            return Objects.hash(this.deleted);
        }
    }

    public static class Request
    extends ActionRequest {
        public static final ParseField REQUESTS_PER_SECOND = new ParseField("requests_per_second", new String[0]);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("delete_expired_data_request", false, Request::new);
        private Float requestsPerSecond;
        private TimeValue timeout;
        private String jobId;
        private String[] expandedJobIds;

        public static Request parseRequest(String jobId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (jobId != null) {
                request.jobId = jobId;
            }
            return request;
        }

        public Request() {
        }

        public Request(Float requestsPerSecond, TimeValue timeValue) {
            this.requestsPerSecond = requestsPerSecond;
            this.timeout = timeValue;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.requestsPerSecond = in.readOptionalFloat();
            this.timeout = in.readOptionalTimeValue();
            this.jobId = in.readOptionalString();
        }

        public Float getRequestsPerSecond() {
            return this.requestsPerSecond;
        }

        public TimeValue getTimeout() {
            return this.timeout;
        }

        public String getJobId() {
            return this.jobId;
        }

        public Request setRequestsPerSecond(Float requestsPerSecond) {
            this.requestsPerSecond = requestsPerSecond;
            return this;
        }

        public Request setTimeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public Request setJobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public String[] getExpandedJobIds() {
            return this.expandedJobIds;
        }

        public void setExpandedJobIds(String[] expandedJobIds) {
            this.expandedJobIds = expandedJobIds;
        }

        public ActionRequestValidationException validate() {
            if (this.requestsPerSecond != null && this.requestsPerSecond.floatValue() != -1.0f && this.requestsPerSecond.floatValue() <= 0.0f) {
                ActionRequestValidationException requestValidationException = new ActionRequestValidationException();
                requestValidationException.addValidationError("[requests_per_second] must either be -1 or greater than 0");
                return requestValidationException;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.requestsPerSecond, request.requestsPerSecond) && Objects.equals(this.jobId, request.jobId) && Objects.equals(this.expandedJobIds, request.expandedJobIds) && Objects.equals(this.timeout, request.timeout);
        }

        public int hashCode() {
            return Objects.hash(this.requestsPerSecond, this.timeout, this.jobId, this.expandedJobIds);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalFloat(this.requestsPerSecond);
            out.writeOptionalTimeValue(this.timeout);
            out.writeOptionalString(this.jobId);
        }

        static {
            PARSER.declareFloat(Request::setRequestsPerSecond, REQUESTS_PER_SECOND);
            PARSER.declareString((obj, value) -> obj.setTimeout(TimeValue.parseTimeValue((String)value, (String)TIMEOUT.getPreferredName())), TIMEOUT);
            PARSER.declareString(Request::setJobId, Job.ID);
        }
    }
}

