/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class GetDataStreamAction
extends ActionType<Response> {
    public static final GetDataStreamAction INSTANCE = new GetDataStreamAction();
    public static final String NAME = "indices:admin/data_stream/get";

    private GetDataStreamAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        public static final ParseField DATASTREAMS_FIELD = new ParseField("data_streams", new String[0]);
        private final List<DataStreamInfo> dataStreams;

        public Response(List<DataStreamInfo> dataStreams) {
            this.dataStreams = dataStreams;
        }

        public Response(StreamInput in) throws IOException {
            this(in.readList(DataStreamInfo::new));
        }

        public List<DataStreamInfo> getDataStreams() {
            return this.dataStreams;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.dataStreams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.startArray(DATASTREAMS_FIELD.getPreferredName());
            for (DataStreamInfo dataStream : this.dataStreams) {
                dataStream.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return this.dataStreams.equals(response.dataStreams);
        }

        public int hashCode() {
            return Objects.hash(this.dataStreams);
        }

        public static class DataStreamInfo
        extends AbstractDiffable<DataStreamInfo>
        implements ToXContentObject {
            public static final ParseField STATUS_FIELD = new ParseField("status", new String[0]);
            public static final ParseField INDEX_TEMPLATE_FIELD = new ParseField("template", new String[0]);
            public static final ParseField ILM_POLICY_FIELD = new ParseField("ilm_policy", new String[0]);
            public static final ParseField HIDDEN_FIELD = new ParseField("hidden", new String[0]);
            public static final ParseField SYSTEM_FIELD = new ParseField("system", new String[0]);
            public static final ParseField ALLOW_CUSTOM_ROUTING = new ParseField("allow_custom_routing", new String[0]);
            public static final ParseField REPLICATED = new ParseField("replicated", new String[0]);
            DataStream dataStream;
            ClusterHealthStatus dataStreamStatus;
            @Nullable
            String indexTemplate;
            @Nullable
            String ilmPolicyName;

            public DataStreamInfo(DataStream dataStream, ClusterHealthStatus dataStreamStatus, @Nullable String indexTemplate, @Nullable String ilmPolicyName) {
                this.dataStream = dataStream;
                this.dataStreamStatus = dataStreamStatus;
                this.indexTemplate = indexTemplate;
                this.ilmPolicyName = ilmPolicyName;
            }

            public DataStreamInfo(StreamInput in) throws IOException {
                this(new DataStream(in), ClusterHealthStatus.readFrom((StreamInput)in), in.readOptionalString(), in.readOptionalString());
            }

            public DataStream getDataStream() {
                return this.dataStream;
            }

            public ClusterHealthStatus getDataStreamStatus() {
                return this.dataStreamStatus;
            }

            @Nullable
            public String getIndexTemplate() {
                return this.indexTemplate;
            }

            @Nullable
            public String getIlmPolicy() {
                return this.ilmPolicyName;
            }

            public void writeTo(StreamOutput out) throws IOException {
                this.dataStream.writeTo(out);
                this.dataStreamStatus.writeTo(out);
                out.writeOptionalString(this.indexTemplate);
                out.writeOptionalString(this.ilmPolicyName);
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field(DataStream.NAME_FIELD.getPreferredName(), this.dataStream.getName());
                builder.field(DataStream.TIMESTAMP_FIELD_FIELD.getPreferredName(), (ToXContent)this.dataStream.getTimeStampField());
                builder.xContentList(DataStream.INDICES_FIELD.getPreferredName(), (Collection)this.dataStream.getIndices());
                builder.field(DataStream.GENERATION_FIELD.getPreferredName(), this.dataStream.getGeneration());
                if (this.dataStream.getMetadata() != null) {
                    builder.field(DataStream.METADATA_FIELD.getPreferredName(), this.dataStream.getMetadata());
                }
                builder.field(STATUS_FIELD.getPreferredName(), (Enum)this.dataStreamStatus);
                if (this.indexTemplate != null) {
                    builder.field(INDEX_TEMPLATE_FIELD.getPreferredName(), this.indexTemplate);
                }
                if (this.ilmPolicyName != null) {
                    builder.field(ILM_POLICY_FIELD.getPreferredName(), this.ilmPolicyName);
                }
                builder.field(HIDDEN_FIELD.getPreferredName(), this.dataStream.isHidden());
                builder.field(SYSTEM_FIELD.getPreferredName(), this.dataStream.isSystem());
                builder.field(ALLOW_CUSTOM_ROUTING.getPreferredName(), this.dataStream.isAllowCustomRouting());
                builder.field(REPLICATED.getPreferredName(), this.dataStream.isReplicated());
                builder.endObject();
                return builder;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                DataStreamInfo that = (DataStreamInfo)((Object)o);
                return this.dataStream.equals((Object)that.dataStream) && this.dataStreamStatus == that.dataStreamStatus && Objects.equals(this.indexTemplate, that.indexTemplate) && Objects.equals(this.ilmPolicyName, that.ilmPolicyName);
            }

            public int hashCode() {
                return Objects.hash(this.dataStream, this.dataStreamStatus, this.indexTemplate, this.ilmPolicyName);
            }
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private String[] names;
        private IndicesOptions indicesOptions = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false);

        public Request(String[] names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.names = in.readOptionalStringArray();
            this.indicesOptions = IndicesOptions.readIndicesOptions((StreamInput)in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalStringArray(this.names);
            this.indicesOptions.writeIndicesOptions(out);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.names, request.names) && this.indicesOptions.equals((Object)request.indicesOptions);
        }

        public int hashCode() {
            int result = Objects.hash(this.indicesOptions);
            result = 31 * result + Arrays.hashCode(this.names);
            return result;
        }

        public String[] indices() {
            return this.names;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public Request indicesOptions(IndicesOptions indicesOptions) {
            this.indicesOptions = indicesOptions;
            return this;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public IndicesRequest indices(String ... indices) {
            this.names = indices;
            return this;
        }
    }
}

