/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.repository;

import com.carrotsearch.hppc.cursors.IntObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.ListenerTimeouts;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.seqno.RetentionLeaseInvalidRetainingSeqNoException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.IndexShardRecoveryException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetadata;
import org.elasticsearch.indices.recovery.MultiChunkTransfer;
import org.elasticsearch.indices.recovery.MultiFileWriter;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.GetSnapshotInfoContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrRetentionLeases;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.CcrRequests;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.ClearCcrRestoreSessionRequest;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkAction;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkRequest;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutCcrRestoreSessionRequest;

public class CcrRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(CcrRepository.class);
    public static final String LATEST = "_latest_";
    public static final String TYPE = "_ccr_";
    public static final String NAME_PREFIX = "_ccr_";
    private static final SnapshotId SNAPSHOT_ID = new SnapshotId("_latest_", "_latest_");
    private static final String IN_SYNC_ALLOCATION_ID = "ccr_restore";
    private final RepositoryMetadata metadata;
    private final CcrSettings ccrSettings;
    private final String localClusterName;
    private final String remoteClusterAlias;
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final ThreadPool threadPool;
    private final CounterMetric throttledTime = new CounterMetric();
    private static final ShardGeneration DUMMY_GENERATION = new ShardGeneration("");

    public CcrRepository(RepositoryMetadata metadata, Client client, CcrLicenseChecker ccrLicenseChecker, Settings settings, CcrSettings ccrSettings, ThreadPool threadPool) {
        this.metadata = metadata;
        this.ccrSettings = ccrSettings;
        this.localClusterName = ((ClusterName)ClusterName.CLUSTER_NAME_SETTING.get(settings)).value();
        assert (metadata.name().startsWith("_ccr_")) : "CcrRepository metadata.name() must start with: _ccr_";
        this.remoteClusterAlias = Strings.split((String)metadata.name(), (String)"_ccr_")[1];
        this.ccrLicenseChecker = ccrLicenseChecker;
        this.client = client;
        this.threadPool = threadPool;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    public RepositoryMetadata getMetadata() {
        return this.metadata;
    }

    private Client getRemoteClusterClient() {
        return this.client.getRemoteClusterClient(this.remoteClusterAlias);
    }

    public void getSnapshotInfo(GetSnapshotInfoContext context) {
        List snapshotIds = context.snapshotIds();
        assert (snapshotIds.size() == 1 && SNAPSHOT_ID.equals(snapshotIds.iterator().next())) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId but saw " + snapshotIds;
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetadata(true).setNodes(true).get(this.ccrSettings.getRecoveryActionTimeout());
        Metadata responseMetadata = response.getState().metadata();
        ImmutableOpenMap indicesMap = responseMetadata.indices();
        ArrayList indices = new ArrayList(indicesMap.keySet());
        this.threadPool.executor("snapshot_meta").execute(() -> context.onResponse(new SnapshotInfo(new Snapshot(this.metadata.name(), SNAPSHOT_ID), indices, new ArrayList(responseMetadata.dataStreams().keySet()), Collections.emptyList(), response.getState().getNodes().getMaxNodeVersion(), SnapshotState.SUCCESS)));
    }

    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateRequest clusterStateRequest = CcrRequests.metadataRequest("dummy_index_name");
        ClusterStateResponse clusterState = (ClusterStateResponse)remoteClient.admin().cluster().state(clusterStateRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        return clusterState.getState().metadata();
    }

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        String leaderIndex = index.getName();
        Client remoteClient = this.getRemoteClusterClient();
        ClusterStateRequest clusterStateRequest = CcrRequests.metadataRequest(leaderIndex);
        ClusterStateResponse clusterState = (ClusterStateResponse)remoteClient.admin().cluster().state(clusterStateRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        PlainActionFuture future = PlainActionFuture.newFuture();
        IndexMetadata leaderIndexMetadata = clusterState.getState().metadata().index(leaderIndex);
        this.ccrLicenseChecker.fetchLeaderHistoryUUIDs(remoteClient, leaderIndexMetadata, arg_0 -> ((PlainActionFuture)future).onFailure(arg_0), arg_0 -> ((PlainActionFuture)future).onResponse(arg_0));
        CharSequence[] leaderHistoryUUIDs = (String[])future.actionGet(this.ccrSettings.getRecoveryActionTimeout());
        IndexMetadata.Builder imdBuilder = IndexMetadata.builder((String)leaderIndex);
        HashMap<String, String> customMetadata = new HashMap<String, String>();
        customMetadata.put("leader_index_shard_history_uuids", String.join((CharSequence)",", leaderHistoryUUIDs));
        customMetadata.put("leader_index_uuid", leaderIndexMetadata.getIndexUUID());
        customMetadata.put("leader_index_name", leaderIndexMetadata.getIndex().getName());
        customMetadata.put("remote_cluster_name", this.remoteClusterAlias);
        imdBuilder.putCustom("ccr", customMetadata);
        imdBuilder.settings(leaderIndexMetadata.getSettings());
        imdBuilder.putMapping(leaderIndexMetadata.mapping());
        imdBuilder.setRoutingNumShards(leaderIndexMetadata.getRoutingNumShards());
        for (IntObjectCursor entry : leaderIndexMetadata.getInSyncAllocationIds()) {
            imdBuilder.putInSyncAllocationIds(entry.key, Collections.singleton(IN_SYNC_ALLOCATION_ID));
        }
        return imdBuilder.build();
    }

    public void getRepositoryData(ActionListener<RepositoryData> listener) {
        ActionListener.completeWith(listener, () -> {
            Client remoteClient = this.getRemoteClusterClient();
            ClusterStateResponse response = (ClusterStateResponse)remoteClient.admin().cluster().prepareState().clear().setMetadata(true).get(this.ccrSettings.getRecoveryActionTimeout());
            Metadata remoteMetadata = response.getState().getMetadata();
            HashMap<String, SnapshotId> copiedSnapshotIds = new HashMap<String, SnapshotId>();
            HashMap<String, RepositoryData.SnapshotDetails> snapshotsDetails = new HashMap<String, RepositoryData.SnapshotDetails>(copiedSnapshotIds.size());
            HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>(copiedSnapshotIds.size());
            ImmutableOpenMap remoteIndices = remoteMetadata.getIndices();
            for (String indexName : remoteMetadata.getConcreteAllIndices()) {
                SnapshotId snapshotId = new SnapshotId(LATEST, LATEST);
                copiedSnapshotIds.put(indexName, snapshotId);
                long nowMillis = this.threadPool.absoluteTimeInMillis();
                snapshotsDetails.put(indexName, new RepositoryData.SnapshotDetails(SnapshotState.SUCCESS, Version.CURRENT, nowMillis, nowMillis, ""));
                Index index = ((IndexMetadata)remoteIndices.get((Object)indexName)).getIndex();
                indexSnapshots.put(new IndexId(indexName, index.getUUID()), Collections.singletonList(snapshotId));
            }
            return new RepositoryData("_na_", 1L, copiedSnapshotIds, snapshotsDetails, indexSnapshots, ShardGenerations.EMPTY, IndexMetaDataGenerations.EMPTY, "_na_");
        });
    }

    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryData> listener) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getSnapshotThrottleTimeInNanos() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public long getRestoreThrottleTimeInNanos() {
        return this.throttledTime.count();
    }

    public String startVerification() {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void endVerification(String verificationToken) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void verify(String verificationToken, DiscoveryNode localNode) {
    }

    public boolean isReadOnly() {
        return true;
    }

    public void snapshotShard(SnapshotShardContext context) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void restoreShard(Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        LinkedList<Closeable> toClose = new LinkedList<Closeable>();
        ActionListener restoreListener = ActionListener.runBefore((ActionListener)listener.delegateResponse((l, e) -> l.onFailure((Exception)new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId + "]", (Throwable)e))), () -> IOUtils.close((Iterable)toClose));
        try {
            this.createEmptyStore(store);
            Map ccrMetadata = store.indexSettings().getIndexMetadata().getCustomData("ccr");
            String leaderIndexName = (String)ccrMetadata.get("leader_index_name");
            String leaderUUID = (String)ccrMetadata.get("leader_index_uuid");
            Index leaderIndex = new Index(leaderIndexName, leaderUUID);
            ShardId leaderShardId = new ShardId(leaderIndex, shardId.getId());
            Client remoteClient = this.getRemoteClusterClient();
            String retentionLeaseId = CcrRetentionLeases.retentionLeaseId(this.localClusterName, shardId.getIndex(), this.remoteClusterAlias, leaderIndex);
            this.acquireRetentionLeaseOnLeader(shardId, retentionLeaseId, leaderShardId, remoteClient);
            Scheduler.Cancellable renewable = this.threadPool.scheduleWithFixedDelay(() -> {
                logger.trace("{} background renewal of retention lease [{}] during restore", (Object)shardId, (Object)retentionLeaseId);
                ThreadContext threadContext = this.threadPool.getThreadContext();
                try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                    threadContext.markAsSystemContext();
                    CcrRetentionLeases.asyncRenewRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, (ActionListener<ActionResponse.Empty>)ActionListener.wrap(r -> {}, e -> {
                        Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                        assert (!(cause instanceof ElasticsearchSecurityException)) : cause;
                        if (!(cause instanceof RetentionLeaseInvalidRetainingSeqNoException)) {
                            logger.warn((Message)new ParameterizedMessage("{} background renewal of retention lease [{}] failed during restore", (Object)shardId, (Object)retentionLeaseId), cause);
                        }
                    }));
                }
            }, (TimeValue)CcrRetentionLeases.RETENTION_LEASE_RENEW_INTERVAL_SETTING.get(store.indexSettings().getNodeSettings()), "ccr");
            toClose.add(() -> {
                logger.trace("{} canceling background renewal of retention lease [{}] at the end of restore", (Object)shardId, (Object)retentionLeaseId);
                renewable.cancel();
            });
            RestoreSession restoreSession = this.openSession(this.metadata.name(), remoteClient, leaderShardId, shardId, recoveryState);
            toClose.addFirst(restoreSession);
            restoreSession.restoreFiles(store, (ActionListener<Void>)ActionListener.wrap(v -> {
                logger.trace("[{}] completed CCR restore", (Object)shardId);
                this.updateMappings(remoteClient, leaderIndex, restoreSession.mappingVersion, this.client, shardId.getIndex());
                restoreListener.onResponse(null);
            }, arg_0 -> ((ActionListener)restoreListener).onFailure(arg_0)));
        }
        catch (Exception e2) {
            restoreListener.onFailure(e2);
        }
    }

    private void createEmptyStore(Store store) {
        store.incRef();
        try {
            store.createEmpty();
        }
        catch (IOException | EngineException e) {
            throw new IndexShardRecoveryException(store.shardId(), "failed to create empty store", e);
        }
        finally {
            store.decRef();
        }
    }

    void acquireRetentionLeaseOnLeader(ShardId shardId, String retentionLeaseId, ShardId leaderShardId, Client remoteClient) {
        logger.trace(() -> new ParameterizedMessage("{} requesting leader to add retention lease [{}]", (Object)shardId, (Object)retentionLeaseId));
        TimeValue timeout = this.ccrSettings.getRecoveryActionTimeout();
        Optional<RetentionLeaseAlreadyExistsException> maybeAddAlready = CcrRetentionLeases.syncAddRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
        maybeAddAlready.ifPresent(addAlready -> {
            logger.trace(() -> new ParameterizedMessage("{} retention lease [{}] already exists, requesting a renewal", (Object)shardId, (Object)retentionLeaseId), (Throwable)addAlready);
            Optional<RetentionLeaseNotFoundException> maybeRenewNotFound = CcrRetentionLeases.syncRenewRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
            maybeRenewNotFound.ifPresent(renewNotFound -> {
                logger.trace(() -> new ParameterizedMessage("{} retention lease [{}] not found while attempting to renew, requesting a final add", (Object)shardId, (Object)retentionLeaseId), (Throwable)renewNotFound);
                Optional<RetentionLeaseAlreadyExistsException> maybeFallbackAddAlready = CcrRetentionLeases.syncAddRetentionLease(leaderShardId, retentionLeaseId, -1L, remoteClient, timeout);
                maybeFallbackAddAlready.ifPresent(fallbackAddAlready -> {
                    assert (false) : fallbackAddAlready;
                    throw fallbackAddAlready;
                });
            });
        });
    }

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId index, ShardId shardId) {
        assert (SNAPSHOT_ID.equals((Object)snapshotId)) : "RemoteClusterRepository only supports " + SNAPSHOT_ID + " as the SnapshotId";
        String leaderIndex = index.getName();
        IndicesStatsResponse response = (IndicesStatsResponse)this.getRemoteClusterClient().admin().indices().prepareStats(new String[]{leaderIndex}).clear().setStore(true).get(this.ccrSettings.getRecoveryActionTimeout());
        for (ShardStats shardStats : response.getIndex(leaderIndex).getShards()) {
            ShardRouting shardRouting = shardStats.getShardRouting();
            if (shardRouting.shardId().id() != shardId.getId() || !shardRouting.primary() || !shardRouting.active()) continue;
            long totalSize = shardStats.getStats().getStore().getSizeInBytes();
            return IndexShardSnapshotStatus.newDone((long)0L, (long)0L, (int)1, (int)1, (long)totalSize, (long)totalSize, (ShardGeneration)DUMMY_GENERATION);
        }
        throw new ElasticsearchException("Could not get shard stats for primary of index " + leaderIndex + " on leader cluster", new Object[0]);
    }

    public void updateState(ClusterState state) {
    }

    public void executeConsistentStateUpdate(Function<RepositoryData, ClusterStateUpdateTask> createUpdateTask, String source, Consumer<Exception> onFailure) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId shardId, ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        throw new UnsupportedOperationException("Unsupported for repository of type: _ccr_");
    }

    public void awaitIdle() {
    }

    private void updateMappings(Client leaderClient, Index leaderIndex, long leaderMappingVersion, Client followerClient, Index followerIndex) {
        PlainActionFuture indexMetadataFuture = new PlainActionFuture();
        long startTimeInNanos = System.nanoTime();
        Supplier<TimeValue> timeout = () -> {
            long elapsedInNanos = System.nanoTime() - startTimeInNanos;
            return TimeValue.timeValueNanos((long)(this.ccrSettings.getRecoveryActionTimeout().nanos() - elapsedInNanos));
        };
        CcrRequests.getIndexMetadata(leaderClient, leaderIndex, leaderMappingVersion, 0L, timeout, (ActionListener<IndexMetadata>)indexMetadataFuture);
        IndexMetadata leaderIndexMetadata = (IndexMetadata)indexMetadataFuture.actionGet(this.ccrSettings.getRecoveryActionTimeout());
        MappingMetadata mappingMetadata = leaderIndexMetadata.mapping();
        if (mappingMetadata != null) {
            PutMappingRequest putMappingRequest = CcrRequests.putMappingRequest(followerIndex.getName(), mappingMetadata);
            followerClient.admin().indices().putMapping(putMappingRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        }
    }

    RestoreSession openSession(String repositoryName, Client remoteClient, ShardId leaderShardId, ShardId indexShardId, RecoveryState recoveryState) {
        String sessionUUID = UUIDs.randomBase64UUID();
        PutCcrRestoreSessionAction.PutCcrRestoreSessionResponse response = (PutCcrRestoreSessionAction.PutCcrRestoreSessionResponse)((Object)remoteClient.execute((ActionType)PutCcrRestoreSessionAction.INSTANCE, (ActionRequest)new PutCcrRestoreSessionRequest(sessionUUID, leaderShardId)).actionGet(this.ccrSettings.getRecoveryActionTimeout()));
        return new RestoreSession(repositoryName, remoteClient, sessionUUID, response.getNode(), indexShardId, recoveryState, response.getStoreFileMetadata(), response.getMappingVersion(), this.threadPool, this.ccrSettings, arg_0 -> ((CounterMetric)this.throttledTime).inc(arg_0));
    }

    private static class RestoreSession
    extends FileRestoreContext
    implements Closeable {
        private final Client remoteClient;
        private final String sessionUUID;
        private final DiscoveryNode node;
        private final Store.MetadataSnapshot sourceMetadata;
        private final long mappingVersion;
        private final CcrSettings ccrSettings;
        private final LongConsumer throttleListener;
        private final ThreadPool threadPool;

        RestoreSession(String repositoryName, Client remoteClient, String sessionUUID, DiscoveryNode node, ShardId shardId, RecoveryState recoveryState, Store.MetadataSnapshot sourceMetadata, long mappingVersion, ThreadPool threadPool, CcrSettings ccrSettings, LongConsumer throttleListener) {
            super(repositoryName, shardId, SNAPSHOT_ID, recoveryState);
            this.remoteClient = remoteClient;
            this.sessionUUID = sessionUUID;
            this.node = node;
            this.sourceMetadata = sourceMetadata;
            this.mappingVersion = mappingVersion;
            this.threadPool = threadPool;
            this.ccrSettings = ccrSettings;
            this.throttleListener = throttleListener;
        }

        void restoreFiles(Store store, ActionListener<Void> listener) {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            for (StoreFileMetadata fileMetadata : this.sourceMetadata) {
                ByteSizeValue fileSize = new ByteSizeValue(fileMetadata.length());
                fileInfos.add(new BlobStoreIndexShardSnapshot.FileInfo(fileMetadata.name(), fileMetadata, fileSize));
            }
            SnapshotFiles snapshotFiles = new SnapshotFiles(CcrRepository.LATEST, fileInfos, null);
            this.restore(snapshotFiles, store, listener);
        }

        protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, final Store store, ActionListener<Void> allFilesListener) {
            logger.trace("[{}] starting CCR restore of {} files", (Object)this.shardId, filesToRecover);
            List mds = filesToRecover.stream().map(BlobStoreIndexShardSnapshot.FileInfo::metadata).collect(Collectors.toList());
            MultiChunkTransfer<StoreFileMetadata, FileChunk> multiFileTransfer = new MultiChunkTransfer<StoreFileMetadata, FileChunk>(logger, this.threadPool.getThreadContext(), allFilesListener, this.ccrSettings.getMaxConcurrentFileChunks(), mds){
                final MultiFileWriter multiFileWriter;
                long offset;
                {
                    super(arg0, arg1, arg2, arg3, arg4);
                    this.multiFileWriter = new MultiFileWriter(store, recoveryState.getIndex(), "", logger, () -> {});
                    this.offset = 0L;
                }

                protected void onNewResource(StoreFileMetadata md) {
                    this.offset = 0L;
                }

                protected FileChunk nextChunkRequest(StoreFileMetadata md) {
                    int bytesRequested = Math.toIntExact(Math.min(ccrSettings.getChunkSize().getBytes(), md.length() - this.offset));
                    this.offset += (long)bytesRequested;
                    return new FileChunk(md, bytesRequested, this.offset == md.length());
                }

                protected void executeChunkRequest(final FileChunk request, final ActionListener<Void> listener) {
                    remoteClient.execute((ActionType)GetCcrRestoreFileChunkAction.INSTANCE, (ActionRequest)new GetCcrRestoreFileChunkRequest(node, sessionUUID, request.md.name(), request.bytesRequested), ListenerTimeouts.wrapWithTimeout((ThreadPool)threadPool, (ActionListener)new ActionListener<GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse>(){

                        public void onResponse(final GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse getCcrRestoreFileChunkResponse) {
                            getCcrRestoreFileChunkResponse.incRef();
                            threadPool.generic().execute((Runnable)new ActionRunnable<Void>(listener){

                                protected void doRun() throws Exception {
                                    this.writeFileChunk(request.md, getCcrRestoreFileChunkResponse);
                                    this.listener.onResponse(null);
                                }

                                public void onAfter() {
                                    getCcrRestoreFileChunkResponse.decRef();
                                }
                            });
                        }

                        public void onFailure(Exception e) {
                            threadPool.generic().execute(() -> {
                                try {
                                    listener.onFailure(e);
                                }
                                catch (Exception ex) {
                                    e.addSuppressed(ex);
                                    logger.warn(() -> new ParameterizedMessage("failed to execute failure callback for chunk request", new Object[0]), (Throwable)e);
                                }
                            });
                        }
                    }, (TimeValue)ccrSettings.getRecoveryActionTimeout(), (String)"generic", (String)"internal:admin/ccr/restore/file_chunk/get"));
                }

                private void writeFileChunk(StoreFileMetadata md, GetCcrRestoreFileChunkAction.GetCcrRestoreFileChunkResponse r) throws Exception {
                    int actualChunkSize = r.getChunk().length();
                    logger.trace("[{}] [{}] got response for file [{}], offset: {}, length: {}", (Object)shardId, (Object)snapshotId, (Object)md.name(), (Object)r.getOffset(), (Object)actualChunkSize);
                    long nanosPaused = ccrSettings.getRateLimiter().maybePause(actualChunkSize);
                    throttleListener.accept(nanosPaused);
                    this.multiFileWriter.incRef();
                    try (Releasable ignored = () -> ((MultiFileWriter)this.multiFileWriter).decRef();){
                        boolean lastChunk = r.getOffset() + (long)actualChunkSize >= md.length();
                        this.multiFileWriter.writeFileChunk(md, r.getOffset(), r.getChunk(), lastChunk);
                    }
                    catch (Exception e) {
                        this.handleError(md, e);
                        throw e;
                    }
                }

                protected void handleError(StoreFileMetadata md, Exception e) throws Exception {
                    IOException corruptIndexException = ExceptionsHelper.unwrapCorruption((Throwable)e);
                    if (corruptIndexException != null) {
                        try {
                            store.markStoreCorrupted(corruptIndexException);
                        }
                        catch (IOException ioe) {
                            logger.warn("store cannot be marked as corrupted", (Throwable)e);
                        }
                        throw corruptIndexException;
                    }
                    throw e;
                }

                public void close() {
                    this.multiFileWriter.close();
                }
            };
            multiFileTransfer.start();
        }

        @Override
        public void close() {
            ClearCcrRestoreSessionRequest clearRequest = new ClearCcrRestoreSessionRequest(this.sessionUUID, this.node);
            ActionResponse.Empty response = (ActionResponse.Empty)this.remoteClient.execute((ActionType)ClearCcrRestoreSessionAction.INSTANCE, (ActionRequest)clearRequest).actionGet(this.ccrSettings.getRecoveryActionTimeout());
        }

        private static class FileChunk
        implements MultiChunkTransfer.ChunkRequest {
            final StoreFileMetadata md;
            final int bytesRequested;
            final boolean lastChunk;

            FileChunk(StoreFileMetadata md, int bytesRequested, boolean lastChunk) {
                this.md = md;
                this.bytesRequested = bytesRequested;
                this.lastChunk = lastChunk;
            }

            public boolean lastChunk() {
                return this.lastChunk;
            }
        }
    }
}

