/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshotsUtils;
import org.elasticsearch.xpack.searchablesnapshots.cache.common.ByteRange;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheService;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.SharedBytes;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.MetadataCachingIndexInput;

public class FrozenIndexInput
extends MetadataCachingIndexInput {
    private static final Logger logger = LogManager.getLogger(FrozenIndexInput.class);
    private final FrozenCacheService.FrozenCacheFile frozenCacheFile;
    private static final int MAX_BYTES_PER_WRITE = StrictMath.toIntExact(ByteSizeValue.parseBytesSizeValue((String)System.getProperty("es.searchable.snapshot.shared_cache.write_buffer.size", "2m"), (String)"es.searchable.snapshot.shared_cache.write_buffer.size").getBytes());
    private static final ThreadLocal<ByteBuffer> writeBuffer = ThreadLocal.withInitial(() -> ByteBuffer.allocateDirect(MAX_BYTES_PER_WRITE));

    public FrozenIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, int rangeSize, int recoveryRangeSize) {
        this(name, directory, fileInfo, context, stats, 0L, 0L, fileInfo.length(), new MetadataCachingIndexInput.CacheFileReference(directory, fileInfo.physicalName(), fileInfo.length()), directory.getFrozenCacheFile(name, fileInfo.length()), rangeSize, recoveryRangeSize, directory.getBlobCacheByteRange(name, fileInfo.length()), ByteRange.EMPTY);
        stats.incrementOpenCount();
    }

    private FrozenIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long compoundFileOffset, long length, MetadataCachingIndexInput.CacheFileReference cacheFileReference, FrozenCacheService.FrozenCacheFile frozenCacheFile, int defaultRangeSize, int recoveryRangeSize, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(logger, name, directory, fileInfo, context, stats, offset, compoundFileOffset, length, cacheFileReference, defaultRangeSize, recoveryRangeSize, headerBlobCacheByteRange, footerBlobCacheByteRange);
        this.frozenCacheFile = frozenCacheFile;
    }

    @Override
    protected long getDefaultRangeSize() {
        return this.directory.isRecoveryFinalized() ? (long)this.defaultRangeSize : (long)this.recoveryRangeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readWithoutBlobCache(ByteBuffer b) throws Exception {
        long position = this.getAbsolutePosition();
        int length = b.remaining();
        int originalByteBufPosition = b.position();
        ReentrantReadWriteLock luceneByteBufLock = new ReentrantReadWriteLock();
        AtomicBoolean stopAsyncReads = new AtomicBoolean();
        Runnable preventAsyncBufferChanges = () -> {
            luceneByteBufLock.writeLock().lock();
            try {
                stopAsyncReads.set(true);
            }
            finally {
                luceneByteBufLock.writeLock().unlock();
            }
        };
        logger.trace("readInternal: read [{}-{}] ([{}] bytes) from [{}]", (Object)position, (Object)(position + (long)length), (Object)length, (Object)this);
        try {
            ByteRange startRangeToWrite = this.computeRange(position);
            ByteRange endRangeToWrite = this.computeRange(position + (long)length - 1L);
            assert (startRangeToWrite.end() <= endRangeToWrite.end()) : startRangeToWrite + " vs " + endRangeToWrite;
            ByteRange rangeToWrite = startRangeToWrite.minEnvelope(endRangeToWrite);
            assert (rangeToWrite.start() <= position && position + (long)length <= rangeToWrite.end()) : "[" + position + "-" + (position + (long)length) + "] vs " + rangeToWrite;
            ByteRange rangeToRead = ByteRange.of(position, position + (long)length);
            StepListener<Integer> populateCacheFuture = this.frozenCacheFile.populateAndRead(rangeToWrite, rangeToRead, (channel, pos, relativePos, len) -> this.readCacheFile(channel, pos, relativePos, len, b, rangeToRead.start(), false, luceneByteBufLock, stopAsyncReads), (channel, channelPos, relativePos, len, progressUpdater) -> {
                long startTimeNanos = this.stats.currentTimeNanos();
                long streamStartPosition = rangeToWrite.start() + relativePos;
                try (InputStream input = this.openInputStreamFromBlobStore(streamStartPosition, len);){
                    this.writeCacheFile(channel, input, channelPos, relativePos, len, progressUpdater, startTimeNanos);
                }
            }, this.directory.cacheFetchAsyncExecutor());
            int bytesRead = (Integer)populateCacheFuture.asFuture().get();
            assert (bytesRead == length) : bytesRead + " vs " + length;
            assert (luceneByteBufLock.getReadHoldCount() == 0);
            preventAsyncBufferChanges.run();
            b.position(originalByteBufPosition + bytesRead);
        }
        finally {
            preventAsyncBufferChanges.run();
        }
    }

    private static int positionalWrite(SharedBytes.IO fc, long start, ByteBuffer byteBuffer) throws IOException {
        assert (FrozenIndexInput.assertCurrentThreadMayWriteCacheFile());
        byteBuffer.flip();
        int written = fc.write(byteBuffer, start);
        assert (!byteBuffer.hasRemaining());
        byteBuffer.clear();
        return written;
    }

    private static int readSafe(InputStream inputStream, byte[] copyBuffer, long rangeStart, long rangeEnd, long remaining, FrozenCacheService.FrozenCacheFile frozenCacheFile) throws IOException {
        int len = remaining < (long)copyBuffer.length ? SearchableSnapshotsUtils.toIntBytes(remaining) : copyBuffer.length;
        int bytesRead = inputStream.read(copyBuffer, 0, len);
        if (bytesRead == -1) {
            throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] ([%d] bytes remaining) from %s", rangeStart, rangeEnd, remaining, frozenCacheFile));
        }
        assert (bytesRead > 0) : bytesRead;
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readCacheFile(SharedBytes.IO fc, long channelPos, long relativePos, long length, ByteBuffer buffer, long logicalPos, boolean cached, ReentrantReadWriteLock luceneByteBufLock, AtomicBoolean stopAsyncReads) throws IOException {
        int bytesRead;
        block10: {
            logger.trace("{}: reading cached {} logical {} channel {} pos {} length {} (details: {})", (Object)this.fileInfo.physicalName(), (Object)cached, (Object)logicalPos, (Object)channelPos, (Object)relativePos, (Object)length, (Object)this.frozenCacheFile);
            if (length == 0L) {
                return 0;
            }
            if (luceneByteBufLock.readLock().tryLock()) {
                try {
                    boolean shouldStopReading = stopAsyncReads.get();
                    if (shouldStopReading) {
                        int n = Math.toIntExact(length);
                        return n;
                    }
                    ByteBuffer dup = buffer.duplicate();
                    int newPosition = dup.position() + Math.toIntExact(relativePos);
                    assert (newPosition <= dup.limit()) : "newpos " + newPosition + " limit " + dup.limit();
                    assert ((long)newPosition + length <= (long)buffer.limit()) : "oldpos " + dup.position() + " newpos " + newPosition + " length " + length + " limit " + buffer.limit();
                    dup.position(newPosition);
                    dup.limit(newPosition + Math.toIntExact(length));
                    bytesRead = fc.read(dup, channelPos);
                    if (bytesRead == -1) {
                        throw new EOFException(String.format(Locale.ROOT, "unexpected EOF reading [%d-%d] from %s", channelPos, channelPos + (long)dup.remaining(), this.frozenCacheFile));
                    }
                    break block10;
                }
                finally {
                    luceneByteBufLock.readLock().unlock();
                }
            }
            return Math.toIntExact(length);
        }
        this.stats.addCachedBytesRead(bytesRead);
        return bytesRead;
    }

    private void writeCacheFile(SharedBytes.IO fc, InputStream input, long fileChannelPos, long relativePos, long length, Consumer<Long> progressUpdater, long startTimeNanos) throws IOException {
        long bytesWritten;
        int bytesRead;
        assert (FrozenIndexInput.assertCurrentThreadMayWriteCacheFile());
        logger.trace("{}: writing channel {} pos {} length {} (details: {})", (Object)this.fileInfo.physicalName(), (Object)fileChannelPos, (Object)relativePos, (Object)length, (Object)this.frozenCacheFile);
        long end = relativePos + length;
        byte[] copyBuffer = new byte[SearchableSnapshotsUtils.toIntBytes(Math.min((long)COPY_BUFFER_SIZE, length))];
        logger.trace(() -> new ParameterizedMessage("writing range [{}-{}] to cache file [{}]", new Object[]{relativePos, end, this.frozenCacheFile}));
        long bytesCopied = 0L;
        ByteBuffer buf = writeBuffer.get();
        buf.clear();
        for (long remaining = length; remaining > 0L; remaining -= (long)bytesRead) {
            bytesRead = FrozenIndexInput.readSafe(input, copyBuffer, relativePos, end, remaining, this.frozenCacheFile);
            if (bytesRead > buf.remaining()) {
                int bytesToAdd = buf.remaining();
                buf.put(copyBuffer, 0, bytesToAdd);
                assert (buf.remaining() == 0);
                bytesWritten = FrozenIndexInput.positionalWrite(fc, fileChannelPos + bytesCopied, buf);
                progressUpdater.accept(bytesCopied += bytesWritten);
                buf.put(copyBuffer, bytesToAdd, bytesRead - bytesToAdd);
                continue;
            }
            buf.put(copyBuffer, 0, bytesRead);
        }
        int remainder = buf.position() % SharedBytes.PAGE_SIZE;
        int adjustment = remainder == 0 ? 0 : SharedBytes.PAGE_SIZE - remainder;
        buf.position(buf.position() + adjustment);
        bytesWritten = FrozenIndexInput.positionalWrite(fc, fileChannelPos + bytesCopied, buf);
        long adjustedBytesCopied = (bytesCopied += bytesWritten) - (long)adjustment;
        assert (adjustedBytesCopied == length);
        progressUpdater.accept(adjustedBytesCopied);
        long endTimeNanos = this.stats.currentTimeNanos();
        this.stats.addCachedBytesWritten(adjustedBytesCopied, endTimeNanos - startTimeNanos);
    }

    @Override
    public FrozenIndexInput clone() {
        return (FrozenIndexInput)super.clone();
    }

    public IndexInput slice(String sliceName, long sliceOffset, long sliceLength) {
        ByteRange sliceFooterByteRange;
        ByteRange sliceHeaderByteRange;
        long sliceCompoundFileOffset;
        boolean sliceCompoundFile;
        if (sliceOffset < 0L || sliceLength < 0L || sliceOffset + sliceLength > this.length()) {
            throw new IllegalArgumentException("slice() " + sliceName + " out of bounds: offset=" + sliceOffset + ",length=" + sliceLength + ",fileLength=" + this.length() + ": " + this);
        }
        boolean bl = sliceCompoundFile = IndexFileNames.matchesExtension((String)this.name, (String)"cfs") && IndexFileNames.getExtension((String)sliceName) != null && this.compoundFileOffset == 0L && !this.isClone;
        if (sliceCompoundFile) {
            sliceCompoundFileOffset = this.offset + sliceOffset;
            sliceHeaderByteRange = this.directory.getBlobCacheByteRange(sliceName, sliceLength).shift(sliceCompoundFileOffset);
            sliceFooterByteRange = !sliceHeaderByteRange.isEmpty() && sliceHeaderByteRange.length() < sliceLength ? ByteRange.of(sliceLength - (long)CodecUtil.footerLength(), sliceLength).shift(sliceCompoundFileOffset) : ByteRange.EMPTY;
        } else {
            sliceCompoundFileOffset = this.compoundFileOffset;
            sliceHeaderByteRange = ByteRange.EMPTY;
            sliceFooterByteRange = ByteRange.EMPTY;
        }
        FrozenIndexInput slice = new FrozenIndexInput(sliceName, this.directory, this.fileInfo, this.context, this.stats, this.offset + sliceOffset, sliceCompoundFileOffset, sliceLength, this.cacheFileReference, this.frozenCacheFile, this.defaultRangeSize, this.recoveryRangeSize, sliceHeaderByteRange, sliceFooterByteRange);
        slice.isClone = true;
        return slice;
    }
}

