/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheInfoService;
import org.elasticsearch.xpack.searchablesnapshots.cache.shared.FrozenCacheService;

public class HasFrozenCacheAllocationDecider
extends AllocationDecider {
    private static final String NAME = "has_frozen_cache";
    private static final Decision STILL_FETCHING = Decision.single((Decision.Type)Decision.Type.THROTTLE, (String)"has_frozen_cache", (String)("value of [" + FrozenCacheService.SHARED_CACHE_SIZE_SETTING.getKey() + "] on this node is not known yet"), (Object[])new Object[0]);
    private static final Decision HAS_FROZEN_CACHE = Decision.single((Decision.Type)Decision.Type.YES, (String)"has_frozen_cache", (String)"this node has a frozen searchable snapshot shard cache", (Object[])new Object[0]);
    private static final Decision NO_FROZEN_CACHE = Decision.single((Decision.Type)Decision.Type.NO, (String)"has_frozen_cache", (String)("node setting [" + FrozenCacheService.SHARED_CACHE_SIZE_SETTING.getKey() + "] is set to zero, so frozen searchable snapshot shards cannot be allocated to this node"), (Object[])new Object[0]);
    private static final Decision UNKNOWN_FROZEN_CACHE = Decision.single((Decision.Type)Decision.Type.NO, (String)"has_frozen_cache", (String)"there was an error fetching the frozen cache state from this node", (Object[])new Object[0]);
    private final FrozenCacheInfoService frozenCacheService;

    public HasFrozenCacheAllocationDecider(FrozenCacheInfoService frozenCacheService) {
        this.frozenCacheService = frozenCacheService;
    }

    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(allocation.metadata().getIndexSafe(shardRouting.index()), node.node());
    }

    public Decision canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(allocation.metadata().getIndexSafe(shardRouting.index()), node.node());
    }

    public Decision canAllocate(IndexMetadata indexMetadata, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(indexMetadata, node.node());
    }

    public Decision shouldAutoExpandToNode(IndexMetadata indexMetadata, DiscoveryNode node, RoutingAllocation allocation) {
        return this.canAllocateToNode(indexMetadata, node);
    }

    private Decision canAllocateToNode(IndexMetadata indexMetadata, DiscoveryNode discoveryNode) {
        Settings indexSettings = indexMetadata.getSettings();
        if (!SearchableSnapshotsSettings.isPartialSearchableSnapshotIndex((Settings)indexSettings)) {
            return Decision.ALWAYS;
        }
        switch (this.frozenCacheService.getNodeState(discoveryNode)) {
            case HAS_CACHE: {
                return HAS_FROZEN_CACHE;
            }
            case NO_CACHE: {
                return NO_FROZEN_CACHE;
            }
            case FAILED: {
                return UNKNOWN_FROZEN_CACHE;
            }
        }
        return STILL_FETCHING;
    }
}

