/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.action.cache;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.searchablesnapshots.SearchableSnapshots;
import org.elasticsearch.xpack.searchablesnapshots.cache.full.CacheService;

public class TransportSearchableSnapshotCacheStoresAction
extends TransportNodesAction<Request, NodesCacheFilesMetadata, NodeRequest, NodeCacheFilesMetadata> {
    public static final String ACTION_NAME = "internal:admin/xpack/searchable_snapshots/cache/store";
    public static final ActionType<NodesCacheFilesMetadata> TYPE = new ActionType("internal:admin/xpack/searchable_snapshots/cache/store", NodesCacheFilesMetadata::new);
    private final CacheService cacheService;

    @Inject
    public TransportSearchableSnapshotCacheStoresAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SearchableSnapshots.CacheServiceSupplier cacheService, ActionFilters actionFilters) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "management", "same", NodeCacheFilesMetadata.class);
        this.cacheService = cacheService.get();
    }

    protected NodesCacheFilesMetadata newResponse(Request request, List<NodeCacheFilesMetadata> nodesCacheFilesMetadata, List<FailedNodeException> failures) {
        return new NodesCacheFilesMetadata(this.clusterService.getClusterName(), nodesCacheFilesMetadata, failures);
    }

    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    protected NodeCacheFilesMetadata newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodeCacheFilesMetadata(in);
    }

    protected NodeCacheFilesMetadata nodeOperation(NodeRequest request, Task task) {
        assert (this.cacheService != null);
        assert (!Optional.ofNullable(this.clusterService.state().metadata().index(request.shardId.getIndex())).map(indexMetadata -> (Boolean)SearchableSnapshotsSettings.SNAPSHOT_PARTIAL_SETTING.get(indexMetadata.getSettings())).orElse(false).booleanValue()) : request.shardId + " is partial, should not be fetching its cached size";
        return new NodeCacheFilesMetadata(this.clusterService.localNode(), this.cacheService.getCachedSize(request.shardId, request.snapshotId));
    }

    public static class NodeCacheFilesMetadata
    extends BaseNodeResponse {
        private final long bytesCached;

        public NodeCacheFilesMetadata(StreamInput in) throws IOException {
            super(in);
            this.bytesCached = in.readLong();
        }

        public NodeCacheFilesMetadata(DiscoveryNode node, long bytesCached) {
            super(node);
            this.bytesCached = bytesCached;
        }

        public long bytesCached() {
            return this.bytesCached;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeLong(this.bytesCached);
        }
    }

    public static class NodesCacheFilesMetadata
    extends BaseNodesResponse<NodeCacheFilesMetadata> {
        public NodesCacheFilesMetadata(StreamInput in) throws IOException {
            super(in);
        }

        public NodesCacheFilesMetadata(ClusterName clusterName, List<NodeCacheFilesMetadata> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<NodeCacheFilesMetadata> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeCacheFilesMetadata::new);
        }

        protected void writeNodesTo(StreamOutput out, List<NodeCacheFilesMetadata> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static final class NodeRequest
    extends TransportRequest {
        private final SnapshotId snapshotId;
        private final ShardId shardId;

        public NodeRequest(Request request) {
            this.snapshotId = request.snapshotId;
            this.shardId = request.shardId;
        }

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.snapshotId = new SnapshotId(in);
            this.shardId = new ShardId(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
        }
    }

    public static final class Request
    extends BaseNodesRequest<Request> {
        private final SnapshotId snapshotId;
        private final ShardId shardId;

        public Request(SnapshotId snapshotId, ShardId shardId, DiscoveryNode[] nodes) {
            super(nodes);
            this.snapshotId = snapshotId;
            this.shardId = shardId;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.snapshotId = new SnapshotId(in);
            this.shardId = new ShardId(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.snapshotId.writeTo(out);
            this.shardId.writeTo(out);
        }
    }
}

