/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import javax.mail.internet.AddressException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.watcher.common.text.TextTemplate;
import org.elasticsearch.xpack.watcher.common.text.TextTemplateEngine;
import org.elasticsearch.xpack.watcher.notification.email.Attachment;
import org.elasticsearch.xpack.watcher.notification.email.Email;
import org.elasticsearch.xpack.watcher.notification.email.HtmlSanitizer;

public class EmailTemplate
implements ToXContentObject {
    final TextTemplate from;
    final TextTemplate[] replyTo;
    final TextTemplate priority;
    final TextTemplate[] to;
    final TextTemplate[] cc;
    final TextTemplate[] bcc;
    final TextTemplate subject;
    final TextTemplate textBody;
    final TextTemplate htmlBody;

    public EmailTemplate(TextTemplate from, TextTemplate[] replyTo, TextTemplate priority, TextTemplate[] to, TextTemplate[] cc, TextTemplate[] bcc, TextTemplate subject, TextTemplate textBody, TextTemplate htmlBody) {
        this.from = from;
        this.replyTo = replyTo;
        this.priority = priority;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.textBody = textBody;
        this.htmlBody = htmlBody;
    }

    public TextTemplate from() {
        return this.from;
    }

    public TextTemplate[] replyTo() {
        return this.replyTo;
    }

    public TextTemplate priority() {
        return this.priority;
    }

    public TextTemplate[] to() {
        return this.to;
    }

    public TextTemplate[] cc() {
        return this.cc;
    }

    public TextTemplate[] bcc() {
        return this.bcc;
    }

    public TextTemplate subject() {
        return this.subject;
    }

    public TextTemplate textBody() {
        return this.textBody;
    }

    public TextTemplate htmlBody() {
        return this.htmlBody;
    }

    public Email.Builder render(TextTemplateEngine engine, Map<String, Object> model, HtmlSanitizer htmlSanitizer, Map<String, Attachment> attachments) throws AddressException {
        Email.AddressList addresses;
        Email.Builder builder = Email.builder();
        if (this.from != null) {
            builder.from(engine.render(this.from, model));
        }
        if (this.replyTo != null) {
            addresses = EmailTemplate.templatesToAddressList(engine, this.replyTo, model);
            builder.replyTo(addresses);
        }
        if (this.priority != null) {
            builder.priority(Email.Priority.resolve(engine.render(this.priority, model)));
        }
        if (this.to != null) {
            addresses = EmailTemplate.templatesToAddressList(engine, this.to, model);
            builder.to(addresses);
        }
        if (this.cc != null) {
            addresses = EmailTemplate.templatesToAddressList(engine, this.cc, model);
            builder.cc(addresses);
        }
        if (this.bcc != null) {
            addresses = EmailTemplate.templatesToAddressList(engine, this.bcc, model);
            builder.bcc(addresses);
        }
        if (this.subject != null) {
            builder.subject(engine.render(this.subject, model));
        }
        HashSet<String> warnings = new HashSet<String>(1);
        if (attachments != null) {
            for (Attachment attachment : attachments.values()) {
                builder.attach(attachment);
                warnings.addAll(attachment.getWarnings());
            }
        }
        String htmlWarnings = "";
        String textWarnings = "";
        if (!warnings.isEmpty()) {
            StringBuilder textWarningBuilder = new StringBuilder();
            StringBuilder htmlWarningBuilder = new StringBuilder();
            warnings.forEach(w -> {
                if (!Strings.isNullOrEmpty((String)w)) {
                    textWarningBuilder.append((String)w).append("\n");
                    htmlWarningBuilder.append((String)w).append("<br>");
                }
            });
            textWarningBuilder.append("\n");
            htmlWarningBuilder.append("<br>");
            htmlWarnings = htmlWarningBuilder.toString();
            textWarnings = textWarningBuilder.toString();
        }
        if (this.textBody != null) {
            builder.textBody(textWarnings + engine.render(this.textBody, model));
        }
        if (this.htmlBody != null) {
            Object renderedHtml = htmlWarnings + engine.render(this.htmlBody, model);
            renderedHtml = htmlSanitizer.sanitize((String)renderedHtml);
            builder.htmlBody((String)renderedHtml);
        }
        if (this.htmlBody == null && this.textBody == null && !Strings.isNullOrEmpty((String)textWarnings)) {
            builder.textBody(textWarnings);
        }
        return builder;
    }

    private static Email.AddressList templatesToAddressList(TextTemplateEngine engine, TextTemplate[] templates, Map<String, Object> model) throws AddressException {
        ArrayList<Email.Address> addresses = new ArrayList<Email.Address>(templates.length);
        for (TextTemplate template : templates) {
            Email.AddressList.parse(engine.render(template, model)).forEach(addresses::add);
        }
        return new Email.AddressList(addresses);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmailTemplate that = (EmailTemplate)o;
        return Objects.equals(this.from, that.from) && Arrays.equals(this.replyTo, that.replyTo) && Objects.equals(this.priority, that.priority) && Arrays.equals(this.to, that.to) && Arrays.equals(this.cc, that.cc) && Arrays.equals(this.bcc, that.bcc) && Objects.equals(this.subject, that.subject) && Objects.equals(this.textBody, that.textBody) && Objects.equals(this.htmlBody, that.htmlBody);
    }

    public int hashCode() {
        return Objects.hash(this.from, this.replyTo, this.priority, this.to, this.cc, this.bcc, this.subject, this.textBody, this.htmlBody);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.xContentBody(builder, params);
        return builder.endObject();
    }

    public XContentBuilder xContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.from != null) {
            builder.field(Email.Field.FROM.getPreferredName(), (ToXContent)this.from, params);
        }
        if (this.replyTo != null) {
            builder.startArray(Email.Field.REPLY_TO.getPreferredName());
            for (TextTemplate template : this.replyTo) {
                template.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.priority != null) {
            builder.field(Email.Field.PRIORITY.getPreferredName(), (ToXContent)this.priority, params);
        }
        if (this.to != null) {
            builder.startArray(Email.Field.TO.getPreferredName());
            for (TextTemplate template : this.to) {
                template.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.cc != null) {
            builder.startArray(Email.Field.CC.getPreferredName());
            for (TextTemplate template : this.cc) {
                template.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.bcc != null) {
            builder.startArray(Email.Field.BCC.getPreferredName());
            for (TextTemplate template : this.bcc) {
                template.toXContent(builder, params);
            }
            builder.endArray();
        }
        if (this.subject != null) {
            builder.field(Email.Field.SUBJECT.getPreferredName(), (ToXContent)this.subject, params);
        }
        if (this.textBody != null || this.htmlBody != null) {
            builder.startObject(Email.Field.BODY.getPreferredName());
            if (this.textBody != null) {
                builder.field(Email.Field.BODY_TEXT.getPreferredName(), (ToXContent)this.textBody, params);
            }
            if (this.htmlBody != null) {
                builder.field(Email.Field.BODY_HTML.getPreferredName(), (ToXContent)this.htmlBody, params);
            }
            builder.endObject();
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private TextTemplate from;
        private TextTemplate[] replyTo;
        private TextTemplate priority;
        private TextTemplate[] to;
        private TextTemplate[] cc;
        private TextTemplate[] bcc;
        private TextTemplate subject;
        private TextTemplate textBody;
        private TextTemplate htmlBody;

        private Builder() {
        }

        public Builder from(String from) {
            return this.from(new TextTemplate(from));
        }

        public Builder from(TextTemplate from) {
            this.from = from;
            return this;
        }

        public Builder replyTo(String ... replyTo) {
            TextTemplate[] templates = new TextTemplate[replyTo.length];
            for (int i = 0; i < templates.length; ++i) {
                templates[i] = new TextTemplate(replyTo[i]);
            }
            return this.replyTo(templates);
        }

        public Builder replyTo(TextTemplate ... replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder priority(Email.Priority priority) {
            return this.priority(new TextTemplate(priority.name()));
        }

        public Builder priority(TextTemplate priority) {
            this.priority = priority;
            return this;
        }

        public Builder to(String ... to) {
            TextTemplate[] templates = new TextTemplate[to.length];
            for (int i = 0; i < templates.length; ++i) {
                templates[i] = new TextTemplate(to[i]);
            }
            return this.to(templates);
        }

        public Builder to(TextTemplate ... to) {
            this.to = to;
            return this;
        }

        public Builder cc(String ... cc) {
            TextTemplate[] templates = new TextTemplate[cc.length];
            for (int i = 0; i < templates.length; ++i) {
                templates[i] = new TextTemplate(cc[i]);
            }
            return this.cc(templates);
        }

        public Builder cc(TextTemplate ... cc) {
            this.cc = cc;
            return this;
        }

        public Builder bcc(String ... bcc) {
            TextTemplate[] templates = new TextTemplate[bcc.length];
            for (int i = 0; i < templates.length; ++i) {
                templates[i] = new TextTemplate(bcc[i]);
            }
            return this.bcc(templates);
        }

        public Builder bcc(TextTemplate ... bcc) {
            this.bcc = bcc;
            return this;
        }

        public Builder subject(String subject) {
            return this.subject(new TextTemplate(subject));
        }

        public Builder subject(TextTemplate subject) {
            this.subject = subject;
            return this;
        }

        public Builder textBody(String text) {
            return this.textBody(new TextTemplate(text));
        }

        public Builder textBody(TextTemplate text) {
            this.textBody = text;
            return this;
        }

        public Builder htmlBody(String html) {
            return this.htmlBody(new TextTemplate(html));
        }

        public Builder htmlBody(TextTemplate html) {
            this.htmlBody = html;
            return this;
        }

        public EmailTemplate build() {
            return new EmailTemplate(this.from, this.replyTo, this.priority, this.to, this.cc, this.bcc, this.subject, this.textBody, this.htmlBody);
        }
    }

    public static class Parser {
        private final Builder builder = EmailTemplate.builder();

        public boolean handle(String fieldName, XContentParser parser) throws IOException {
            if (Email.Field.FROM.match(fieldName, parser.getDeprecationHandler())) {
                this.builder.from(TextTemplate.parse(parser));
                Parser.validateEmailAddresses(this.builder.from);
            } else if (Email.Field.REPLY_TO.match(fieldName, parser.getDeprecationHandler())) {
                if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    ArrayList<TextTemplate> templates = new ArrayList<TextTemplate>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        templates.add(TextTemplate.parse(parser));
                    }
                    this.builder.replyTo(templates.toArray(new TextTemplate[templates.size()]));
                } else {
                    this.builder.replyTo(TextTemplate.parse(parser));
                }
                Parser.validateEmailAddresses(this.builder.replyTo);
            } else if (Email.Field.TO.match(fieldName, parser.getDeprecationHandler())) {
                if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    ArrayList<TextTemplate> templates = new ArrayList<TextTemplate>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        templates.add(TextTemplate.parse(parser));
                    }
                    this.builder.to(templates.toArray(new TextTemplate[templates.size()]));
                } else {
                    this.builder.to(TextTemplate.parse(parser));
                }
                Parser.validateEmailAddresses(this.builder.to);
            } else if (Email.Field.CC.match(fieldName, parser.getDeprecationHandler())) {
                if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    ArrayList<TextTemplate> templates = new ArrayList<TextTemplate>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        templates.add(TextTemplate.parse(parser));
                    }
                    this.builder.cc(templates.toArray(new TextTemplate[templates.size()]));
                } else {
                    this.builder.cc(TextTemplate.parse(parser));
                }
                Parser.validateEmailAddresses(this.builder.cc);
            } else if (Email.Field.BCC.match(fieldName, parser.getDeprecationHandler())) {
                if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                    ArrayList<TextTemplate> templates = new ArrayList<TextTemplate>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        templates.add(TextTemplate.parse(parser));
                    }
                    this.builder.bcc(templates.toArray(new TextTemplate[templates.size()]));
                } else {
                    this.builder.bcc(TextTemplate.parse(parser));
                }
                Parser.validateEmailAddresses(this.builder.bcc);
            } else if (Email.Field.PRIORITY.match(fieldName, parser.getDeprecationHandler())) {
                this.builder.priority(TextTemplate.parse(parser));
            } else if (Email.Field.SUBJECT.match(fieldName, parser.getDeprecationHandler())) {
                this.builder.subject(TextTemplate.parse(parser));
            } else if (Email.Field.BODY.match(fieldName, parser.getDeprecationHandler())) {
                if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                    this.builder.textBody(TextTemplate.parse(parser));
                } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                    XContentParser.Token token;
                    String currentFieldName = null;
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (token == XContentParser.Token.FIELD_NAME) {
                            currentFieldName = parser.currentName();
                            continue;
                        }
                        if (currentFieldName == null) {
                            throw new ElasticsearchParseException("could not parse email template. empty [{}] field", new Object[]{fieldName});
                        }
                        if (Email.Field.BODY_TEXT.match(currentFieldName, parser.getDeprecationHandler())) {
                            this.builder.textBody(TextTemplate.parse(parser));
                            continue;
                        }
                        if (Email.Field.BODY_HTML.match(currentFieldName, parser.getDeprecationHandler())) {
                            this.builder.htmlBody(TextTemplate.parse(parser));
                            continue;
                        }
                        throw new ElasticsearchParseException("could not parse email template. unknown field [{}.{}] field", new Object[]{fieldName, currentFieldName});
                    }
                }
            } else {
                return false;
            }
            return true;
        }

        static void validateEmailAddresses(TextTemplate ... emails) {
            for (TextTemplate emailTemplate : emails) {
                if (emailTemplate.mayRequireCompilation()) continue;
                String email = emailTemplate.getTemplate();
                try {
                    for (Email.Address address : Email.AddressList.parse(email)) {
                        address.validate();
                    }
                }
                catch (AddressException e) {
                    throw new ElasticsearchParseException("invalid email address [{}]", (Throwable)e, new Object[]{email});
                }
            }
        }

        public EmailTemplate parsedTemplate() {
            return this.builder.build();
        }
    }
}

