/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.notification.email;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.watcher.support.Exceptions;
import org.elasticsearch.xpack.core.watcher.watch.Payload;
import org.elasticsearch.xpack.watcher.notification.email.Attachment;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DataAttachment implements ToXContentObject
{
    YAML{

        @Override
        public String contentType() {
            return XContentType.YAML.mediaType();
        }

        @Override
        public Attachment create(String id, Map<String, Object> data) {
            return new Attachment.XContent.Yaml(id, id, (ToXContent)new Payload.Simple(data));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(Field.FORMAT.getPreferredName(), "yaml").endObject();
        }
    }
    ,
    JSON{

        @Override
        public String contentType() {
            return XContentType.JSON.mediaType();
        }

        @Override
        public Attachment create(String id, Map<String, Object> data) {
            return new Attachment.XContent.Json(id, id, (ToXContent)new Payload.Simple(data));
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(Field.FORMAT.getPreferredName(), "json").endObject();
        }
    };

    public static DataAttachment DEFAULT;

    public abstract String contentType();

    public abstract Attachment create(String var1, Map<String, Object> var2);

    public static DataAttachment resolve(String format) {
        switch (format.toLowerCase(Locale.ROOT)) {
            case "yaml": {
                return YAML;
            }
            case "json": {
                return JSON;
            }
        }
        throw Exceptions.illegalArgument((String)"unknown data attachment format [{}]", (Object[])new Object[]{format});
    }

    public static DataAttachment parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.VALUE_BOOLEAN) {
            return parser.booleanValue() ? DEFAULT : null;
        }
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("could not parse data attachment. expected either a boolean value or an object but found [{}] instead", new Object[]{token});
        }
        DataAttachment dataAttachment = DEFAULT;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (currentFieldName == null) {
                throw new ElasticsearchParseException("could not parse data attachment. expected [{}] field but found [{}] instead", new Object[]{Field.FORMAT.getPreferredName(), token});
            }
            if (Field.FORMAT.match(currentFieldName, parser.getDeprecationHandler())) {
                if (token == XContentParser.Token.VALUE_STRING) {
                    dataAttachment = DataAttachment.resolve(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("could not parse data attachment. expected string value for [{}] field but found [{}] instead", new Object[]{currentFieldName, token});
            }
            throw new ElasticsearchParseException("could not parse data attachment. unexpected field [{}]", new Object[]{currentFieldName});
        }
        return dataAttachment;
    }

    static {
        DEFAULT = YAML;
    }

    static interface Field {
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

